/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hostobjects.sso;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.Subject;
import org.opensaml.xml.XMLObject;
import org.wso2.carbon.hostobjects.sso.internal.SessionInfo;
import org.wso2.carbon.hostobjects.sso.internal.builder.AuthReqBuilder;
import org.wso2.carbon.hostobjects.sso.internal.builder.LogoutRequestBuilder;
import org.wso2.carbon.hostobjects.sso.internal.util.Util;

public class SAMLSSORelyingPartyObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(SAMLSSORelyingPartyObject.class);
    private Properties ssoConfigProperties = new Properties();
    private static Map<String, String> relayStateMap = new HashMap<String, String>();
    private static Map<String, SAMLSSORelyingPartyObject> ssoRelyingPartyMap = new HashMap<String, SAMLSSORelyingPartyObject>();
    private static Map<String, SessionInfo> sessionIdMap = new ConcurrentHashMap<String, SessionInfo>();
    private String loggedInUserName;

    public String getClassName() {
        return "SSORelyingParty";
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid arguments!, IssuerId is missing in parameters.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = ssoRelyingPartyMap.get((String)args[0]);
        if (relyingPartyObject == null) {
            relyingPartyObject = new SAMLSSORelyingPartyObject();
            relyingPartyObject.setSSOProperty("issuerId", (String)args[0]);
            ssoRelyingPartyMap.put((String)args[0], relyingPartyObject);
        }
        return relyingPartyObject;
    }

    public static boolean jsFunction_validateSignature(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. SAML response is missing.");
        }
        XMLObject samlObject = Util.unmarshall((String)args[0]);
        if (samlObject instanceof Response) {
            Response samlResponse = (Response)samlObject;
            SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
            return Util.validateSignature(samlResponse, relyingPartyObject.getSSOProperty("keyStoreName"), relyingPartyObject.getSSOProperty("keyStorePassword"), relyingPartyObject.getSSOProperty("identityAlias"));
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)"SAML response in signature validation is not a SAML Response.");
        }
        return false;
    }

    public static boolean jsFunction_isLogoutRequest(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. Logout request xml is missing.");
        }
        XMLObject samlObject = Util.unmarshall(SAMLSSORelyingPartyObject.decode((String)args[0]));
        return samlObject instanceof LogoutRequest;
    }

    public static boolean jsFunction_isLogoutResponse(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. Logout response xml is missing.");
        }
        XMLObject samlObject = Util.unmarshall((String)args[0]);
        return samlObject instanceof LogoutResponse;
    }

    public static String jsFunction_encode(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. String to be encoded is missing.");
        }
        return Util.encode((String)args[0]);
    }

    public static String jsFunction_decode(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. String to be decoded is missing.");
        }
        return Util.decode((String)args[0]);
    }

    public static String jsFunction_getUUID(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        return UUID.randomUUID().toString();
    }

    public static String jsFunction_getSAMLAuthRequest(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        return Util.marshall((XMLObject)new AuthReqBuilder().buildAuthenticationRequest(relyingPartyObject.getSSOProperty("issuerId")));
    }

    public static String jsFunction_getSAMLLogoutRequest(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. The user to be logout is missing.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        return Util.marshall((XMLObject)new LogoutRequestBuilder().buildLogoutRequest((String)args[0], "urn:oasis:names:tc:SAML:2.0:logout:user", relyingPartyObject.getSSOProperty("issuerId")));
    }

    public static String jsFunction_getSAMLResponseNameId(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. The SAML response is missing.");
        }
        XMLObject samlObject = Util.unmarshall((String)args[0]);
        String username = "anonymous user";
        if (samlObject instanceof Response) {
            Subject subject;
            Response samlResponse = (Response)samlObject;
            List assertions = samlResponse.getAssertions();
            if (assertions != null && assertions.size() > 0 && (subject = ((Assertion)assertions.get(0)).getSubject()) != null && subject.getNameID() != null) {
                username = subject.getNameID().getValue();
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Provided SAML response in is not a SAML Response. So default user name:" + username + " is provided."));
        }
        return username;
    }

    public static void jsFunction_setProperty(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        int argLength = args.length;
        if (argLength != 2 || !(args[0] instanceof String) || !(args[1] instanceof String)) {
            throw new ScriptException("Invalid arguments when setting sso configuration values.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        relyingPartyObject.setSSOProperty((String)args[0], (String)args[1]);
    }

    public static boolean jsFunction_isSessionAuthenticated(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. Session id is missing.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        return relyingPartyObject.isSessionIdExists((String)args[0]);
    }

    public static String jsFunction_getLoggedInUser(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. Session id is missing.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        SessionInfo sessionInfo = relyingPartyObject.getSessionInfo((String)args[0]);
        String loggedInUser = "anonymous user";
        if (sessionInfo != null && sessionInfo.getLoggedInUser() != null) {
            loggedInUser = sessionInfo.getLoggedInUser();
        }
        return loggedInUser;
    }

    public static void jsFunction_invalidateSessionBySAMLResponse(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        LogoutRequest samlLogoutRequest;
        List sessionIndexes;
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. SAML log out request is missing.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        XMLObject samlObject = Util.unmarshall(SAMLSSORelyingPartyObject.decode((String)args[0]));
        String sessionIndex = null;
        if (samlObject instanceof LogoutRequest && (sessionIndexes = (samlLogoutRequest = (LogoutRequest)samlObject).getSessionIndexes()) != null && sessionIndexes.size() > 0) {
            sessionIndex = ((SessionIndex)sessionIndexes.get(0)).getSessionIndex();
        }
        if (sessionIndex == null) {
            throw new Exception("Failed to get session index from session indexes in SAML logout request.");
        }
        relyingPartyObject.invalidateSessionBySessionIndex(sessionIndex);
        SAMLSSORelyingPartyObject.invalidateRelyingPartyObject(relyingPartyObject.getSSOProperty("issuerId"));
    }

    public static void jsFunction_invalidateSessionBySessionId(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. Session id is missing.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        relyingPartyObject.invalidateSessionBySessionId((String)args[0]);
        SAMLSSORelyingPartyObject.invalidateRelyingPartyObject(relyingPartyObject.getSSOProperty("issuerId"));
    }

    public static void jsFunction_setSessionAuthenticated(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int argLength = args.length;
        if (argLength != 2 || !(args[0] instanceof String) || !(args[1] instanceof String)) {
            throw new ScriptException("Invalid argument. Current session id and SAML response are missing.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        XMLObject samlObject = Util.unmarshall((String)args[1]);
        String sessionIndex = null;
        String username = "anonymous user";
        if (samlObject instanceof Response) {
            Subject subject;
            List authenticationStatements;
            AuthnStatement authnStatement;
            Response samlResponse = (Response)samlObject;
            List assertions = samlResponse.getAssertions();
            if (assertions != null && assertions.size() > 0 && (authnStatement = (AuthnStatement)(authenticationStatements = ((Assertion)assertions.get(0)).getAuthnStatements()).get(0)) != null && authnStatement.getSessionIndex() != null) {
                sessionIndex = authnStatement.getSessionIndex();
            }
            if (assertions != null && assertions.size() > 0 && (subject = ((Assertion)assertions.get(0)).getSubject()) != null && subject.getNameID() != null) {
                username = subject.getNameID().getValue();
            }
        }
        if (sessionIndex == null) {
            throw new Exception("Failed to get session index from authentication statement in SAML response.");
        }
        SessionInfo sessionInfo = new SessionInfo((String)args[0]);
        sessionInfo.setSessionIndex(sessionIndex);
        sessionInfo.setLoggedInUser(username);
        relyingPartyObject.addSessionInfo(sessionInfo);
    }

    public static String jsFunction_getProperty(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. SSO configuratin key is missing.");
        }
        SAMLSSORelyingPartyObject relyingPartyObject = (SAMLSSORelyingPartyObject)thisObj;
        return relyingPartyObject.getSSOProperty((String)args[0]);
    }

    public static void jsFunction_setRelayStateProperty(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        int argLength = args.length;
        if (argLength != 2 || !(args[0] instanceof String) || !(args[1] instanceof String)) {
            throw new ScriptException("Invalid argument. RelayState and requested URI are missing.");
        }
        relayStateMap.put((String)args[0], (String)args[1]);
    }

    public static String jsFunction_getRelayStateProperty(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        int argLength = args.length;
        if (argLength != 1 || !(args[0] instanceof String)) {
            throw new ScriptException("Invalid argument. Relay state value is missing.");
        }
        String requestedURI = relayStateMap.get((String)args[0]);
        relayStateMap.remove((String)args[0]);
        return requestedURI;
    }

    private String getSSOProperty(String key) {
        return this.ssoConfigProperties.getProperty(key);
    }

    private void setSSOProperty(String key, String value) {
        this.ssoConfigProperties.put(key, value);
    }

    public static String decode(String xmlString) {
        xmlString = xmlString.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&apos;", "'").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
        return xmlString;
    }

    private void addSessionInfo(SessionInfo sessionInfo) {
        sessionIdMap.put(sessionInfo.getSessionId(), sessionInfo);
    }

    private void invalidateSessionBySessionIndex(String sessionIndex) {
        for (Map.Entry<String, SessionInfo> entry : sessionIdMap.entrySet()) {
            SessionInfo sessionInfo;
            if (!(entry.getValue() instanceof SessionInfo) || (sessionInfo = entry.getValue()) == null || !sessionIndex.equals(sessionInfo.getSessionIndex())) continue;
            sessionIdMap.remove(entry.getKey());
        }
    }

    private void invalidateSessionBySessionId(String sessionId) {
        sessionIdMap.remove(sessionId);
    }

    private boolean isSessionIdExists(String sessionId) {
        return sessionIdMap.containsKey(sessionId);
    }

    private SessionInfo getSessionInfo(String sessionId) {
        return sessionIdMap.get(sessionId);
    }

    private static void invalidateRelyingPartyObject(String issuerId) {
        ssoRelyingPartyMap.remove(issuerId);
    }
}

