/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.userstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.ldap.ReadWriteLDAPUserStoreManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;

public class AppFactoryUserStore
extends ReadWriteLDAPUserStoreManager {
    public AppFactoryUserStore(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId);
    }

    public AppFactoryUserStore(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        super(realmConfig, claimManager, profileManager);
    }

    public boolean authenticate(String username, Object credential) throws UserStoreException {
        String[] roles;
        boolean isAuthenticated = false;
        isAuthenticated = super.authenticate(username, credential);
        if (isAuthenticated && (roles = this.getRoleListOfUser(username)).length > 0) {
            return true;
        }
        return isAuthenticated;
    }

    public String[] listUsers(String arg0, int maxItemLimit) throws UserStoreException {
        String[] roles = this.getRoleNames();
        ArrayList<String> users = new ArrayList<String>();
        for (String role : roles) {
            String[] usersInRole = this.getUserListOfRole(role);
            users.addAll(Arrays.asList(usersInRole));
        }
        return users.toArray(new String[users.size()]);
    }

    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        if (!this.isExistingUser(userName)) {
            super.addUser(userName, credential, roleList, claims, profileName);
        }
    }

    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        if (!this.isExistingUser(userName)) {
            super.addUser(userName, credential, roleList, claims, profileName, requirePasswordChange);
        }
    }

    public void updateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        String passwordValue = (String)newCredential;
        if (passwordValue != null && passwordValue.trim().length() > 0) {
            super.updateCredentialByAdmin(userName, newCredential);
        }
    }
}

