/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.userstore;

import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.sql.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.ldap.LDAPConnectionContext;
import org.wso2.carbon.user.core.tenant.CommonHybridLDAPTenantManager;
import org.wso2.carbon.user.core.tenant.Tenant;

public class AppFactoryTenantManager
extends CommonHybridLDAPTenantManager {
    private static Log logger = LogFactory.getLog(AppFactoryTenantManager.class);
    private LDAPConnectionContext ldapConnectionSource;
    private TenantMgtConfiguration tenantMgtConfig = null;
    private RealmConfiguration realmConfig = null;

    public AppFactoryTenantManager(OMElement omElement, Map<String, Object> properties) throws Exception {
        super(omElement, properties);
        this.ldapConnectionSource = (LDAPConnectionContext)properties.get("ldapConnectionSource");
        if (this.ldapConnectionSource == null) {
            throw new UserStoreException("LDAP connection context is not set in properties with key - ldapConnectionSource");
        }
        this.tenantMgtConfig = (TenantMgtConfiguration)properties.get("tenantMgtConfiguration");
        this.realmConfig = (RealmConfiguration)properties.get("userMgtConfiguration");
    }

    public AppFactoryTenantManager(DataSource dataSource, String superTenantDomain) {
        super(dataSource, superTenantDomain);
    }

    protected void createOrganizationalUnit(String orgName, Tenant tenant, DirContext initialDirContext) throws UserStoreException {
        String partitionDN = (String)this.tenantMgtConfig.getTenantStoreProperties().get("RootPartition");
        this.createOrganizationalContext(partitionDN, orgName, initialDirContext);
        String organizationNameAttribute = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
        String dnOfOrganizationalContext = organizationNameAttribute + "=" + orgName + "," + partitionDN;
        this.createOrganizationalSubContext(dnOfOrganizationalContext, "groups", initialDirContext);
        String orgSubContextAttribute = (String)this.tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
        String dnOfUserContext = orgSubContextAttribute + "=" + "users" + "," + partitionDN;
        String dnOfUserEntry = this.getAdminEntryDN(dnOfUserContext, tenant, initialDirContext);
        if ("true".equals(this.realmConfig.getUserStoreProperty("WriteLDAPGroups"))) {
            String dnOfGroupContext = orgSubContextAttribute + "=" + "groups" + "," + dnOfOrganizationalContext;
            this.createAdminGroup(dnOfGroupContext, dnOfUserEntry, initialDirContext);
        }
    }

    private String getAdminEntryDN(String dnOfUserContext, Tenant tenant, DirContext initialDirContext) throws UserStoreException {
        String userDN = null;
        DirContext organizationalUsersContext = null;
        try {
            organizationalUsersContext = (DirContext)initialDirContext.lookup(dnOfUserContext);
            String userNameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
            String userRDN = userNameAttribute + "=" + tenant.getAdminName();
            userDN = userRDN + "," + dnOfUserContext;
        }
        catch (NamingException e) {
            String errorMsg = "Error occurred while creating Admin entry";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new UserStoreException(errorMsg, (Throwable)e);
        }
        finally {
            this.closeContext(organizationalUsersContext);
        }
        return userDN;
    }
}

