/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.userstore;

import java.util.Map;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.tenant.Tenant;

public class AppFactoryRealmConfigBuilder
implements MultiTenantRealmConfigBuilder {
    private static Log logger = LogFactory.getLog(AppFactoryRealmConfigBuilder.class);

    public RealmConfiguration getRealmConfigForTenantToCreateRealm(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }

    public RealmConfiguration getRealmConfigForTenantToPersist(RealmConfiguration bootStrapConfig, TenantMgtConfiguration tenantMgtConfig, Tenant tenantInfo, int tenantId) throws UserStoreException {
        try {
            RealmConfiguration ldapRealmConfig = bootStrapConfig.cloneRealmConfiguration();
            ldapRealmConfig.setAdminPassword(UIDGenerator.generateUID());
            ldapRealmConfig.setAdminUserName(tenantInfo.getAdminName());
            ldapRealmConfig.setTenantId(tenantId);
            Map authz = ldapRealmConfig.getAuthzProperties();
            authz.put("AdminRoleManagementPermissions", "/permission/admin");
            Map userStoreProperties = ldapRealmConfig.getUserStoreProperties();
            String partitionDN = (String)tenantMgtConfig.getTenantStoreProperties().get("RootPartition");
            String organizationName = tenantInfo.getDomain();
            String organizationRDN = (String)tenantMgtConfig.getTenantStoreProperties().get("OrganizationalAttribute") + "=" + organizationName;
            String orgSubContextAttribute = (String)tenantMgtConfig.getTenantStoreProperties().get("OrganizationalSubContextAttribute");
            if ("true".equals(bootStrapConfig.getUserStoreProperty("ReadLDAPGroups"))) {
                String groupContextRDN = orgSubContextAttribute + "=" + "groups";
                String groupSearchBase = groupContextRDN + "," + organizationRDN + "," + partitionDN;
                userStoreProperties.put("GroupSearchBase", groupSearchBase);
            }
            return ldapRealmConfig;
        }
        catch (Exception e) {
            String errorMessage = "Error while building tenant specific Realm Configuration.";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, (Throwable)e);
        }
    }

    public RealmConfiguration getRealmConfigForTenantToCreateRealmOnTenantCreation(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }
}

