/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.governance.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.appfactory.governance.internal.ServiceReferenceHolder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileUtil;

public class AppFactoryRXTServiceComponent {
    private static final Log log = LogFactory.getLog(AppFactoryRXTServiceComponent.class);

    protected void activate(ComponentContext context) {
        log.info((Object)"AppFactoryRXTServiceComponent activating...");
        BundleContext bundleContext = context.getBundleContext();
        try {
            this.addRxtConfigs();
        }
        catch (Exception e) {
            log.error((Object)"Can not add rxts", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Appfactory common bundle is activated");
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Appfactory common bundle is deactivated");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        if (registryService != null && log.isDebugEnabled()) {
            log.debug((Object)"Registry service initialized");
        }
        ServiceReferenceHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        ServiceReferenceHolder.getInstance().setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        if (realmService != null && log.isDebugEnabled()) {
            log.debug((Object)"Realm service initialized");
        }
        ServiceReferenceHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        ServiceReferenceHolder.getInstance().setRealmService(null);
    }

    private void addRxtConfigs() throws Exception {
        UserRegistry registry;
        UserRegistry systemRegistry;
        String rxtDir = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "rxts";
        File file = new File(rxtDir);
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rxt");
            }
        };
        String[] rxtFilePaths = file.list(filenameFilter);
        RegistryService registryService = ServiceReferenceHolder.getInstance().getRegistryService();
        try {
            systemRegistry = registryService.getRegistry("wso2.system.user");
            registry = registryService.getRegistry();
        }
        catch (RegistryException e) {
            throw new Exception("Failed to get registry", e);
        }
        for (String rxtPath : rxtFilePaths) {
            String msg;
            String resourcePath = "/_system/governance/repository/components/org.wso2.carbon.governance/types/" + rxtPath;
            try {
                if (registry.resourceExists(resourcePath)) continue;
                String rxt = FileUtil.readFileToString((String)(rxtDir + File.separator + rxtPath));
                Resource resource = registry.newResource();
                resource.setContent((Object)rxt.getBytes());
                resource.setMediaType("application/vnd.wso2.registry-ext-type+xml");
                systemRegistry.put(resourcePath, resource);
            }
            catch (IOException e) {
                msg = "Failed to read rxt files";
                throw new Exception(msg, e);
            }
            catch (RegistryException e) {
                msg = "Failed to add rxt to registry ";
                throw new Exception(msg, e);
            }
        }
    }
}

