/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.appfactory.common.AppFactoryConfiguration;
import org.wso2.carbon.appfactory.core.ArtifactStorage;
import org.wso2.carbon.appfactory.core.BuildDriver;
import org.wso2.carbon.appfactory.core.RevisionControlDriver;
import org.wso2.carbon.appfactory.core.internal.ServiceHolder;

public class AppFactoryCoreServiceComponent {
    private static final Log log = LogFactory.getLog(AppFactoryCoreServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Appfactory core bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error in creating appfactory configuration", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Appfactory common bundle is deactivated");
        }
    }

    protected void unsetBuildDriver(BuildDriver buildDriver) {
        ServiceHolder.setBuildDriver(null);
    }

    protected void setBuildDriver(BuildDriver buildDriver) {
        ServiceHolder.setBuildDriver(buildDriver);
    }

    protected void unsetRevisionControlDriver(RevisionControlDriver revisionControlDriver) {
        ServiceHolder.setRevisionControlDriver(null);
    }

    protected void setRevisionControlDriver(RevisionControlDriver revisionControlDriver) {
        ServiceHolder.setRevisionControlDriver(revisionControlDriver);
    }

    protected void unsetArtifactStorage(ArtifactStorage artifactStorage) {
        ServiceHolder.setArtifactStorage(null);
    }

    protected void setArtifactStorage(ArtifactStorage artifactStorage) {
        ServiceHolder.setArtifactStorage(artifactStorage);
    }

    protected void setAppFactoryConfiguration(AppFactoryConfiguration appFactoryConfiguration) {
        ServiceHolder.setAppFactoryConfiguration(appFactoryConfiguration);
    }

    protected void unsetAppFactoryConfiguration(AppFactoryConfiguration appFactoryConfiguration) {
        ServiceHolder.setAppFactoryConfiguration(null);
    }
}

