/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.core.deploy;

import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.wso2.carbon.application.mgt.stub.upload.CarbonAppUploaderStub;
import org.wso2.carbon.application.mgt.stub.upload.types.carbon.UploadedFileItem;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;

public class ArtifactUploadClient {
    private String authCookie;
    private String backendServerURL;

    public ArtifactUploadClient(String backendServerURL) {
        if (!backendServerURL.endsWith("/")) {
            backendServerURL = backendServerURL + "/";
        }
        this.backendServerURL = backendServerURL;
    }

    public boolean authenticate(String userName, String password, String remoteIp) throws Exception {
        String serviceURL = this.backendServerURL + "AuthenticationAdmin";
        AuthenticationAdminStub authStub = new AuthenticationAdminStub(serviceURL);
        authStub._getServiceClient().getOptions().setManageSession(true);
        boolean authenticate = authStub.login(userName, password, remoteIp);
        this.authCookie = (String)authStub._getServiceClient().getServiceContext().getProperty("Cookie");
        return authenticate;
    }

    public void uploadCarbonApp(UploadedFileItem[] uploadedFileItems) throws Exception {
        String serviceURL = this.backendServerURL + "CarbonAppUploader";
        CarbonAppUploaderStub carbonAppUploader = new CarbonAppUploaderStub(serviceURL);
        ServiceClient client = carbonAppUploader._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)this.authCookie);
        carbonAppUploader.uploadApp(uploadedFileItems);
    }
}

