/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.core.deploy;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.core.ArtifactStorage;
import org.wso2.carbon.appfactory.core.deploy.ArtifactDeploymentStatusBean;
import org.wso2.carbon.appfactory.core.deploy.ArtifactUploadClient;
import org.wso2.carbon.appfactory.core.internal.ServiceHolder;
import org.wso2.carbon.application.mgt.stub.upload.types.carbon.UploadedFileItem;

public class ApplicationDeployer {
    private static final Log log = LogFactory.getLog(ApplicationDeployer.class);

    public ArtifactDeploymentStatusBean[] deployArtifact(String applicationId, String stage, String version, String revision) throws AppFactoryException {
        ArtifactStorage storage = ServiceHolder.getArtifactStorage();
        File file = storage.retrieveArtifact(applicationId, version, revision);
        String key = "ApplicationDeployment.DeploymentStage" + "." + stage + "." + "DeploymentServerURL";
        String[] deploymentServerUrls = ServiceHolder.getAppFactoryConfiguration().getProperties(key);
        if (deploymentServerUrls.length == 0) {
            this.handleException("No deployment paths are configured for stage:" + stage);
        }
        ArtifactDeploymentStatusBean[] artifactDeploymentStatuses = new ArtifactDeploymentStatusBean[deploymentServerUrls.length];
        for (int i = 0; i < deploymentServerUrls.length; ++i) {
            try {
                String deploymentServerIp = this.getDeploymentHostFromUrl(deploymentServerUrls[i]);
                ArtifactUploadClient artifactUploadClient = new ArtifactUploadClient(deploymentServerUrls[i]);
                UploadedFileItem uploadedFileItem = new UploadedFileItem();
                DataHandler dataHandler = new DataHandler((DataSource)new FileDataSource(file));
                uploadedFileItem.setDataHandler(dataHandler);
                uploadedFileItem.setFileName(file.getName());
                uploadedFileItem.setFileType("jar");
                UploadedFileItem[] uploadedFileItems = new UploadedFileItem[]{uploadedFileItem};
                if (artifactUploadClient.authenticate(this.getAdminUsername(applicationId), this.getServerAdminPassword(), deploymentServerIp)) {
                    artifactUploadClient.uploadCarbonApp(uploadedFileItems);
                    log.debug((Object)(file.getName() + " is successfully uploaded."));
                } else {
                    this.handleException("Failed to login to " + deploymentServerIp + " to deploy the artifact:" + file.getName());
                }
                artifactDeploymentStatuses[i] = new ArtifactDeploymentStatusBean(applicationId, stage, version, revision, deploymentServerUrls[i], "success", null);
                continue;
            }
            catch (Exception e) {
                artifactDeploymentStatuses[i] = new ArtifactDeploymentStatusBean(applicationId, stage, version, revision, deploymentServerUrls[i], "failed", e.getMessage());
                this.handleException("Failed to upload the artifact:" + file.getName() + " of application:" + applicationId + " to deployment location:" + deploymentServerUrls[i]);
            }
        }
        return artifactDeploymentStatuses;
    }

    private String getAdminUsername(String applicationId) {
        return ServiceHolder.getAppFactoryConfiguration().getFirstProperty("AdminUserName") + "@" + applicationId;
    }

    private String getServerAdminPassword() {
        return ServiceHolder.getAppFactoryConfiguration().getFirstProperty("AdminPassword");
    }

    private void handleException(String msg) throws AppFactoryException {
        log.error((Object)msg);
        throw new AppFactoryException(msg);
    }

    private void handleException(String msg, Throwable throwable) throws AppFactoryException {
        log.error((Object)msg, throwable);
        throw new AppFactoryException(msg, throwable);
    }

    private String getDeploymentHostFromUrl(String url) throws AppFactoryException {
        String hostName = null;
        try {
            URL deploymentURL = new URL(url);
            hostName = deploymentURL.getHost();
        }
        catch (MalformedURLException e) {
            this.handleException("Deployment url is malformed.", e);
        }
        return hostName;
    }
}

