/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.user.registration.services;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.user.registration.beans.UserRegistrationInfoBean;
import org.wso2.carbon.appfactory.user.registration.services.UserRegistrationException;
import org.wso2.carbon.appfactory.user.registration.util.Util;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserRealm;

public class UserRegistrationService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(UserRegistrationService.class);
    public static final String USER_VALIDATION_KEY_PATH = "org.wso2.carbon.appfactory.user.registration-validation-key";

    public String registerUser(UserRegistrationInfoBean user) throws UserRegistrationException {
        if (!this.doesUserExist(user.getUserName())) {
            return this.addUser(user);
        }
        return null;
    }

    private String addUser(UserRegistrationInfoBean user) throws UserRegistrationException {
        UserStoreManager userStoreManager = this.getUserStoreManager();
        UserRealm realm = this.getUserRealm();
        String[] roles = new String[1];
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("http://wso2.org/claims/emailaddress", user.getEmail());
        claims.put("http://wso2.org/claims/givenname", user.getFirstName());
        claims.put("http://wso2.org/claims/lastname", user.getLastName());
        try {
            roles[0] = realm.getRealmConfiguration().getEveryOneRoleName();
            userStoreManager.addUser(user.getUserName(), (Object)user.getAdminPassword(), roles, claims, null);
        }
        catch (UserStoreException e) {
            this.handleException("Error in adding the user to user store", (Exception)((Object)e));
        }
        return this.generateKey(user.getUserName(), user.getEmail());
    }

    public boolean activateUser(String confirmationKey, String userName, String email) throws UserRegistrationException {
        Registry superTenantRegistry = this.getSuperTenantRegistry();
        String userValidationKeyPath = "org.wso2.carbon.appfactory.user.registration-validation-key/" + userName;
        Resource resource = null;
        try {
            resource = superTenantRegistry.get(userValidationKeyPath);
        }
        catch (ResourceNotFoundException e) {
            this.handleException("Confirmation key is not found for " + userName, (Exception)((Object)e));
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            this.handleException("Error in accessing registry collection " + userValidationKeyPath, (Exception)((Object)e));
        }
        String userEmail = resource.getProperty("email");
        Object userConfirmationKeyObject = null;
        String userConfirmationKey = null;
        try {
            userConfirmationKeyObject = resource.getContent();
        }
        catch (RegistryException e) {
            this.handleException("Error while adding resource to registry", (Exception)((Object)e));
        }
        if (userConfirmationKeyObject instanceof String) {
            userConfirmationKey = (String)userConfirmationKeyObject;
        } else if (userConfirmationKeyObject instanceof byte[]) {
            userConfirmationKey = new String((byte[])userConfirmationKeyObject);
        }
        if (email.equals(userEmail) && confirmationKey.equals(userConfirmationKey)) {
            try {
                superTenantRegistry.delete(userValidationKeyPath);
                this.updateUserRole(userName);
            }
            catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
                this.handleException("Could not delete confirmation key for " + userName, (Exception)((Object)e));
            }
            catch (AppFactoryException e) {
                this.handleException("Failed to add/update default role for user:" + userName, (Exception)((Object)e));
            }
            return true;
        }
        return false;
    }

    private void updateUserRole(String userName) throws UserRegistrationException, AppFactoryException {
        UserRealm realm = this.getUserRealm();
        try {
            org.wso2.carbon.user.core.UserStoreManager userStoreManager = realm.getUserStoreManager();
            String defaultRoleName = Util.getConfiguration().getFirstProperty("ApplicationMgt.DefaultApplicationUserRole");
            if (!userStoreManager.isExistingRole(defaultRoleName)) {
                String defaultPermissionString = Util.getConfiguration().getFirstProperty("ApplicationMgt.DefaultApplicationUserRole." + defaultRoleName + "." + "Permission");
                if (defaultPermissionString == null) {
                    throw new AppFactoryException("Failed to get default application user role permissions.");
                }
                String[] resourceIds = defaultPermissionString.split(",");
                ArrayList<Permission> permissionList = new ArrayList<Permission>();
                for (String resourceId : resourceIds) {
                    Permission permission = new Permission(resourceId, "ui.execute");
                    permissionList.add(permission);
                }
                userStoreManager.addRole(defaultRoleName, new String[]{userName}, (org.wso2.carbon.user.api.Permission[])permissionList.toArray(new Permission[permissionList.size()]));
            } else {
                userStoreManager.updateRoleListOfUser(userName, null, new String[]{defaultRoleName});
            }
        }
        catch (UserStoreException e) {
            this.handleException("Failed to get add/update roles of user:" + userName, (Exception)((Object)e));
        }
    }

    public boolean doesUserExist(String userName) throws UserRegistrationException {
        UserStoreManager userStoreManager = this.getUserStoreManager();
        try {
            return userStoreManager.isExistingUser(userName);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while checking user existance in user store");
            throw new UserRegistrationException();
        }
    }

    private Registry getSuperTenantRegistry() throws UserRegistrationException {
        Registry superTenantRegistry = this.getGovernanceUserRegistry();
        if (superTenantRegistry == null) {
            String msg = "Error while retrieving registry";
            throw new UserRegistrationException(msg);
        }
        return superTenantRegistry;
    }

    private void handleException(String msg, Exception e) throws UserRegistrationException {
        log.error((Object)msg, (Throwable)e);
        throw new UserRegistrationException(msg, e);
    }

    private UserStoreManager getUserStoreManager() throws UserRegistrationException {
        org.wso2.carbon.user.core.UserStoreManager manager = null;
        try {
            manager = this.getUserRealm().getUserStoreManager();
        }
        catch (UserStoreException e) {
            this.handleException("Error in initialising user store", (Exception)((Object)e));
        }
        return manager;
    }

    private String generateKey(String userName, String email) throws UserRegistrationException {
        Registry superTenantRegistry = this.getSuperTenantRegistry();
        String userValidationKeyPath = "org.wso2.carbon.appfactory.user.registration-validation-key/" + userName;
        String confirmationKey = UUIDGenerator.generateUUID();
        try {
            Resource resource = superTenantRegistry.newResource();
            resource.setContent((Object)confirmationKey);
            resource.setProperty("confirmationFlag", "false");
            resource.setProperty("email", email);
            superTenantRegistry.put(userValidationKeyPath, (org.wso2.carbon.registry.api.Resource)resource);
        }
        catch (Exception e) {
            this.handleException("Error while adding resource to registry", e);
        }
        return confirmationKey;
    }
}

