/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.user.registration.services;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.user.registration.services.UserRegistrationException;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.email.sender.api.EmailSender;
import org.wso2.carbon.email.sender.api.EmailSenderConfiguration;
import org.wso2.carbon.email.verification.util.EmailVerifcationSubscriber;
import org.wso2.carbon.email.verification.util.EmailVerifierConfig;
import org.wso2.carbon.email.verification.util.Util;
import org.wso2.carbon.utils.CarbonUtils;

public class EmailSenderService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(EmailSenderService.class);
    public static final String CONFIRMATION_EMAIL_CONFIG = "confirmation-email-config.xml";

    public boolean sendActivationEmail(String userName, String firstName, String activationKey, String email) throws UserRegistrationException {
        EmailVerifcationSubscriber emailVerifier = org.wso2.carbon.appfactory.user.registration.util.Util.getEmailVerificationService();
        HashMap<String, String> dataToStore = new HashMap<String, String>();
        dataToStore.put("first-name", firstName);
        dataToStore.put("email", email);
        dataToStore.put("admin", userName);
        dataToStore.put("confirmationKey", activationKey);
        try {
            emailVerifier.requestUserVerification(dataToStore, this.loadEmailVerificationConfiguration(CONFIRMATION_EMAIL_CONFIG));
        }
        catch (Exception e) {
            String msg = "Activation email sending is failed for  " + userName;
            log.error((Object)msg, (Throwable)e);
            throw new UserRegistrationException(msg, e);
        }
        return true;
    }

    public boolean sendMail(String userName, String firstName, String email, String applicationName, String applicationKey, String config) throws UserRegistrationException {
        EmailSender sender = new EmailSender(this.loadEmailSenderConfiguration(config));
        HashMap<String, String> userParams = new HashMap<String, String>();
        userParams.put("userName", userName);
        userParams.put("firstName", firstName);
        userParams.put("applicationName", applicationName);
        userParams.put("applicationKey", applicationKey);
        try {
            sender.sendEmail(email, userParams);
        }
        catch (Exception e) {
            String msg = "Email sending is failed for  " + email;
            log.error((Object)msg, (Throwable)e);
            throw new UserRegistrationException(msg, e);
        }
        return true;
    }

    private EmailVerifierConfig loadEmailVerificationConfiguration(String configFile) {
        String configFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + configFile;
        return Util.loadeMailVerificationConfig((String)configFilePath);
    }

    private EmailSenderConfiguration loadEmailSenderConfiguration(String configFile) {
        String configFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + configFile;
        return EmailSenderConfiguration.loadEmailSenderConfiguration((String)configFilePath);
    }
}

