/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.maven.build;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutHandler;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.common.util.AppFactoryUtil;
import org.wso2.carbon.appfactory.core.BuildDriver;
import org.wso2.carbon.appfactory.core.BuildDriverListener;

public class Maven2BuildDriver
implements BuildDriver {
    private static final Log log = LogFactory.getLog(Maven2BuildDriver.class);

    public void buildArtifact(String applicationId, String version, String revision, BuildDriverListener listener) throws AppFactoryException {
        File workDir = AppFactoryUtil.getApplicationWorkDirectory((String)applicationId, (String)version, (String)revision);
        String pomFilePath = workDir.getAbsolutePath() + File.separator + "pom.xml";
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            this.handleException("pom.xml file not found at " + pomFilePath);
        }
        this.executeMavenGoal(workDir.getAbsolutePath());
        String targetDirPath = workDir.getAbsolutePath() + File.separator + "target";
        File targetDir = new File(targetDirPath);
        if (!targetDir.exists()) {
            this.handleException("Application build failure.");
            listener.onBuildFailure(applicationId, version, revision, targetDir);
        }
        listener.onBuildSuccessful(applicationId, version, revision, targetDir);
    }

    private void executeMavenGoal(String applicationPath) throws AppFactoryException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setShowErrors(true);
        request.setPomFile(new File(applicationPath + File.separator + "pom.xml"));
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        request.setGoals(goals);
        DefaultInvoker invoker = new DefaultInvoker();
        SystemOutHandler outputHandler = new SystemOutHandler();
        invoker.setErrorHandler((InvocationOutputHandler)outputHandler);
        invoker.setMavenHome(new File(System.getenv("M3_HOME")));
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExecutionException() == null && result.getExitCode() != 0) {
                request.setOffline(true);
                result = invoker.execute((InvocationRequest)request);
                if (result.getExitCode() != 0) {
                    String errorMessage = "No maven Application found at " + applicationPath;
                    this.handleException(errorMessage);
                }
            }
        }
        catch (MavenInvocationException e) {
            this.handleException("Maven invocation failed with error:" + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void handleException(String msg, Exception e) throws AppFactoryException {
        log.error((Object)msg, (Throwable)e);
        throw new AppFactoryException(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AppFactoryException {
        log.error((Object)msg);
        throw new AppFactoryException(msg);
    }
}

