/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.sender.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.sender.api.EmailSenderConfiguration;
import org.wso2.carbon.email.sender.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailSender {
    private static Log log = LogFactory.getLog(EmailSender.class);
    private EmailSenderConfiguration config = null;

    public EmailSender(EmailSenderConfiguration config) {
        this.config = config;
    }

    public void sendEmail(String toEmail, Map<String, String> userParameters) throws Exception {
        final String subject = this.getMessageTitle(userParameters);
        final String body = this.getMessageBody(userParameters);
        final String email = toEmail;
        new Thread(){

            public void run() {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("Subject", subject);
                OMElement payload = OMAbstractFactory.getOMFactory().createOMElement(BaseConstants.DEFAULT_TEXT_WRAPPER, null);
                payload.setText(body);
                try {
                    ConfigurationContext configContext = Util.getConfigurationContext();
                    ServiceClient serviceClient = configContext != null ? new ServiceClient(configContext, null) : new ServiceClient();
                    Options options = new Options();
                    options.setProperty("enableREST", (Object)"true");
                    options.setProperty("TRANSPORT_HEADERS", headerMap);
                    options.setProperty("transport.mail.Format", (Object)"Text");
                    options.setTo(new EndpointReference("mailto:" + email));
                    serviceClient.setOptions(options);
                    serviceClient.fireAndForget(payload);
                    log.debug((Object)("Sending confirmation mail to " + email));
                }
                catch (AxisFault e) {
                    String msg = "Error in delivering the message, subject: " + subject + ", to: " + email + ".";
                    log.error((Object)msg);
                }
            }
        }.start();
    }

    protected String getMessageTitle(Map<String, String> userParameters) {
        return Util.replacePlaceHolders(this.config.getSubject(), userParameters);
    }

    protected String getMessageBody(Map<String, String> userParameters) {
        return Util.replacePlaceHolders(this.config.getBody(), userParameters);
    }
}

