/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.sender.api;

import java.util.HashMap;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.sender.api.EmailDataHolder;
import org.wso2.carbon.email.sender.api.EmailSender;
import org.wso2.carbon.email.sender.api.EmailSenderConfiguration;
import org.wso2.carbon.email.sender.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkEmailSender
extends EmailSender {
    private static Log log = LogFactory.getLog(BulkEmailSender.class);

    public BulkEmailSender(EmailSenderConfiguration config) {
        super(config);
    }

    public void sendBulkEmails(List<EmailDataHolder> bulkEmailData) throws Exception {
        final List<EmailDataHolder> emailDataHolderList = bulkEmailData;
        ConfigurationContext configContext = Util.getConfigurationContext();
        final ServiceClient serviceClient = configContext != null ? new ServiceClient(configContext, null) : new ServiceClient();
        new Thread(){

            public void run() {
                for (EmailDataHolder dataHolder : emailDataHolderList) {
                    String subject = BulkEmailSender.this.getMessageTitle(dataHolder.getEmailParameters());
                    String body = BulkEmailSender.this.getMessageBody(dataHolder.getEmailParameters());
                    String email = dataHolder.getEmail();
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    headerMap.put("Subject", subject);
                    OMElement payload = OMAbstractFactory.getOMFactory().createOMElement(BaseConstants.DEFAULT_TEXT_WRAPPER, null);
                    payload.setText(body);
                    try {
                        Options options = new Options();
                        options.setProperty("enableREST", (Object)"true");
                        options.setProperty("TRANSPORT_HEADERS", headerMap);
                        options.setProperty("transport.mail.Format", (Object)"Text");
                        options.setTo(new EndpointReference("mailto:" + email));
                        serviceClient.setOptions(options);
                        serviceClient.fireAndForget(payload);
                        serviceClient.cleanup();
                    }
                    catch (AxisFault e) {
                        String msg = "Error in delivering the message, subject: " + subject + ", to: " + email + ".";
                        log.error((Object)msg);
                    }
                }
            }
        }.start();
    }
}

