/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.hostobjects.svnclient;

import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;

public class SVNClientHostObject
extends ScriptableObject {
    private static final String hostObjectName = "SVNClient";
    private SVNUrl svnUrl;
    private int logCount = 0;
    private int commitRange = 0;
    private String[] svnRepoInfo = new String[3];
    private ISVNClientAdapter svnClient;
    private static final Log log = LogFactory.getLog(SVNClientHostObject.class);

    private void initSVNClient(String userName, String password) throws ScriptException {
        try {
            SvnKitClientAdapterFactory.setup();
            log.debug((Object)"SVN Kit client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the SVN Kit client adapter - Required jars may be missing", t);
        }
        try {
            JhlClientAdapterFactory.setup();
            log.debug((Object)"Java HL client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the Java HL client adapter - Required jars  or the native libraries may be missing", t);
        }
        try {
            CmdLineClientAdapterFactory.setup();
            log.debug((Object)"Command line client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the command line client adapter - SVN command line tools may be missing", t);
        }
        try {
            String clientType = SVNClientAdapterFactory.getPreferredSVNClientType();
            this.svnClient = SVNClientAdapterFactory.createSVNClient((String)clientType);
            if (userName != null && password != null) {
                this.svnClient.setUsername(userName);
                this.svnClient.setPassword(password);
            }
        }
        catch (SVNClientException e) {
            throw new ScriptException("Client type can not be defined.");
        }
        if (this.svnClient == null) {
            throw new ScriptException("Failed to instantiate svn client.");
        }
    }

    public SVNClientHostObject(String userName, String password) throws ScriptException {
        try {
            this.initSVNClient(userName, password);
        }
        catch (ScriptException e) {
            String msg = "Failed to initiate svn client";
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)((Object)e));
        }
    }

    public SVNClientHostObject() throws ScriptException {
        try {
            this.initSVNClient(null, null);
        }
        catch (ScriptException e) {
            String msg = "Failed to initiate svn client";
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)((Object)e));
        }
    }

    public void jsSet_params(Object object) throws ScriptException {
        Object logCountObj;
        if (object instanceof NativeObject) {
            NativeObject nativeObject = (NativeObject)object;
            Object commitRangeObj = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"commitRange");
            logCountObj = ScriptableObject.getProperty((Scriptable)nativeObject, (String)"logCount");
            if (!(commitRangeObj instanceof Integer)) {
                throw new ScriptException("commitRange field needs to be an integer.");
            }
            this.commitRange = (Integer)commitRangeObj;
            if (!(logCountObj instanceof Integer)) {
                throw new ScriptException("logCount field needs to be an integer.");
            }
        } else {
            throw new ScriptException("Invalid parameter");
        }
        this.logCount = (Integer)logCountObj;
    }

    public Integer jsGet_params() throws ScriptException {
        return this.logCount;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException, MalformedURLException {
        SVNUrl url;
        String svnUrlL;
        String userNameL = null;
        String passwordL = null;
        int length = args.length;
        if (length == 1) {
            svnUrlL = (String)args[0];
        } else if (length == 3) {
            svnUrlL = (String)args[0];
            userNameL = (String)args[1];
            passwordL = (String)args[2];
        } else {
            throw new ScriptException("Incorrect number of arguments. Please specify repositoryUrl or repositoryUrl, username, password within the constructListor of SVNClient hostobject.");
        }
        if (svnUrlL == null) {
            throw new ScriptException("Invalid SVN Repository. Please recheck the given details of the repository.");
        }
        try {
            url = new SVNUrl(svnUrlL);
        }
        catch (MalformedURLException e) {
            log.error((Object)"SVN URL is malformed", (Throwable)e);
            throw e;
        }
        SVNClientHostObject svnClientHostObject = new SVNClientHostObject(userNameL, passwordL);
        svnClientHostObject.setSvnUrl(url);
        return svnClientHostObject;
    }

    public String[] jsFunction_getRepositoryInfo() throws MalformedURLException, ScriptException {
        this.getRepositoryInformation();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Last modified on: " + this.svnRepoInfo[0]));
            log.debug((Object)("Last committed author: " + this.svnRepoInfo[1]));
            log.debug((Object)("Last Changed Rev: " + this.svnRepoInfo[2]));
        }
        return this.svnRepoInfo;
    }

    private String[] getRepositoryInformation() throws MalformedURLException, ScriptException {
        String lastChangedAuthor;
        ISVNInfo svnInfo;
        try {
            svnInfo = this.svnClient.getInfo(this.svnUrl);
        }
        catch (SVNClientException e) {
            String msg = "Failed to get svn info from " + this.svnUrl;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)((Object)e));
        }
        Date lastChangedDate = svnInfo.getLastChangedDate();
        this.svnRepoInfo[0] = lastChangedDate.toString();
        this.svnRepoInfo[1] = lastChangedAuthor = svnInfo.getLastCommitAuthor();
        SVNRevision.Number lastChangedRev = svnInfo.getLastChangedRevision();
        this.svnRepoInfo[2] = String.valueOf(lastChangedRev);
        return this.svnRepoInfo;
    }

    private ISVNLogMessage[] getCommitMessages() throws MalformedURLException, ScriptException {
        ISVNLogMessage[] logMessages;
        SVNRevision endRevision;
        this.getRepositoryInformation();
        try {
            endRevision = SVNRevision.getRevision((String)this.svnRepoInfo[2]);
        }
        catch (ParseException e) {
            String msg = "Failed to get svn revision from " + this.svnUrl;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
        SVNRevision startRevision = null;
        if (this.commitRange < 1) {
            try {
                startRevision = SVNRevision.getRevision((String)"0");
            }
            catch (ParseException e) {
                String msg = "Failed to get svn revision from " + this.svnUrl;
                log.error((Object)msg, (Throwable)e);
                throw new ScriptException(msg, (Exception)e);
            }
        }
        try {
            System.out.println(startRevision);
            startRevision = SVNRevision.getRevision((String)Integer.toString(Integer.parseInt(this.svnRepoInfo[2]) - this.commitRange));
            System.out.println(startRevision);
        }
        catch (ParseException e) {
            String msg = "Failed to get svn revision from " + this.svnUrl;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
        try {
            logMessages = this.svnClient.getLogMessages(this.svnUrl, startRevision, endRevision);
        }
        catch (SVNClientException e) {
            String msg = "Failed to get svn log messages from " + this.svnUrl;
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)((Object)e));
        }
        return logMessages;
    }

    public String[] jsFunction_getCommitLogs() throws Exception {
        ArrayList<String> commitLogs = new ArrayList<String>();
        int count = 1;
        ISVNLogMessage[] logMessages = this.getCommitMessages();
        try {
            for (int i = logMessages.length - 1; i > 0; --i) {
                ISVNLogMessage logMessage = logMessages[i];
                StringBuilder commitLogBuf = new StringBuilder();
                commitLogBuf.append(logMessage.getRevision()).append(" | ").append(logMessage.getAuthor()).append(" | ").append(logMessage.getDate()).append("\n").append(" | ").append(logMessage.getMessage());
                String msg = commitLogBuf.toString() + "\n";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
                commitLogs.add(msg);
                if (++count <= this.logCount) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String msg = "Error in getting the commit logs";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
        return commitLogs.toArray(new String[commitLogs.size()]);
    }

    public String getClassName() {
        return hostObjectName;
    }

    public void setSvnUrl(SVNUrl svnUrl) {
        this.svnUrl = svnUrl;
    }

    public int getLogCount() {
        return this.logCount;
    }

    public void setLogCount(int logCount) {
        this.logCount = logCount;
    }

    public int getCommitRange() {
        return this.commitRange;
    }

    public void setCommitRange(int commitRange) {
        this.commitRange = commitRange;
    }
}

