/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.svn.repository.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.appfactory.common.AppFactoryConfiguration;
import org.wso2.carbon.appfactory.core.ArtifactStorage;
import org.wso2.carbon.appfactory.core.RevisionControlDriver;
import org.wso2.carbon.appfactory.svn.repository.mgt.RepositoryManager;
import org.wso2.carbon.appfactory.svn.repository.mgt.builder.RepositoryManagerHolder;
import org.wso2.carbon.appfactory.svn.repository.mgt.impl.FileArtifactStorage;
import org.wso2.carbon.appfactory.svn.repository.mgt.impl.SVNManager;
import org.wso2.carbon.appfactory.svn.repository.mgt.util.Util;
import org.wso2.carbon.user.core.service.RealmService;

public class SVNRepositoryMgtServiceComponent {
    Log log = LogFactory.getLog(SVNRepositoryMgtServiceComponent.class);

    protected void unsetAppFactoryConfiguration(AppFactoryConfiguration appFactoryConfiguration) {
        Util.setConfiguration(null);
    }

    protected void setAppFactoryConfiguration(AppFactoryConfiguration appFactoryConfiguration) {
        Util.setConfiguration(appFactoryConfiguration);
    }

    protected void setRealmService(RealmService realmService) {
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }

    protected void activate(ComponentContext context) {
        if (this.log.isDebugEnabled()) {
            this.log.info((Object)"**************SVN repository mgt bundle is activated*************");
        }
        try {
            BundleContext bundleContext = context.getBundleContext();
            SVNManager repositoryManager = new SVNManager();
            bundleContext.registerService(RevisionControlDriver.class.getName(), (Object)repositoryManager, null);
            FileArtifactStorage fileArtifactStorage = new FileArtifactStorage();
            bundleContext.registerService(ArtifactStorage.class.getName(), (Object)fileArtifactStorage, null);
            RepositoryManagerHolder holder = RepositoryManagerHolder.getInstance();
            RepositoryManager repositoryManagerOld = holder.getRepositoryManager();
            bundleContext.registerService(RepositoryManager.class.getName(), (Object)repositoryManagerOld, null);
        }
        catch (Throwable e) {
            this.log.error((Object)"Error in registering Repository Management Service  ", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (this.log.isDebugEnabled()) {
            this.log.info((Object)"*************SVN repository mgt bundle is deactivated*************");
        }
    }
}

