/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.svn.repository.mgt.impl;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.common.AppFactoryConfiguration;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.appfactory.core.RevisionControlDriver;
import org.wso2.carbon.appfactory.core.RevisionControlDriverListener;
import org.wso2.carbon.appfactory.svn.repository.mgt.impl.SCMManagerBasedRepositoryManager;
import org.wso2.carbon.appfactory.svn.repository.mgt.impl.SCMManagerExceptions;
import org.wso2.carbon.appfactory.svn.repository.mgt.util.Util;

public class SVNManager
implements RevisionControlDriver {
    private static final Log log = LogFactory.getLog(SCMManagerBasedRepositoryManager.class);
    private static AppFactoryConfiguration appFactoryConfiguration = Util.getConfiguration();

    public void getSource(String applicationId, String version, String revision, RevisionControlDriverListener listener) throws AppFactoryException {
        SCMManagerBasedRepositoryManager scm = new SCMManagerBasedRepositoryManager();
        try {
            String checkoutUrl = this.getApplicationUrl() + File.separator + "svn" + File.separator + applicationId;
            scm.checkoutApplication(checkoutUrl, applicationId, revision);
            listener.onGetSourceCompleted(applicationId, version, revision);
        }
        catch (SCMManagerExceptions scmManagerExceptions) {
            log.error((Object)("Error in checkout" + scmManagerExceptions));
        }
    }

    public String getApplicationUrl() {
        return appFactoryConfiguration.getFirstProperty("RepositoryMGTConfig.SCMServerURL");
    }
}

