/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.svn.repository.mgt.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutHandler;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;
import org.wso2.carbon.appfactory.common.AppFactoryConfiguration;
import org.wso2.carbon.appfactory.svn.repository.mgt.RepositoryMgtException;
import org.wso2.carbon.appfactory.svn.repository.mgt.beans.Permission;
import org.wso2.carbon.appfactory.svn.repository.mgt.beans.PermissionType;
import org.wso2.carbon.appfactory.svn.repository.mgt.beans.Repository;
import org.wso2.carbon.appfactory.svn.repository.mgt.impl.AbstractRepositoryManager;
import org.wso2.carbon.appfactory.svn.repository.mgt.impl.SCMManagerExceptions;
import org.wso2.carbon.appfactory.svn.repository.mgt.util.Util;
import org.wso2.carbon.utils.CarbonUtils;

public class SCMManagerBasedRepositoryManager
extends AbstractRepositoryManager {
    private static final Log log = LogFactory.getLog(SCMManagerBasedRepositoryManager.class);
    private static final String REST_BASE_URI = "/api/rest";
    private static final String REST_CREATE_REPOSITORY_URI = "/repositories";
    private static final String REST_GET_REPOSITORY_URI = "/repositories/svn/";
    private static final String REPOSITORY_XML_ROOT_ELEMENT = "repositories";
    private static final String REPOSITORY_NAME_ELEMENT = "name";
    private static final String REPOSITORY_TYPE_ELEMENT = "type";
    private static final String REPOSITORY_URL_ELEMENT = "url";
    private static final String PERMISSION_XML_ROOT_ELEMENT = "permissions";
    private static final String PERMISSION_TYPE_ELEMENT = "type";
    private static final String PERMISSION_NAME_ELEMENT = "name";
    private static final String PERMISSION_GROUP_PERMISSION_ELEMENT = "groupPermission";
    private AppFactoryConfiguration configuration;
    private ISVNClientAdapter svnClient;
    private String clientType;
    private static AppFactoryConfiguration appFactoryConfiguration = Util.getConfiguration();

    @Override
    public String createRepository(String applicationKey) throws RepositoryMgtException {
        HttpClient client = this.getClient(this.configuration);
        PostMethod post = new PostMethod(this.getServerURL(this.configuration) + REST_BASE_URI + REST_CREATE_REPOSITORY_URI);
        Repository repository = new Repository();
        repository.setName(applicationKey);
        repository.setType("svn");
        Permission permission = new Permission();
        permission.setGroupPermission(true);
        permission.setName(applicationKey);
        permission.setType(PermissionType.WRITE);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        permissions.add(permission);
        repository.setPermissions(permissions);
        post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.getRepositoryAsString(repository)));
        post.setDoAuthentication(true);
        post.addRequestHeader("Content-Type", "application/xml;charset=UTF-8");
        String url = null;
        try {
            client.executeMethod((HttpMethod)post);
        }
        catch (IOException e) {
            String msg = "Error while invoking the web service";
            log.error((Object)msg, (Throwable)e);
            throw new RepositoryMgtException(msg, e);
        }
        finally {
            HttpConnectionManager manager = client.getHttpConnectionManager();
            if (manager instanceof SimpleHttpConnectionManager) {
                ((SimpleHttpConnectionManager)manager).shutdown();
            }
        }
        if (post.getStatusCode() != 201) {
            String msg = "Repository creation is failed for " + applicationKey + " server returned status " + post.getStatusText();
            log.error((Object)msg);
            throw new RepositoryMgtException(msg);
        }
        url = this.getURL(applicationKey);
        return url;
    }

    private byte[] getRepositoryAsString(Repository repo) throws RepositoryMgtException {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement repository = factory.createOMElement(REPOSITORY_XML_ROOT_ELEMENT, null);
        OMElement name = factory.createOMElement("name", null);
        name.setText(repo.getName());
        repository.addChild((OMNode)name);
        OMElement type = factory.createOMElement("type", null);
        type.setText(repo.getType());
        repository.addChild((OMNode)type);
        for (Permission perm : repo.getPermissions()) {
            OMElement permission = factory.createOMElement(PERMISSION_XML_ROOT_ELEMENT, null);
            OMElement groupPermission = factory.createOMElement(PERMISSION_GROUP_PERMISSION_ELEMENT, null);
            groupPermission.setText(String.valueOf(perm.getGroupPermission()));
            permission.addChild((OMNode)groupPermission);
            OMElement permName = factory.createOMElement("name", null);
            permName.setText(perm.getName());
            OMElement permType = factory.createOMElement("type", null);
            permType.setText(perm.getType().toString());
            permission.addChild((OMNode)permName);
            permission.addChild((OMNode)permType);
            repository.addChild((OMNode)permission);
        }
        StringWriter writer = new StringWriter();
        try {
            repository.serialize((Writer)writer);
        }
        catch (XMLStreamException e) {
            String msg = "Error while serializing the payload";
            log.error((Object)msg, (Throwable)e);
            throw new RepositoryMgtException(msg, e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                String msg = "Error while closing the reader";
                log.error((Object)msg, (Throwable)e);
            }
        }
        return writer.toString().getBytes();
    }

    @Override
    public String getURL(String applicationKey) throws RepositoryMgtException {
        HttpClient client = this.getClient(this.configuration);
        GetMethod get = new GetMethod(this.getServerURL(this.configuration) + REST_BASE_URI + REST_GET_REPOSITORY_URI + applicationKey);
        get.setDoAuthentication(true);
        get.addRequestHeader("Content-Type", "application/xml;charset=UTF-8");
        String repository = null;
        try {
            client.executeMethod((HttpMethod)get);
            repository = this.getRepositoryFromStream(get.getResponseBodyAsStream()).getUrl();
        }
        catch (IOException e) {
            String msg = "Error while invoking the service";
            log.error((Object)msg, (Throwable)e);
            throw new RepositoryMgtException(msg, e);
        }
        finally {
            HttpConnectionManager manager = client.getHttpConnectionManager();
            if (manager instanceof SimpleHttpConnectionManager) {
                ((SimpleHttpConnectionManager)manager).shutdown();
            }
        }
        return repository;
    }

    @Override
    public void setConfig(AppFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public AppFactoryConfiguration getConfig() {
        return this.configuration;
    }

    private Repository getRepositoryFromStream(InputStream responseBodyAsStream) throws RepositoryMgtException {
        Repository repository;
        block12: {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            XMLStreamReader reader = null;
            repository = new Repository();
            try {
                reader = xif.createXMLStreamReader(responseBodyAsStream);
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                OMElement rootElement = builder.getDocumentElement();
                if (REPOSITORY_XML_ROOT_ELEMENT.equals(rootElement.getLocalName())) {
                    Iterator elements = rootElement.getChildElements();
                    while (elements.hasNext()) {
                        OMElement element;
                        Object object = elements.next();
                        if (!(object instanceof OMElement) || !REPOSITORY_URL_ELEMENT.equals((element = (OMElement)object).getLocalName())) continue;
                        repository.setUrl(element.getText());
                        break block12;
                    }
                    break block12;
                }
                String msg = "In the payload no repository information is found";
                log.error((Object)msg);
                throw new RepositoryMgtException(msg);
            }
            catch (XMLStreamException e) {
                String msg = "Error while reading the stream";
                log.error((Object)msg, (Throwable)e);
                throw new RepositoryMgtException(msg, e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (XMLStreamException e) {
                    String msg = "Error while serializing the payload";
                    log.error((Object)msg, (Throwable)e);
                }
            }
        }
        return repository;
    }

    @Override
    public void createDirectory(String url, String commitMessage) {
        try {
            this.initSVNClient();
            SVNUrl svnUrl = null;
            try {
                svnUrl = new SVNUrl(url);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Malformed url" + e));
            }
            this.svnClient.mkdir(svnUrl, commitMessage);
        }
        catch (SVNClientException e) {
            log.error((Object)e);
        }
        catch (SCMManagerExceptions scmManagerExceptions) {
            log.error((Object)("Error in svn client initialization" + scmManagerExceptions));
        }
    }

    @Override
    public void svnCopy(String sourceUrl, String destinationUrl, String commitMessage, SVNRevision rev) {
        rev = SVNRevision.HEAD;
        try {
            this.initSVNClient();
            SVNUrl svnUrl = null;
            SVNUrl copyURL = null;
            try {
                svnUrl = new SVNUrl(sourceUrl);
                copyURL = new SVNUrl(destinationUrl);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Malformed url" + e));
            }
            this.svnClient.copy(svnUrl, copyURL, commitMessage, rev);
        }
        catch (SVNClientException e) {
            log.error((Object)e);
        }
        catch (SCMManagerExceptions scmManagerExceptions) {
            log.error((Object)("Error in svn client initialization" + scmManagerExceptions));
        }
    }

    @Override
    public void svnMove(String sourceUrl, String destinationUrl, String commitMessage, SVNRevision rev) {
        rev = SVNRevision.HEAD;
        try {
            this.initSVNClient();
            SVNUrl svnUrl = null;
            SVNUrl copyURL = null;
            try {
                svnUrl = new SVNUrl(sourceUrl);
                copyURL = new SVNUrl(destinationUrl);
            }
            catch (MalformedURLException e) {
                log.error((Object)("Malformed url" + e));
            }
            this.svnClient.move(svnUrl, copyURL, commitMessage, rev);
        }
        catch (SVNClientException e) {
            log.error((Object)e);
        }
        catch (SCMManagerExceptions scmManagerExceptions) {
            log.error((Object)("Error in svn client initialization" + scmManagerExceptions));
        }
    }

    @Override
    public void initSVNClient() throws SCMManagerExceptions {
        try {
            SvnKitClientAdapterFactory.setup();
            log.debug((Object)"SVN Kit client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the SVN Kit client adapter - Required jars may be missing", t);
        }
        try {
            JhlClientAdapterFactory.setup();
            log.debug((Object)"Java HL client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the Java HL client adapter - Required jars  or the native libraries may be missing", t);
        }
        try {
            CmdLineClientAdapterFactory.setup();
            log.debug((Object)"Command line client adapter initialized");
        }
        catch (Throwable t) {
            log.debug((Object)"Unable to initialize the command line client adapter - SVN command line tools may be missing", t);
        }
        try {
            String clientType = SVNClientAdapterFactory.getPreferredSVNClientType();
            this.svnClient = SVNClientAdapterFactory.createSVNClient((String)clientType);
            this.svnClient.setUsername(appFactoryConfiguration.getFirstProperty("RepositoryMGTConfig.SCMServerAdminUserName"));
            this.svnClient.setPassword(appFactoryConfiguration.getFirstProperty("RepositoryMGTConfig.SCMServerAdminPassword"));
        }
        catch (SVNClientException e) {
            throw new SCMManagerExceptions("Client type can not be defined.");
        }
        if (this.svnClient == null) {
            throw new SCMManagerExceptions("Failed to instantiate svn client.");
        }
    }

    @Override
    public String checkoutApplication(String applicationSvnUrl, String applicationId, String svnRevision) throws SCMManagerExceptions {
        File checkoutDirectory;
        block7: {
            checkoutDirectory = this.createApplicationCheckoutDirectory(applicationId);
            this.initSVNClient();
            SVNUrl svnUrl = null;
            try {
                svnUrl = new SVNUrl(applicationSvnUrl);
            }
            catch (MalformedURLException e) {
                this.handleException("SVN URL of application is malformed.", e);
            }
            try {
                if (svnRevision != null && !"".equals(svnRevision)) {
                    SVNRevision revision = SVNRevision.HEAD;
                    if (this.svnClient instanceof CmdLineClientAdapter) {
                        this.svnClient.checkout(svnUrl, checkoutDirectory, revision, true);
                    } else {
                        this.svnClient.checkout(svnUrl, checkoutDirectory, revision, 3, true, true);
                    }
                    break block7;
                }
                throw new SCMManagerExceptions("SVN revision number is null or empty");
            }
            catch (SVNClientException e) {
                this.handleException("Failed to checkout code from SVN URL:" + svnUrl, (Exception)((Object)e));
            }
        }
        return checkoutDirectory.getAbsolutePath();
    }

    @Override
    public void buildApplication(String sourcePath) throws SCMManagerExceptions {
        String pomFilePath = sourcePath + File.separator + "pom.xml";
        File pomFile = new File(pomFilePath);
        if (!pomFile.exists()) {
            this.handleException("pom.xml file not found at " + pomFilePath);
        }
        this.executeMavenGoal(sourcePath);
        String targetDirPath = sourcePath + File.separator + "target";
        File targetDir = new File(targetDirPath);
        if (!targetDir.exists()) {
            this.handleException("Application build failure.");
        }
    }

    @Override
    public File createApplicationCheckoutDirectory(String applicationName) throws SCMManagerExceptions {
        boolean directoriesCreated;
        File tempDir = new File(CarbonUtils.getTmpDir() + File.separator + applicationName);
        if (!tempDir.exists() && !(directoriesCreated = tempDir.mkdirs())) {
            this.handleException("Failed to create directory path:" + tempDir.getAbsolutePath());
        }
        return tempDir;
    }

    private void handleException(String msg) throws SCMManagerExceptions {
        log.error((Object)msg);
        throw new SCMManagerExceptions(msg);
    }

    private void handleException(String msg, Exception e) throws SCMManagerExceptions {
        log.error((Object)msg, (Throwable)e);
        throw new SCMManagerExceptions(msg, e);
    }

    @Override
    public boolean executeMavenGoal(String applicationPath) throws SCMManagerExceptions {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setShowErrors(true);
        request.setPomFile(new File(applicationPath + File.separator + "pom.xml"));
        ArrayList<String> goals = new ArrayList<String>();
        goals.add("clean");
        goals.add("install");
        request.setGoals(goals);
        DefaultInvoker invoker = new DefaultInvoker();
        SystemOutHandler outputHandler = new SystemOutHandler();
        invoker.setErrorHandler((InvocationOutputHandler)outputHandler);
        try {
            InvocationResult result = invoker.execute((InvocationRequest)request);
            if (result.getExecutionException() == null) {
                if (result.getExitCode() != 0) {
                    request.setOffline(true);
                    result = invoker.execute((InvocationRequest)request);
                    if (result.getExitCode() == 0) {
                        return true;
                    }
                    String errorMessage = "No maven Application found at " + applicationPath;
                    this.handleException(errorMessage);
                }
                return true;
            }
        }
        catch (MavenInvocationException e) {
            this.handleException("Maven invocation failed with error:" + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        return false;
    }

    @Override
    public void cleanApplicationDir(String applicationPath) {
        File application = new File(applicationPath);
        try {
            FileUtils.deleteDirectory((File)application);
        }
        catch (IOException ignore) {
            log.warn((Object)("Failed to clean up application at path:" + applicationPath));
        }
    }

    @Override
    public String getAdminUsername(String applicationId) {
        return appFactoryConfiguration.getFirstProperty("AdminUserName") + "@" + applicationId;
    }
}

