/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.svn.repository.mgt.impl;

import java.util.Arrays;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.common.AppFactoryConfiguration;
import org.wso2.carbon.appfactory.svn.repository.mgt.RepositoryManager;
import org.wso2.carbon.appfactory.svn.repository.mgt.util.Util;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;

public abstract class AbstractRepositoryManager
implements RepositoryManager {
    private static final Log log = LogFactory.getLog(AbstractRepositoryManager.class);

    protected HttpClient getClient(AppFactoryConfiguration config) {
        HttpClient client = new HttpClient();
        String userName = config.getFirstProperty("RepositoryMGTConfig.SCMServerAdminUserName");
        String password = config.getFirstProperty("RepositoryMGTConfig.SCMServerAdminPassword");
        AuthScope authScope = AuthScope.ANY;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
        client.getState().setCredentials(authScope, (Credentials)credentials);
        return client;
    }

    protected String getServerURL(AppFactoryConfiguration config) {
        return config.getFirstProperty("RepositoryMGTConfig.SCMServerURL");
    }

    @Override
    public boolean hasAccess(String username, String password, String applicationId) {
        Integer tID = null;
        try {
            tID = Util.getRealmService().getTenantManager().getTenantId(applicationId);
            UserStoreManager userStoreManager = Util.getRealmService().getTenantUserRealm(tID.intValue()).getUserStoreManager();
            if (userStoreManager.authenticate(username, (Object)password) && Arrays.asList(userStoreManager.getRoleListOfUser(username)).contains(Util.getConfiguration().getFirstProperty("RepositoryMGTConfig.ReadWriteRole"))) {
                return true;
            }
        }
        catch (UserStoreException e) {
            String msg = "Error while checking permission for accessing svn repository of " + applicationId + " by " + username;
            log.error((Object)msg, (Throwable)e);
        }
        return false;
    }
}

