/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.svn.repository.mgt.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.common.AppFactoryConfiguration;
import org.wso2.carbon.appfactory.svn.repository.mgt.RepositoryManager;
import org.wso2.carbon.appfactory.svn.repository.mgt.builder.RepositoryManagerBuilder;
import org.wso2.carbon.appfactory.svn.repository.mgt.util.Util;

public class RepositoryManagerHolder {
    private static final Log log = LogFactory.getLog(RepositoryManagerHolder.class);
    private static RepositoryManagerHolder holder;
    private static RepositoryManager manger;

    private RepositoryManagerHolder() {
    }

    public static RepositoryManagerHolder getInstance() {
        if (holder == null) {
            holder = new RepositoryManagerHolder();
        }
        if (holder.getRepositoryManager() == null) {
            RepositoryManagerHolder.buildRepositoryManager();
        }
        return holder;
    }

    private static void buildRepositoryManager() {
        AppFactoryConfiguration configuration = Util.getConfiguration();
        if (configuration != null) {
            RepositoryManagerBuilder builder = new RepositoryManagerBuilder(configuration);
            RepositoryManager repositoryManager = builder.buildRepositoryManager();
            if (repositoryManager == null) {
                String msg = "Could not get any repository manager";
                log.error((Object)msg);
            } else {
                manger = repositoryManager;
            }
        } else {
            String msg = "Could not get AppFactory configuration to build a repository manager";
            log.error((Object)msg);
        }
    }

    public RepositoryManager getRepositoryManager() {
        return manger;
    }
}

