/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.Helper;

class CmdLineInfoPart
implements ISVNInfo {
    private static final String KEY_PATH = "Path";
    private static final String KEY_URL = "URL";
    private static final String KEY_REVISION = "Revision";
    private static final String KEY_REPOSITORY = "Repository Root";
    private static final String KEY_NODEKIND = "Node Kind";
    private static final String KEY_LASTCHANGEDAUTHOR = "Last Changed Author";
    private static final String KEY_LASTCHANGEDREV = "Last Changed Rev";
    private static final String KEY_LASTCHANGEDDATE = "Last Changed Date";
    private static final String KEY_TEXTLASTUPDATED = "Text Last Updated";
    private static final String KEY_SCHEDULE = "Schedule";
    private static final String KEY_COPIEDFROMURL = "Copied From URL";
    private static final String KEY_COPIEDFROMREV = "Copied From Rev";
    private static final String KEY_PROPSLASTUPDATED = "Properties Last Updated";
    private static final String KEY_REPOSITORYUUID = "Repository UUID";
    private static final String KEY_LOCKOWNER = "Lock Owner";
    private static final String KEY_LOCKCREATIONDATE = "Lock Created";
    private static final String KEY_LOCKCOMMENT = "Lock Comment";
    private static final String KEY_CONFLICTING_PREV_BASE = "Conflict Previous Base File";
    private static final String KEY_CONFLICTING_PREV_WORKING = "Conflict Previous Working File";
    private static final String KEY_CONFLICTING_CURRENT_BASE = "Conflict Current Base File";
    private Map infoMap = new HashMap();
    protected boolean unversioned = false;

    CmdLineInfoPart(String infoString) {
        this();
        this.load(infoString);
    }

    protected CmdLineInfoPart() {
    }

    public Date getLastChangedDate() {
        return this.unversioned ? null : Helper.toDate(this.get(KEY_LASTCHANGEDDATE));
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.unversioned ? null : Helper.toRevNum(this.get(KEY_LASTCHANGEDREV));
    }

    public String getLastCommitAuthor() {
        return this.unversioned ? null : this.get(KEY_LASTCHANGEDAUTHOR);
    }

    public SVNNodeKind getNodeKind() {
        return this.unversioned ? null : SVNNodeKind.fromString(this.get(KEY_NODEKIND));
    }

    public String getPath() {
        return this.get(KEY_PATH);
    }

    public File getFile() {
        return new File(this.getPath()).getAbsoluteFile();
    }

    public SVNRevision.Number getRevision() {
        return this.unversioned ? SVNRevision.INVALID_REVISION : Helper.toRevNum(this.get(KEY_REVISION));
    }

    public SVNUrl getUrl() {
        return this.unversioned ? null : Helper.toSVNUrl(this.get(KEY_URL));
    }

    public String getUrlString() {
        return this.unversioned ? null : this.get(KEY_URL);
    }

    private String get(String key) {
        Object value = this.infoMap.get(key);
        return value == null ? null : value.toString();
    }

    private void load(String infoString) {
        StringTokenizer st = new StringTokenizer(infoString, Helper.NEWLINE);
        if (st.countTokens() == 1) {
            this.unversioned = true;
            String line = st.nextToken();
            this.infoMap.put(KEY_PATH, line.substring(0, line.indexOf(":  (Not a versioned resource)")));
        } else {
            StringBuffer lockComment = new StringBuffer();
            boolean inComment = false;
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (inComment) {
                    lockComment.append(line).append("\n");
                    continue;
                }
                int middle = line.indexOf(58);
                String key = line.substring(0, middle);
                if (key.startsWith(KEY_LOCKCOMMENT)) {
                    inComment = true;
                    continue;
                }
                String value = line.substring(middle + 2);
                this.infoMap.put(key, value);
            }
            if (inComment) {
                this.infoMap.put(KEY_LOCKCOMMENT, lockComment.toString());
            }
        }
    }

    public boolean isVersioned() {
        return !this.unversioned;
    }

    public Date getLastDateTextUpdate() {
        return this.unversioned ? null : Helper.toDate(this.get(KEY_TEXTLASTUPDATED));
    }

    public String getUuid() {
        return this.unversioned ? null : this.get(KEY_REPOSITORYUUID);
    }

    public SVNUrl getRepository() {
        return this.unversioned ? null : Helper.toSVNUrl(this.get(KEY_REPOSITORY));
    }

    public SVNScheduleKind getSchedule() {
        return SVNScheduleKind.fromString(this.get(KEY_SCHEDULE));
    }

    public Date getLastDatePropsUpdate() {
        return this.unversioned ? null : Helper.toDate(this.get(KEY_PROPSLASTUPDATED));
    }

    public boolean isCopied() {
        return this.getCopyRev() != null || this.getCopyUrl() != null;
    }

    public SVNRevision.Number getCopyRev() {
        return this.unversioned ? null : Helper.toRevNum(this.get(KEY_COPIEDFROMREV));
    }

    public SVNUrl getCopyUrl() {
        return this.unversioned ? null : Helper.toSVNUrl(this.get(KEY_COPIEDFROMURL));
    }

    public Date getLockCreationDate() {
        return this.unversioned ? null : Helper.toDate(this.get(KEY_LOCKCREATIONDATE));
    }

    public String getLockOwner() {
        return this.unversioned ? null : this.get(KEY_LOCKOWNER);
    }

    public String getLockComment() {
        return this.unversioned ? null : this.get(KEY_LOCKCOMMENT);
    }

    public File getConflictNew() {
        if (this.unversioned) {
            return null;
        }
        String path = this.get(KEY_CONFLICTING_CURRENT_BASE);
        return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
    }

    public File getConflictOld() {
        if (this.unversioned) {
            return null;
        }
        String path = this.get(KEY_CONFLICTING_PREV_BASE);
        return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
    }

    public File getConflictWorking() {
        if (this.unversioned) {
            return null;
        }
        String path = this.get(KEY_CONFLICTING_PREV_WORKING);
        return path != null ? new File(this.getFile().getParent(), path).getAbsoluteFile() : null;
    }

    public static String[] parseInfoParts(String infoLines) {
        StringTokenizer st = new StringTokenizer(infoLines, Helper.NEWLINE);
        String current = null;
        ArrayList<String> infoParts = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (temp.startsWith("Path:") || temp.endsWith(":  (Not a versioned resource)")) {
                if (current != null) {
                    infoParts.add(current);
                }
                current = temp;
                continue;
            }
            if (current == null) {
                current = temp;
                continue;
            }
            current = current + "\n" + temp;
        }
        if (current != null) {
            infoParts.add(current);
        }
        String[] infoArray = new String[infoParts.size()];
        infoParts.toArray(infoArray);
        return infoArray;
    }

    public static CmdLineInfoPart createUnversioned(String path) {
        return new CmdLineInfoPartUnversioned(path);
    }

    public int getDepth() {
        return 0;
    }

    protected static class CmdLineInfoPartUnversioned
    extends CmdLineInfoPart {
        private String path;

        protected CmdLineInfoPartUnversioned(String path) {
            this.path = path;
            this.unversioned = true;
        }

        public String getPath() {
            return this.path;
        }
    }
}

