/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.appfactory.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.appfactory.common.AppFactoryConfiguration;
import org.wso2.carbon.appfactory.common.AppFactoryException;
import org.wso2.carbon.securevault.SecretManagerInitializer;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class AppFactoryUtil {
    private static final Log log = LogFactory.getLog(AppFactoryUtil.class);
    private static SecretResolver secretResolver;
    private static Map<String, List<String>> configuration;

    public static File getApplicationWorkDirectory(String applicationId, String version, String revision) throws AppFactoryException {
        File tempDir = new File(CarbonUtils.getTmpDir() + File.separator + applicationId);
        return tempDir;
    }

    public static AppFactoryConfiguration loadAppFactoryConfiguration() throws AppFactoryException {
        OMElement appFactoryElement = AppFactoryUtil.loadAppFactoryXML();
        SecretManagerInitializer secretManagerInitializer = new SecretManagerInitializer();
        secretManagerInitializer.init();
        secretResolver = SecretResolverFactory.create((OMElement)appFactoryElement, (boolean)true);
        if (!"http://www.wso2.org/appfactory/".equals(appFactoryElement.getNamespace().getNamespaceURI())) {
            String message = "AppFactory namespace is invalid. Expected [http://www.wso2.org/appfactory/], received [" + appFactoryElement.getNamespace() + "]";
            log.error((Object)message);
            throw new AppFactoryException(message);
        }
        Stack<String> nameStack = new Stack<String>();
        AppFactoryUtil.readChildElements(appFactoryElement, nameStack);
        AppFactoryConfiguration appFactoryConfig = new AppFactoryConfiguration(configuration);
        return appFactoryConfig;
    }

    private static OMElement loadAppFactoryXML() throws AppFactoryException {
        String fileLocation = CarbonUtils.getCarbonConfigDirPath() + File.separator + "appfactory" + File.separator + "appfactory.xml";
        File configFile = new File(fileLocation);
        FileInputStream inputStream = null;
        OMElement configXMLFile = null;
        try {
            inputStream = new FileInputStream(configFile);
            String xmlContent = IOUtils.toString((InputStream)inputStream);
            configXMLFile = AXIOMUtil.stringToOM((String)xmlContent);
        }
        catch (IOException e) {
            String msg = "Unable to read the file appfactory.xml at " + fileLocation;
            log.error((Object)msg, (Throwable)e);
            throw new AppFactoryException(msg, e);
        }
        catch (XMLStreamException e) {
            String msg = "Error in parsing appfactory.xml";
            log.error((Object)msg, (Throwable)e);
            throw new AppFactoryException(msg, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                String msg = "Error in closing stream ";
                log.error((Object)msg, (Throwable)e);
            }
        }
        return configXMLFile;
    }

    private static void readChildElements(OMElement serverConfig, Stack<String> nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            String text;
            OMElement element = (OMElement)childElements.next();
            nameStack.push(element.getLocalName());
            String nameAttribute = element.getAttributeValue(new QName("name"));
            if (nameAttribute != null && nameAttribute.trim().length() != 0) {
                String key = AppFactoryUtil.getKey(nameStack);
                AppFactoryUtil.addToConfiguration(key, nameAttribute.trim());
                nameStack.push(nameAttribute.trim());
            }
            if ((text = element.getText()) != null && text.trim().length() != 0) {
                String key = AppFactoryUtil.getKey(nameStack);
                String value = AppFactoryUtil.replaceSystemProperty(text.trim());
                if (AppFactoryUtil.isProtectedToken(key)) {
                    value = AppFactoryUtil.getProtectedValue(key);
                }
                AppFactoryUtil.addToConfiguration(key, value);
            }
            AppFactoryUtil.readChildElements(element, nameStack);
            if (nameAttribute != null && nameAttribute.trim().length() != 0) {
                nameStack.pop();
            }
            nameStack.pop();
        }
    }

    private static String getKey(Stack<String> nameStack) {
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private static String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf(125)) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (sysProp.equals("carbon.home") && propValue != null && propValue.equals(".")) {
                propValue = new File(".").getAbsolutePath() + File.separator;
            }
            if (propValue == null) continue;
            text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
        }
        return text;
    }

    private static boolean isProtectedToken(String key) {
        return secretResolver != null && secretResolver.isInitialized() && secretResolver.isTokenProtected("Carbon." + key);
    }

    private static String getProtectedValue(String key) {
        return secretResolver.resolve("Carbon." + key);
    }

    private static void addToConfiguration(String key, String value) {
        List<String> list = configuration.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            list.add(value);
            configuration.put(key, list);
        } else if (!list.contains(value)) {
            list.add(value);
        }
    }

    static {
        configuration = new HashMap<String, List<String>>();
    }
}

