/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.keymgt.client;

import java.net.URL;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.dto.xsd.APIInfoDTO;
import org.wso2.carbon.apimgt.keymgt.stub.subscriber.APIKeyMgtSubscriberServiceStub;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;

public class SubscriberKeyMgtClient {
    private static Log log = LogFactory.getLog(SubscriberKeyMgtClient.class);
    private APIKeyMgtSubscriberServiceStub subscriberServiceStub;

    public SubscriberKeyMgtClient(String backendServerURL, String username, String password) throws Exception {
        try {
            AuthenticationAdminStub authenticationAdminStub = new AuthenticationAdminStub(null, backendServerURL + "AuthenticationAdmin");
            ServiceClient authAdminServiceClient = authenticationAdminStub._getServiceClient();
            authAdminServiceClient.getOptions().setManageSession(true);
            authenticationAdminStub.login(username, password, new URL(backendServerURL).getHost());
            ServiceContext serviceContext = authenticationAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            String authenticatedCookie = (String)serviceContext.getProperty("Cookie");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication Successful with AuthenticationAdmin. Authenticated Cookie ID : " + authenticatedCookie));
            }
            this.subscriberServiceStub = new APIKeyMgtSubscriberServiceStub(null, backendServerURL + "APIKeyMgtSubscriberService");
            ServiceClient client = this.subscriberServiceStub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)authenticatedCookie);
        }
        catch (Exception e) {
            String errorMsg = "Error when instantiating SubscriberKeyMgtClient.";
            log.error((Object)errorMsg, (Throwable)e);
            throw e;
        }
    }

    public String getAccessKey(String userId, APIInfoDTO apiInfoDTO, String applicationName, String keyType) throws Exception {
        return this.subscriberServiceStub.getAccessToken(userId, apiInfoDTO, applicationName, keyType);
    }

    public String getApplicationAccessKey(String userId, String applicationName, String keyType) throws Exception {
        return this.subscriberServiceStub.getApplicationAccessToken(userId, applicationName, keyType);
    }
}

