/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.hostobjects;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.hostobjects.Services;
import org.wso2.carbon.apimgt.hostobjects.purchasedServices;

class SampleData {
    private static final Log log = LogFactory.getLog(SampleData.class);
    static String[] providers = new String[]{"Madhuka", "Lalaji", "Chanaka", "Sumedha"};
    static String[] application = new String[]{"News Application", "Location Applicatioin", "Stock Application", "WSO2 Application"};
    static purchasedServices p1 = new purchasedServices("/branches/production/services/net/webservicex/www/6.0.0/BarCode", "false", "Barcode generator", "http://wso2.org/forum/990", "6.0.0", "WSO2", "3.0", "http://www.webservicex.net/", "BarCode", "true", "https://lh3.ggpht.com/1Z3IovVFnCBWTRCB_0AGALYKho_ipprAYV-XwJhhFEKx6U-FEVAIJI0QXZ8MDfiUeywa=w78");
    static purchasedServices p2 = new purchasedServices("/branches/production/services/net/webservicex/www/6.0.0/BizService", "false", "BizService generator", "http://wso2.org/forum/990", "5.0.0", "WSO2", "3.0", "http://www.webservicex.net/", "BizService", "true", "https://lh3.ggpht.com/1Z3IovVFnCBWTRCB_0AGALYKho_ipprAYV-XwJhhFEKx6U-FEVAIJI0QXZ8MDfiUeywa=w78");
    static purchasedServices[] purchasedServiceList = new purchasedServices[]{p1, p2};
    static Services s1 = new Services("Biz Service", 3, "Nuwan");
    static Services s2 = new Services("News Service", 5, "Sumedha");
    static Services s3 = new Services("Stocks", 4, "Madhuka");
    static Services[] listSerives = new Services[]{s1, s2, s3};
    APIIdentifier apiI1 = new APIIdentifier("Madhuka", "RadioServices", "4.0.1");
    APIIdentifier apiI2 = new APIIdentifier("Sumedha", "ProjectServices", "1.2.0");
    APIIdentifier apiI3 = new APIIdentifier("Lalji", "BizServices", "2.0.2");
    APIIdentifier apiI4 = new APIIdentifier("Chanaka", "GraphicServices", "3.0.1");
    APIIdentifier apiI5 = new APIIdentifier("Lalaji", "TestServices", "4.0.1");
    APIIdentifier apiI6 = new APIIdentifier("Madhuka", "HelloServices", "5.0.1");
    APIIdentifier apiI7 = new APIIdentifier("Sumedha", "Test1Services", "6.0.1");
    APIIdentifier apiI8 = new APIIdentifier("Chanaka", "Test2Services", "1.1.6");
    API api1 = new API(this.apiI1);
    API api2 = new API(this.apiI2);
    API api3 = new API(this.apiI3);
    API api4 = new API(this.apiI4);
    API api5 = new API(this.apiI5);
    API api6 = new API(this.apiI6);
    API api7 = new API(this.apiI7);
    API api8 = new API(this.apiI8);
    Subscriber sub1 = new Subscriber("lalaji@wso2.com");
    Subscriber sub2 = new Subscriber("madhuka@wso2.com");
    Subscriber sub3 = new Subscriber("lalaji@wso2.com");

    SampleData() {
    }

    public Set<Subscriber> getUsers() {
        HashSet<Subscriber> users = new HashSet<Subscriber>();
        this.sub1.setDescription("Testing1");
        this.sub1.setName("Lalaji");
        this.sub2.setName("Maduka");
        this.sub2.setDescription("Testing2");
        this.sub3.setDescription("Testing3");
        this.sub3.setName("Lalaji");
        users.add(this.sub1);
        users.add(this.sub2);
        users.add(this.sub3);
        return users;
    }

    public void addAPI(String name, String version, String description, String endpoint, String wsdl, Set<String> tag, String tier) {
        HashSet<Tier> availableTier = new HashSet<Tier>();
        availableTier.add(new Tier(tier));
        APIIdentifier aid = new APIIdentifier(name, version, "public");
        API api = new API(aid);
        api.setDescription(description);
        api.setUrl(endpoint);
        api.addTags(tag);
        api.addAvailableTiers(availableTier);
        log.info((Object)"Successfully added the API");
    }

    public APIIdentifier[] giveAPIIdentifiers() {
        APIIdentifier[] arrayAPIIdentifiers = new APIIdentifier[]{this.apiI1, this.apiI2, this.apiI3, this.apiI4};
        return arrayAPIIdentifiers;
    }

    public API getAPI() {
        HashSet<Tier> availableTier = new HashSet<Tier>();
        availableTier.add(new Tier("gold"));
        availableTier.add(new Tier("silver"));
        this.api1.setDescription("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce suscipit porta leo vitae pellentesque. In volutpat viverra tortor id iaculis. Cras eleifend, risus ut eleifend porttitor, risus dolor tincidunt magna, u elementum sapien dui eget elit. Nullam et nisl ac velit molestie pulvinar sed quis elit. Vestibulum nonmalesuada sem. Praesent rutrum sagittis iaculis. Quisque blandit, lacus ut tincidunt egestas, purus elitrhoncus nunc, vel venenatis purus nisl at magna. Phasellus vitae sem diam. Donec imperdiet, velit sodales rutrum malesuada, nibh lacus vehicula lorem, id sagittis enim turpis et enim. Duis pharetra laoreet lorem  sit amet euismod.");
        this.api1.setLastUpdated(new Date(0L));
        this.api1.setLatest(true);
        this.api1.setStatus(APIStatus.DEPRECATED);
        this.api1.setUrl("http://appserver/services/hello");
        this.api1.addAvailableTiers(availableTier);
        return this.api1;
    }

    public Set<API> getAllPublishedAPIs() {
        HashSet<API> apis = new HashSet<API>();
        apis.add(this.api1);
        apis.add(this.api2);
        apis.add(this.api3);
        apis.add(this.api4);
        apis.add(this.api5);
        apis.add(this.api6);
        apis.add(this.api7);
        apis.add(this.api8);
        HashSet<Tier> availableTier = new HashSet<Tier>();
        availableTier.add(new Tier("gold"));
        availableTier.add(new Tier("silver"));
        for (Object e : apis) {
            API api = (API)e;
            api.setDescription("Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce suscipit porta leo vitae pellentesque. Involutpat viverra tortor id iaculis. Cras eleifend, risus ut eleifend porttitor, risus dolor tincidunt magna,eu elementum sapien dui eget elit. Nullam et nisl ac velit molestie pulvinar sed quis elit. Vestibulum nonmalesuada sem. Praesent rutrum sagittis iaculis. Quisque blandit, lacus ut tincidunt egestas, purus elitrhoncus nunc, vel venenatis purus nisl at magna. Phasellus vitae sem diam. Donec imperdiet, velit sodalesrutrum malesuada, nibh lacus vehicula lorem, id sagittis enim turpis et enim. Duis pharetra laoreet loremsit amet euismod.");
            api.setLastUpdated(new Date(0L));
            api.setLatest(true);
            api.setStatus(APIStatus.DEPRECATED);
            api.setUrl("http://appserver/services/echo");
            api.addAvailableTiers(availableTier);
        }
        return apis;
    }

    public void addDataForAPIs() {
        API[] apiArray = new API[]{this.api1, this.api2, this.api3, this.api4};
        for (int x = 1; x < apiArray.length; ++x) {
            apiArray[x].setRating((float)((int)Math.random() * 5));
            apiArray[x].setUrl("http://myapi.com");
        }
    }
}

