/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.hostobjects;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.apimgt.api.APIConsumer;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIKey;
import org.wso2.carbon.apimgt.api.model.APIRating;
import org.wso2.carbon.apimgt.api.model.Application;
import org.wso2.carbon.apimgt.api.model.Comment;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationType;
import org.wso2.carbon.apimgt.api.model.SubscribedAPI;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tag;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.hostobjects.SampleData;
import org.wso2.carbon.apimgt.hostobjects.Services;
import org.wso2.carbon.apimgt.hostobjects.internal.HostObjectComponent;
import org.wso2.carbon.apimgt.hostobjects.purchasedServices;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.impl.UserAwareAPIConsumer;
import org.wso2.carbon.apimgt.impl.dto.xsd.APIInfoDTO;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.keymgt.client.SubscriberKeyMgtClient;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.user.mgt.stub.AddUserUserAdminExceptionException;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.utils.CarbonUtils;

public class APIStoreHostObject
extends ScriptableObject {
    private static final long serialVersionUID = -3169012616750937045L;
    private static final Log log = LogFactory.getLog(APIStoreHostObject.class);
    private static final String hostObjectName = "APIStore";
    private static final String httpPort = "mgt.transport.http.port";
    private static final String httpsPort = "mgt.transport.https.port";
    private static final String hostName = "carbon.local.ip";
    private APIConsumer apiConsumer;
    private String username;
    static SampleData sampleData = new SampleData();

    public String getUsername() {
        return this.username;
    }

    public String getClassName() {
        return hostObjectName;
    }

    public APIStoreHostObject() throws APIManagementException {
        this.apiConsumer = APIManagerFactory.getInstance().getAPIConsumer();
    }

    public APIStoreHostObject(String loggedUser) throws APIManagementException {
        this.username = loggedUser;
        this.apiConsumer = APIManagerFactory.getInstance().getAPIConsumer(this.username);
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function Obj, boolean inNewExpr) throws ScriptException, APIManagementException {
        int length = args.length;
        if (length == 1) {
            String username = (String)args[0];
            return new APIStoreHostObject(username);
        }
        return new APIStoreHostObject();
    }

    private static String getUsernameFromObject(Scriptable obj) {
        return ((APIStoreHostObject)obj).getUsername();
    }

    public APIConsumer getApiConsumer() {
        return this.apiConsumer;
    }

    private static APIConsumer getAPIConsumer(Scriptable thisObj) {
        return ((APIStoreHostObject)thisObj).getApiConsumer();
    }

    private static SubscriberKeyMgtClient getKeyManagementClient() throws APIManagementException {
        APIManagerConfiguration config = HostObjectComponent.getAPIManagerConfiguration();
        String url = config.getFirstProperty("APIKeyManager.ServerURL");
        if (url == null) {
            throw new APIManagementException("API key manager URL unspecified");
        }
        String username = config.getFirstProperty("APIKeyManager.Username");
        String password = config.getFirstProperty("APIKeyManager.Password");
        if (username == null || password == null) {
            throw new APIManagementException("Authentication credentials for API key manager unspecified");
        }
        try {
            return new SubscriberKeyMgtClient(url, username, password);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new APIManagementException((Throwable)e);
        }
    }

    public static String jsFunction_getAuthServerURL(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        APIManagerConfiguration config = HostObjectComponent.getAPIManagerConfiguration();
        String url = config.getFirstProperty("AuthManager.ServerURL");
        if (url == null) {
            throw new APIManagementException("API key manager URL unspecified");
        }
        return url;
    }

    public static String jsFunction_getHTTPsURL(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        return "https://" + System.getProperty(hostName) + ":" + System.getProperty(httpsPort);
    }

    public static String jsFunction_getHTTPURL(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        return "http://" + System.getProperty(hostName) + ":" + System.getProperty(httpPort);
    }

    public static String jsFunction_getKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        int argsCount = args.length;
        String methodName = "getKey";
        if (argsCount != 7) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)methodName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        if (!(args[2] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"3", (String)"string", (Object)args[2], (boolean)false);
        }
        if (!(args[3] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"4", (String)"string", (Object)args[3], (boolean)false);
        }
        if (!(args[4] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"5", (String)"string", (Object)args[4], (boolean)false);
        }
        if (!(args[5] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"6", (String)"string", (Object)args[5], (boolean)false);
        }
        if (!(args[5] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"7", (String)"string", (Object)args[6], (boolean)false);
        }
        APIInfoDTO apiInfo = new APIInfoDTO();
        apiInfo.setProviderId((String)args[0]);
        apiInfo.setApiName((String)args[1]);
        apiInfo.setVersion((String)args[2]);
        apiInfo.setContext((String)args[3]);
        try {
            SubscriberKeyMgtClient keyMgtClient = APIStoreHostObject.getKeyManagementClient();
            return keyMgtClient.getAccessKey((String)args[5], apiInfo, (String)args[4], (String)args[6]);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException(e);
        }
    }

    public static String jsFunction_getApplicationKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        int argsCount = args.length;
        String methodName = "getApplicationKey";
        if (argsCount != 3) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)methodName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        if (!(args[2] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"3", (String)"string", (Object)args[2], (boolean)false);
        }
        try {
            SubscriberKeyMgtClient keyMgtClient = APIStoreHostObject.getKeyManagementClient();
            return keyMgtClient.getApplicationAccessKey((String)args[0], (String)args[1], (String)args[2]);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException(e);
        }
    }

    public static NativeObject jsFunction_login(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        if (args.length != 2) {
            throw new ScriptException("Invalid input parameters to the login method");
        }
        String username = (String)args[0];
        String password = (String)args[1];
        APIManagerConfiguration config = HostObjectComponent.getAPIManagerConfiguration();
        String url = config.getFirstProperty("AuthManager.ServerURL");
        if (url == null) {
            throw new APIManagementException("API key manager URL unspecified");
        }
        NativeObject row = new NativeObject();
        try {
            AuthenticationAdminStub authAdminStub = new AuthenticationAdminStub(null, url + "AuthenticationAdmin");
            ServiceClient client = authAdminStub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            String host = new URL(url).getHost();
            if (!authAdminStub.login(username, password, host)) {
                throw new APIManagementException("Authentication failed. Invalid username or password.");
            }
            ServiceContext serviceContext = authAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            String sessionCookie = (String)serviceContext.getProperty("Cookie");
            boolean authorized = APIUtil.checkPermissionQuietly((String)username, (String)"/permission/admin/manage/api/subscribe");
            if (!authorized) {
                throw new APIManagementException("Insufficient privileges");
            }
            row.put("user", (Scriptable)row, (Object)username);
            row.put("sessionId", (Scriptable)row, (Object)sessionCookie);
            row.put("error", (Scriptable)row, (Object)false);
        }
        catch (Exception e) {
            row.put("error", (Scriptable)row, (Object)true);
            row.put("detail", (Scriptable)row, (Object)e.getMessage());
        }
        return row;
    }

    public static NativeArray jsFunction_getTopRatedAPIs1(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        NativeArray myn = new NativeArray(0L);
        int limit = 0;
        APIIdentifier[] serviceList = sampleData.giveAPIIdentifiers();
        if (APIStoreHostObject.isStringArray(args)) {
            String limitArg = args[0].toString();
            limit = Integer.parseInt(limitArg);
        }
        for (int i = 0; i < limit; ++i) {
            NativeObject row = new NativeObject();
            row.put("name", (Scriptable)row, (Object)serviceList[i].getApiName());
            row.put("provider", (Scriptable)row, (Object)serviceList[i].getProviderName());
            row.put("version", (Scriptable)row, (Object)serviceList[i].getVersion());
            myn.put(i, (Scriptable)myn, (Object)row);
        }
        return myn;
    }

    public static NativeArray jsFunction_getTopRatedAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            Set apiSet;
            String limitArg = args[0].toString();
            int limit = Integer.parseInt(limitArg);
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                apiSet = apiConsumer.getTopRatedAPIs(limit);
            }
            catch (APIManagementException e) {
                log.error((Object)("Error from Registry API while getting Top Rated APIs Information " + (Object)((Object)e)));
                return myn;
            }
            catch (NullPointerException e) {
                log.error((Object)("Error from Registry API while getting Top Rated APIs Information, No APIs in Registry " + e));
                return myn;
            }
            catch (Exception e) {
                log.error((Object)("Error while getting Top Rated APIs Information" + e));
                return myn;
            }
            Iterator it = apiSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                row.put("name", (Scriptable)row, (Object)apiIdentifier.getApiName());
                row.put("provider", (Scriptable)row, (Object)apiIdentifier.getProviderName());
                row.put("version", (Scriptable)row, (Object)apiIdentifier.getVersion());
                row.put("description", (Scriptable)row, (Object)api.getDescription());
                row.put("rates", (Scriptable)row, (Object)Float.valueOf(api.getRating()));
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        return myn;
    }

    public static NativeArray jsFunction_getRecentlyAddedAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray apiArray = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            Set apiSet;
            String limitArg = args[0].toString();
            int limit = Integer.parseInt(limitArg);
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                apiSet = apiConsumer.getRecentlyAddedAPIs(limit);
            }
            catch (APIManagementException e) {
                log.error((Object)("Error from Registry API while getting Recently Added APIs Information " + (Object)((Object)e)));
                return apiArray;
            }
            catch (NullPointerException e) {
                log.error((Object)("Error from Registry API while getting Recently Added APIs Information, No APIs in Registry " + e));
                return apiArray;
            }
            catch (Exception e) {
                log.error((Object)("Error while getting Recently Added APIs Information" + e));
                return apiArray;
            }
            Iterator it = apiSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject currentApi = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                currentApi.put("name", (Scriptable)currentApi, (Object)apiIdentifier.getApiName());
                currentApi.put("provider", (Scriptable)currentApi, (Object)apiIdentifier.getProviderName());
                currentApi.put("version", (Scriptable)currentApi, (Object)apiIdentifier.getVersion());
                currentApi.put("description", (Scriptable)currentApi, (Object)api.getDescription());
                currentApi.put("rates", (Scriptable)currentApi, (Object)Float.valueOf(api.getRating()));
                if (api.getThumbnailUrl() == null) {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)"images/api-default.png");
                } else {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)api.getThumbnailUrl());
                }
                apiArray.put(i, (Scriptable)apiArray, (Object)currentApi);
                ++i;
            }
        }
        return apiArray;
    }

    public static NativeArray jsFunction_searchAPI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray apiArray = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            Set apiSet;
            String searchTerm = args[0].toString();
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                apiSet = apiConsumer.searchAPI(searchTerm);
            }
            catch (APIManagementException e) {
                log.error((Object)("Error from Registry API while getting SearchAPI Information " + (Object)((Object)e)));
                return apiArray;
            }
            catch (NullPointerException e) {
                log.error((Object)("Error from Registry API while getting SearchAPI Information, No APIs in Registry " + e));
                return apiArray;
            }
            catch (Exception e) {
                log.error((Object)("Error while getting SearchAPI APIs Information" + e));
                return apiArray;
            }
            Iterator it = apiSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject currentApi = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                currentApi.put("name", (Scriptable)currentApi, (Object)apiIdentifier.getApiName());
                currentApi.put("provider", (Scriptable)currentApi, (Object)apiIdentifier.getProviderName());
                currentApi.put("version", (Scriptable)currentApi, (Object)apiIdentifier.getVersion());
                currentApi.put("description", (Scriptable)currentApi, (Object)api.getDescription());
                currentApi.put("rates", (Scriptable)currentApi, (Object)Float.valueOf(api.getRating()));
                currentApi.put("description", (Scriptable)currentApi, (Object)api.getDescription());
                currentApi.put("endpoint", (Scriptable)currentApi, (Object)api.getUrl());
                if (api.getThumbnailUrl() == null) {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)"images/api-default.png");
                } else {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)api.getThumbnailUrl());
                }
                apiArray.put(i, (Scriptable)apiArray, (Object)currentApi);
                ++i;
            }
        }
        return apiArray;
    }

    public static NativeArray jsFunction_searchAPIbyType(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray apiArray = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            Set apiSet;
            String searchTerm = args[0].toString();
            String searchType = args[1].toString();
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                apiSet = apiConsumer.searchAPI(searchTerm, searchType);
            }
            catch (APIManagementException e) {
                log.error((Object)("Error from Registry API while getting SearchAPI by type Information " + (Object)((Object)e)));
                return apiArray;
            }
            catch (NullPointerException e) {
                log.error((Object)("Error from Registry API while getting SearchAPI by type Information, No APIs in Registry " + e));
                return apiArray;
            }
            catch (Exception e) {
                log.error((Object)("Error while getting SearchAPI APIs by type Information" + e));
                return apiArray;
            }
            Iterator it = apiSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject currentApi = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                currentApi.put("name", (Scriptable)currentApi, (Object)apiIdentifier.getApiName());
                currentApi.put("provider", (Scriptable)currentApi, (Object)apiIdentifier.getProviderName());
                currentApi.put("version", (Scriptable)currentApi, (Object)apiIdentifier.getVersion());
                currentApi.put("description", (Scriptable)currentApi, (Object)api.getDescription());
                currentApi.put("rates", (Scriptable)currentApi, (Object)Float.valueOf(api.getRating()));
                currentApi.put("description", (Scriptable)currentApi, (Object)api.getDescription());
                currentApi.put("endpoint", (Scriptable)currentApi, (Object)api.getUrl());
                if (api.getThumbnailUrl() == null) {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)"images/api-default.png");
                } else {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)api.getThumbnailUrl());
                }
                apiArray.put(i, (Scriptable)apiArray, (Object)currentApi);
                ++i;
            }
        }
        return apiArray;
    }

    public static NativeArray jsFunction_getAPIsWithTag(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray apiArray = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            Set apiSet;
            String tagName = args[0].toString();
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                apiSet = apiConsumer.getAPIsWithTag(tagName);
            }
            catch (APIManagementException e) {
                log.error((Object)("Error from Registry API while getting APIs With Tag Information " + (Object)((Object)e)));
                return apiArray;
            }
            catch (NullPointerException e) {
                log.error((Object)("Error from Registry API while getting APIs With Tag Information, No APIs in Registry " + e));
                return apiArray;
            }
            catch (Exception e) {
                log.error((Object)("Error while getting APIs With Tag Information" + e));
                return apiArray;
            }
            Iterator it = apiSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject currentApi = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                currentApi.put("name", (Scriptable)currentApi, (Object)apiIdentifier.getApiName());
                currentApi.put("provider", (Scriptable)currentApi, (Object)apiIdentifier.getProviderName());
                currentApi.put("version", (Scriptable)currentApi, (Object)apiIdentifier.getVersion());
                currentApi.put("description", (Scriptable)currentApi, (Object)api.getDescription());
                currentApi.put("rates", (Scriptable)currentApi, (Object)Float.valueOf(api.getRating()));
                if (api.getThumbnailUrl() == null) {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)"images/api-default.png");
                } else {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)api.getThumbnailUrl());
                }
                apiArray.put(i, (Scriptable)apiArray, (Object)currentApi);
                ++i;
            }
        }
        return apiArray;
    }

    public static NativeArray jsFunction_getSubscribedAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray apiArray = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            String limitArg = args[0].toString();
            int limit = Integer.parseInt(limitArg);
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                Set apiSet = apiConsumer.getTopRatedAPIs(limit);
                Iterator it = apiSet.iterator();
                int i = 0;
                while (it.hasNext()) {
                    NativeObject currentApi = new NativeObject();
                    Object apiObject = it.next();
                    API api = (API)apiObject;
                    APIIdentifier apiIdentifier = api.getId();
                    currentApi.put("name", (Scriptable)currentApi, (Object)apiIdentifier.getApiName());
                    currentApi.put("provider", (Scriptable)currentApi, (Object)apiIdentifier.getProviderName());
                    currentApi.put("version", (Scriptable)currentApi, (Object)apiIdentifier.getVersion());
                    currentApi.put("description", (Scriptable)currentApi, (Object)api.getDescription());
                    currentApi.put("rates", (Scriptable)currentApi, (Object)Float.valueOf(api.getRating()));
                    apiArray.put(i, (Scriptable)apiArray, (Object)currentApi);
                    ++i;
                }
            }
            catch (APIManagementException e) {
                log.error((Object)"Error while getting API list", (Throwable)e);
                return apiArray;
            }
        }
        return apiArray;
    }

    public static NativeArray jsFunction_getAllTags(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        Set tags;
        NativeArray tagArray = new NativeArray(0L);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            tags = apiConsumer.getAllTags();
        }
        catch (APIManagementException e) {
            log.error((Object)("Error from Registry API while getting AllTags Information " + (Object)((Object)e)));
            return tagArray;
        }
        catch (NullPointerException e) {
            log.error((Object)("Error from Registry API while getting APIs All Tags Information, No APIs in Registry " + e));
            return tagArray;
        }
        catch (Exception e) {
            log.error((Object)("Error while getting All Tags" + e));
            return tagArray;
        }
        Iterator tagsI = tags.iterator();
        int i = 0;
        while (tagsI.hasNext()) {
            NativeObject currentTag = new NativeObject();
            Object tagObject = tagsI.next();
            Tag tag = (Tag)tagObject;
            currentTag.put("name", (Scriptable)currentTag, (Object)tag.getName());
            currentTag.put("count", (Scriptable)currentTag, (Object)"1");
            tagArray.put(i, (Scriptable)tagArray, (Object)currentTag);
            ++i;
        }
        return tagArray;
    }

    public static NativeArray jsFunction_getAllPublishedAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        Set apiSet;
        NativeArray myn = new NativeArray(0L);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            apiSet = apiConsumer.getAllPublishedAPIs();
        }
        catch (APIManagementException e) {
            log.error((Object)("Error from Registry API while getting API Information" + (Object)((Object)e)));
            return myn;
        }
        catch (Exception e) {
            log.error((Object)("Error while getting API Information" + e));
            return myn;
        }
        Iterator it = apiSet.iterator();
        int i = 0;
        while (it.hasNext()) {
            NativeObject row = new NativeObject();
            Object apiObject = it.next();
            API api = (API)apiObject;
            APIIdentifier apiIdentifier = api.getId();
            row.put("name", (Scriptable)row, (Object)apiIdentifier.getApiName());
            row.put("provider", (Scriptable)row, (Object)apiIdentifier.getProviderName());
            row.put("version", (Scriptable)row, (Object)apiIdentifier.getVersion());
            row.put("description", (Scriptable)row, (Object)api.getDescription());
            row.put("rates", (Scriptable)row, (Object)Float.valueOf(api.getRating()));
            row.put("endpoint", (Scriptable)row, (Object)api.getUrl());
            row.put("wsdl", (Scriptable)row, (Object)"http://appserver/services/echo?wsdl");
            row.put("updatedDate", (Scriptable)row, (Object)api.getLastUpdated().toString());
            row.put("tier", (Scriptable)row, (Object)api.getAvailableTiers());
            row.put("context", (Scriptable)row, (Object)api.getContext());
            row.put("status", (Scriptable)row, (Object)"Deployed");
            if (api.getThumbnailUrl() == null) {
                row.put("thumbnailurl", (Scriptable)row, (Object)"images/api-default.png");
            } else {
                row.put("thumbnailurl", (Scriptable)row, (Object)api.getThumbnailUrl());
            }
            myn.put(i, (Scriptable)myn, (Object)row);
            ++i;
        }
        return myn;
    }

    public static NativeArray jsFunction_getAPI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        API api;
        String username = null;
        boolean isSubscribed = false;
        String methodName = "getAPI";
        int argsCount = args.length;
        if (argsCount != 4) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)methodName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        if (!(args[2] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"3", (String)"string", (Object)args[2], (boolean)false);
        }
        if (args[3] != null) {
            if (!(args[3] instanceof String)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"4", (String)"string", (Object)args[3], (boolean)false);
            }
            username = (String)args[3];
        }
        String providerName = (String)args[0];
        String apiName = (String)args[1];
        String version = (String)args[2];
        APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, version);
        NativeArray myn = new NativeArray(0L);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            api = apiConsumer.getAPI(apiIdentifier);
            if (username != null) {
                isSubscribed = apiConsumer.isSubscribed(apiIdentifier, username);
            }
        }
        catch (APIManagementException e) {
            log.error((Object)("Error from Registry API while getting get API Information on " + apiName + (Object)((Object)e)));
            return myn;
        }
        catch (NullPointerException e) {
            log.error((Object)("Error from Registry API while getting API information on " + apiName + e));
            return myn;
        }
        catch (Exception e) {
            log.error((Object)("Error while getting API Information" + e));
            return myn;
        }
        NativeObject row = new NativeObject();
        apiIdentifier = api.getId();
        row.put("name", (Scriptable)row, (Object)apiIdentifier.getApiName());
        row.put("provider", (Scriptable)row, (Object)apiIdentifier.getProviderName());
        row.put("version", (Scriptable)row, (Object)apiIdentifier.getVersion());
        row.put("description", (Scriptable)row, (Object)api.getDescription());
        row.put("rates", (Scriptable)row, (Object)Float.valueOf(api.getRating()));
        row.put("endpoint", (Scriptable)row, (Object)api.getUrl());
        row.put("wsdl", (Scriptable)row, (Object)api.getWsdlUrl());
        row.put("wadl", (Scriptable)row, (Object)api.getWadlUrl());
        row.put("updatedDate", (Scriptable)row, (Object)api.getLastUpdated().toString());
        row.put("context", (Scriptable)row, (Object)api.getContext());
        row.put("status", (Scriptable)row, (Object)api.getStatus().getStatus());
        String user = APIStoreHostObject.getUsernameFromObject(thisObj);
        int userRate = apiConsumer.getUserRating(apiIdentifier, user);
        row.put("userRate", (Scriptable)row, (Object)userRate);
        APIManagerConfiguration config = HostObjectComponent.getAPIManagerConfiguration();
        row.put("serverURL", (Scriptable)row, (Object)config.getFirstProperty("APIGateway.APIEndpointURL"));
        StringBuffer tiersSet = new StringBuffer("");
        StringBuffer tiersDescSet = new StringBuffer("");
        Set tierSet = api.getAvailableTiers();
        Iterator it = tierSet.iterator();
        int j = 0;
        while (it.hasNext()) {
            Object tierObject = it.next();
            Tier tier = (Tier)tierObject;
            tiersSet.append(tier.getName());
            tiersDescSet.append(tier.getDescription());
            if (j != tierSet.size() - 1) {
                tiersSet.append(",");
                tiersDescSet.append(",");
            }
            ++j;
        }
        row.put("tierName", (Scriptable)row, (Object)tiersSet.toString());
        row.put("tierDescription", (Scriptable)row, (Object)tiersDescSet.toString());
        row.put("subscribed", (Scriptable)row, (Object)isSubscribed);
        if (api.getThumbnailUrl() == null) {
            row.put("thumbnailurl", (Scriptable)row, (Object)"images/api-default.png");
        } else {
            row.put("thumbnailurl", (Scriptable)row, (Object)api.getThumbnailUrl());
        }
        row.put("bizOwner", (Scriptable)row, (Object)api.getBusinessOwner());
        row.put("bizOwnerMail", (Scriptable)row, (Object)api.getBusinessOwnerEmail());
        row.put("techOwner", (Scriptable)row, (Object)api.getTechnicalOwner());
        row.put("techOwnerMail", (Scriptable)row, (Object)api.getTechnicalOwnerEmail());
        myn.put(0, (Scriptable)myn, (Object)row);
        return myn;
    }

    public static boolean jsFunction_isSubscribed(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        String username = null;
        String methodName = "isSubscribed";
        int argsCount = args.length;
        if (argsCount != 4) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)methodName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        if (!(args[2] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"3", (String)"string", (Object)args[2], (boolean)false);
        }
        if (args[3] != null) {
            if (!(args[3] instanceof String)) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)methodName, (String)"4", (String)"string", (Object)args[3], (boolean)false);
            }
            username = (String)args[3];
        }
        String providerName = (String)args[0];
        String apiName = (String)args[1];
        String version = (String)args[2];
        APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, version);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        return username != null && apiConsumer.isSubscribed(apiIdentifier, username);
    }

    public static NativeArray jsFunction_getAPIKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        String providerName = "";
        String apiName = "";
        String version = "";
        String apiContext = "";
        if (APIStoreHostObject.isStringArray(args)) {
            providerName = args[0].toString();
            apiName = args[1].toString();
            version = args[2].toString();
            apiContext = args[3].toString();
        }
        APIInfoDTO apiInfoDTO = new APIInfoDTO();
        apiInfoDTO.setApiName(apiName);
        apiInfoDTO.setContext(apiContext);
        apiInfoDTO.setProviderId(providerName);
        apiInfoDTO.setVersion(version);
        String key = "";
        NativeArray myn = new NativeArray(0L);
        NativeObject row = new NativeObject();
        myn.put(0, (Scriptable)myn, (Object)row);
        return myn;
    }

    public static NativeArray jsFunction_getAllDocumentation(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        List doclist;
        String providerName = "";
        String apiName = "";
        String version = "";
        if (APIStoreHostObject.isStringArray(args)) {
            providerName = args[0].toString();
            apiName = args[1].toString();
            version = args[2].toString();
        }
        APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, version);
        NativeArray myn = new NativeArray(0L);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            doclist = apiConsumer.getAllDocumentation(apiIdentifier);
        }
        catch (APIManagementException e) {
            log.error((Object)("Error from Registry API while getting All Documentation on" + apiName + (Object)((Object)e)));
            return myn;
        }
        catch (NullPointerException e) {
            log.error((Object)("Error from Registry API while getting All Documentation on" + apiName + e));
            return myn;
        }
        catch (Exception e) {
            log.error((Object)("Error while getting All Documentation " + apiName + e));
            return myn;
        }
        Iterator it = doclist.iterator();
        int i = 0;
        while (it.hasNext()) {
            NativeObject row = new NativeObject();
            Object docObject = it.next();
            Documentation documentation = (Documentation)docObject;
            Documentation.DocumentSourceType objectSourceType = documentation.getSourceType();
            String strSourceType = objectSourceType.toString();
            row.put("name", (Scriptable)row, (Object)documentation.getName());
            row.put("sourceType", (Scriptable)row, (Object)strSourceType);
            row.put("summary", (Scriptable)row, (Object)documentation.getSummary());
            if (strSourceType.equals("INLINE")) {
                String content = apiConsumer.getDocumentationContent(apiIdentifier, documentation.getName());
                row.put("content", (Scriptable)row, (Object)content);
            }
            row.put("sourceUrl", (Scriptable)row, (Object)documentation.getSourceUrl());
            DocumentationType documentationType = documentation.getType();
            row.put("type", (Scriptable)row, (Object)documentationType.getType());
            myn.put(i, (Scriptable)myn, (Object)row);
            ++i;
        }
        return myn;
    }

    public static NativeArray jsFunction_getComments(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        Comment[] commentlist;
        String providerName = "";
        String apiName = "";
        String version = "";
        if (APIStoreHostObject.isStringArray(args)) {
            providerName = args[0].toString();
            apiName = args[1].toString();
            version = args[2].toString();
        }
        APIIdentifier apiIdentifyer = new APIIdentifier(providerName, apiName, version);
        NativeArray myn = new NativeArray(0L);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            commentlist = apiConsumer.getComments(apiIdentifyer);
        }
        catch (APIManagementException e) {
            log.error((Object)("Error from Registry API while getting Comments for " + apiName + (Object)((Object)e)));
            return myn;
        }
        catch (NullPointerException e) {
            log.error((Object)("Error from Registry API while getting Comments for " + apiName + e));
            return myn;
        }
        catch (Exception e) {
            log.error((Object)("Error while getting Comments for " + apiName + e));
            return myn;
        }
        int i = 0;
        for (Comment n : commentlist) {
            NativeObject row = new NativeObject();
            row.put("userName", (Scriptable)row, (Object)n.getUser());
            row.put("comment", (Scriptable)row, (Object)n.getText());
            row.put("createdTime", (Scriptable)row, (Object)n.getCreatedTime().getTime());
            myn.put(i, (Scriptable)myn, (Object)row);
            ++i;
        }
        return myn;
    }

    public static NativeArray jsFunction_addComments(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        String providerName = "";
        String apiName = "";
        String version = "";
        String commentStr = "";
        if (APIStoreHostObject.isStringArray(args)) {
            providerName = args[0].toString();
            apiName = args[1].toString();
            version = args[2].toString();
            commentStr = args[3].toString();
        }
        APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, version);
        NativeArray myn = new NativeArray(0L);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            apiConsumer.addComment(apiIdentifier, commentStr, APIStoreHostObject.getUsernameFromObject(thisObj));
        }
        catch (APIManagementException e) {
            log.error((Object)("Error from Registry API while adding Comments for " + apiName + (Object)((Object)e)));
            return myn;
        }
        catch (NullPointerException e) {
            log.error((Object)("Error from Registry API while adding Comments for " + apiName + e));
            return myn;
        }
        catch (Exception e) {
            log.error((Object)("Error while adding Comments for " + apiName + e));
            return myn;
        }
        int i = 0;
        NativeObject row = new NativeObject();
        row.put("userName", (Scriptable)row, (Object)providerName);
        row.put("comment", (Scriptable)row, (Object)commentStr);
        myn.put(i, (Scriptable)myn, (Object)row);
        return myn;
    }

    public static NativeArray jsFunction_ListProviders(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        NativeArray myn = new NativeArray(0L);
        String[] providers = SampleData.providers;
        for (int i = 0; i < providers.length; ++i) {
            myn.put(i, (Scriptable)myn, (Object)providers[i]);
        }
        return myn;
    }

    public static NativeArray jsFunction_ListApplications(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        NativeArray myn = new NativeArray(0L);
        String[] application = SampleData.application;
        for (int i = 0; i < application.length; ++i) {
            myn.put(i, (Scriptable)myn, (Object)application[i]);
        }
        return myn;
    }

    public static NativeArray jsFunction_ListAPIServices() throws ScriptException {
        NativeArray myn = new NativeArray(0L);
        Services[] serviceList = SampleData.listSerives;
        for (int i = 0; i < serviceList.length; ++i) {
            NativeObject row = new NativeObject();
            String o = serviceList[i].getName();
            row.put("name", (Scriptable)row, (Object)o);
            row.put("rates", (Scriptable)row, (Object)serviceList[i].getRating());
            row.put("author", (Scriptable)row, (Object)serviceList[i].getAuthor());
            myn.put(i, (Scriptable)myn, (Object)row);
        }
        return myn;
    }

    public static NativeArray jsFunction_ListProvidersNames() throws ScriptException {
        NativeArray providersN = new NativeArray(0L);
        String[] providers = SampleData.providers;
        for (int i = 0; i < providers.length; ++i) {
            String o = providers[i];
            providersN.put(i, (Scriptable)providersN, (Object)o);
        }
        return providersN;
    }

    public static NativeArray jsFunction_giveAPIIdentifiers() throws ScriptException {
        NativeArray myn = new NativeArray(0L);
        APIIdentifier[] serviceList = sampleData.giveAPIIdentifiers();
        for (int i = 0; i < serviceList.length; ++i) {
            NativeObject row = new NativeObject();
            row.put("name", (Scriptable)row, (Object)serviceList[i].getApiName());
            row.put("provider", (Scriptable)row, (Object)serviceList[i].getProviderName());
            row.put("version", (Scriptable)row, (Object)serviceList[i].getVersion());
            myn.put(i, (Scriptable)myn, (Object)row);
        }
        return myn;
    }

    public static boolean jsFunction_addSubscription(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (!(args[0] instanceof String && args[1] instanceof String && args[2] instanceof String && args[3] instanceof String && (args[4] instanceof Double || args[4] instanceof Integer) && args[5] instanceof String)) {
            return false;
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        String tier = args[3].toString();
        int applicationId = ((Number)args[4]).intValue();
        String userId = args[5].toString();
        APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, version);
        apiIdentifier.setTier(tier);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            apiConsumer.addSubscription(apiIdentifier, userId, applicationId);
            return true;
        }
        catch (APIManagementException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean jsFunction_removeSubscriber(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String providerName = "";
        String apiName = "";
        String version = "";
        String application = "";
        String userId = "";
        if (APIStoreHostObject.isStringArray(args)) {
            providerName = args[0].toString();
            apiName = args[1].toString();
            version = args[2].toString();
            application = (String)args[3];
            userId = args[4].toString();
        }
        APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, version);
        apiIdentifier.setApplicationId(application);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            apiConsumer.removeSubscriber(apiIdentifier, userId);
            return true;
        }
        catch (APIManagementException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static NativeArray jsFunction_rateAPI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            int rate;
            String providerName = args[0].toString();
            String apiName = args[1].toString();
            String version = args[2].toString();
            String rateStr = args[3].toString();
            try {
                rate = Integer.parseInt(rateStr.substring(0, 1));
            }
            catch (NumberFormatException e) {
                log.error((Object)("Rate must to be number " + rateStr + e));
                return myn;
            }
            catch (Exception e) {
                log.error((Object)("Error from while Rating API " + rateStr + e));
                return myn;
            }
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
                String user = APIStoreHostObject.getUsernameFromObject(thisObj);
                switch (rate) {
                    case 0: {
                        apiConsumer.rateAPI(apiId, APIRating.RATING_ZERO, user);
                        break;
                    }
                    case 1: {
                        apiConsumer.rateAPI(apiId, APIRating.RATING_ONE, user);
                        break;
                    }
                    case 2: {
                        apiConsumer.rateAPI(apiId, APIRating.RATING_TWO, user);
                        break;
                    }
                    case 3: {
                        apiConsumer.rateAPI(apiId, APIRating.RATING_THREE, user);
                        break;
                    }
                    case 4: {
                        apiConsumer.rateAPI(apiId, APIRating.RATING_FOUR, user);
                        break;
                    }
                    case 5: {
                        apiConsumer.rateAPI(apiId, APIRating.RATING_FIVE, user);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Can't handle " + rate);
                    }
                }
            }
            catch (APIManagementException e) {
                log.error((Object)("Error from Registry API while Rating API " + apiName + (Object)((Object)e)));
                return myn;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Error from Registry API while Rating API " + apiName + e));
                return myn;
            }
            catch (NullPointerException e) {
                log.error((Object)("Error from Registry API while Rating API " + apiName + e));
                return myn;
            }
            catch (Exception e) {
                log.error((Object)("Error while Rating API " + apiName + e));
                return myn;
            }
            NativeObject row = new NativeObject();
            row.put("name", (Scriptable)row, (Object)apiName);
            row.put("provider", (Scriptable)row, (Object)providerName);
            row.put("version", (Scriptable)row, (Object)version);
            row.put("rates", (Scriptable)row, (Object)rateStr);
            myn.put(0, (Scriptable)myn, (Object)row);
        }
        return myn;
    }

    public static NativeArray jsFunction_getSubscribedAPIs() throws ScriptException {
        NativeArray purchases = new NativeArray(0L);
        purchasedServices[] purchasedlist = SampleData.purchasedServiceList;
        for (int i = 0; i < purchasedlist.length; ++i) {
            NativeObject row = new NativeObject();
            String name = purchasedlist[i].getName();
            String author = purchasedlist[i].getAuthor();
            String rate = purchasedlist[i].getRating();
            String canDel = purchasedlist[i].getCanDelete();
            String descrp = purchasedlist[i].getDescription();
            String namespace = purchasedlist[i].getNamespace();
            String path = purchasedlist[i].getPath();
            String purchased = purchasedlist[i].getPurchased();
            String supportUrl = purchasedlist[i].getSupportForumURL();
            String thumbUrl = purchasedlist[i].getThumbURL();
            String version = purchasedlist[i].getVersion();
            row.put("name", (Scriptable)row, (Object)name);
            row.put("path", (Scriptable)row, (Object)path);
            row.put("author", (Scriptable)row, (Object)author);
            row.put("purchased", (Scriptable)row, (Object)purchased);
            row.put("description", (Scriptable)row, (Object)descrp);
            row.put("supportForumURL", (Scriptable)row, (Object)supportUrl);
            row.put("version", (Scriptable)row, (Object)version);
            row.put("rating", (Scriptable)row, (Object)rate);
            row.put("namespace", (Scriptable)row, (Object)namespace);
            row.put("canDelete", (Scriptable)row, (Object)canDel);
            row.put("thumbURL", (Scriptable)row, (Object)thumbUrl);
            purchases.put(i, (Scriptable)purchases, (Object)row);
        }
        return purchases;
    }

    public static NativeArray jsFunction_getSubscriptions(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            String providerName = args[0].toString();
            String apiName = args[1].toString();
            String version = args[2].toString();
            String user = args[3].toString();
            APIIdentifier apiIdentifier = new APIIdentifier(providerName, apiName, version);
            Subscriber subscriber = new Subscriber(user);
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            Set apis = apiConsumer.getSubscribedIdentifiers(subscriber, apiIdentifier);
            int i = 0;
            for (SubscribedAPI api : apis) {
                NativeObject row = new NativeObject();
                row.put("application", (Scriptable)row, (Object)api.getApplication().getName());
                row.put("applicationId", (Scriptable)row, (Object)api.getApplication().getId());
                row.put("prodKey", (Scriptable)row, (Object)APIStoreHostObject.getKey(api, "PRODUCTION"));
                row.put("sandboxKey", (Scriptable)row, (Object)APIStoreHostObject.getKey(api, "SANDBOX"));
                myn.put(i++, (Scriptable)myn, (Object)row);
            }
        }
        return myn;
    }

    private static String getKey(SubscribedAPI api, String keyType) {
        List apiKeys = api.getKeys();
        for (APIKey key : apiKeys) {
            if (!keyType.equals(key.getType())) continue;
            return key.getKey();
        }
        return null;
    }

    private static String getAppKey(Application app, String keyType) {
        List apiKeys = app.getKeys();
        for (APIKey key : apiKeys) {
            if (!keyType.equals(key.getType())) continue;
            return key.getKey();
        }
        return null;
    }

    public static NativeArray jsFunction_getAllSubscriptions(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        if (args.length != 1 || !(args[0] instanceof String)) {
            return null;
        }
        String user = (String)args[0];
        Subscriber subscriber = new Subscriber(user);
        HashMap<Integer, NativeArray> subscriptionsMap = new HashMap<Integer, NativeArray>();
        NativeArray appsObj = new NativeArray(0L);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        Set subscribedAPIs = apiConsumer.getSubscribedAPIs(subscriber);
        int i = 0;
        for (SubscribedAPI subscribedAPI : subscribedAPIs) {
            NativeArray apisArray = (NativeArray)subscriptionsMap.get(subscribedAPI.getApplication().getId());
            if (apisArray == null) {
                apisArray = new NativeArray(1L);
                NativeObject appObj = new NativeObject();
                appObj.put("id", (Scriptable)appObj, (Object)subscribedAPI.getApplication().getId());
                appObj.put("name", (Scriptable)appObj, (Object)subscribedAPI.getApplication().getName());
                appObj.put("prodKey", (Scriptable)appObj, (Object)APIStoreHostObject.getAppKey(subscribedAPI.getApplication(), "PRODUCTION"));
                appObj.put("sandboxKey", (Scriptable)appObj, (Object)APIStoreHostObject.getAppKey(subscribedAPI.getApplication(), "SANDBOX"));
                APIStoreHostObject.addAPIObj(subscribedAPI, apisArray, thisObj);
                appObj.put("subscriptions", (Scriptable)appObj, (Object)apisArray);
                appsObj.put(i++, (Scriptable)appsObj, (Object)appObj);
                subscriptionsMap.put(subscribedAPI.getApplication().getId(), apisArray);
                continue;
            }
            APIStoreHostObject.addAPIObj(subscribedAPI, apisArray, thisObj);
        }
        return appsObj;
    }

    private static void addAPIObj(SubscribedAPI subscribedAPI, NativeArray apisArray, Scriptable thisObj) throws ScriptException {
        NativeObject apiObj = new NativeObject();
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            API api = apiConsumer.getAPI(subscribedAPI.getApiId());
            apiObj.put("name", (Scriptable)apiObj, (Object)subscribedAPI.getApiId().getApiName());
            apiObj.put("provider", (Scriptable)apiObj, (Object)subscribedAPI.getApiId().getProviderName());
            apiObj.put("version", (Scriptable)apiObj, (Object)subscribedAPI.getApiId().getVersion());
            apiObj.put("status", (Scriptable)apiObj, (Object)api.getStatus().toString());
            apiObj.put("tier", (Scriptable)apiObj, (Object)subscribedAPI.getTier().getName());
            apiObj.put("thumburl", (Scriptable)apiObj, (Object)api.getThumbnailUrl());
            apiObj.put("context", (Scriptable)apiObj, (Object)api.getContext());
            apiObj.put("prodKey", (Scriptable)apiObj, (Object)APIStoreHostObject.getKey(subscribedAPI, "PRODUCTION"));
            apiObj.put("sandboxKey", (Scriptable)apiObj, (Object)APIStoreHostObject.getKey(subscribedAPI, "SANDBOX"));
            apiObj.put("hasMultipleEndpoints", (Scriptable)apiObj, (Object)String.valueOf(api.getSandboxUrl() != null));
            apisArray.put(apisArray.getIds().length, (Scriptable)apisArray, (Object)apiObj);
        }
        catch (APIManagementException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public static NativeObject jsFunction_getSubscriber(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        if (APIStoreHostObject.isStringArray(args)) {
            Subscriber subscriber;
            NativeObject user = new NativeObject();
            String userName = args[0].toString();
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                subscriber = apiConsumer.getSubscriber(userName);
            }
            catch (APIManagementException e) {
                log.error((Object)("Error from Registry API while getting Subscriber" + (Object)((Object)e)));
                return null;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Error from Registry API while getting Subscriber " + e));
                return null;
            }
            catch (NullPointerException e) {
                log.error((Object)("Error from Registry API while getting Subscriber" + e));
                return null;
            }
            catch (Exception e) {
                log.error((Object)("Error while getting Subscriber " + e));
                return null;
            }
            if (subscriber == null) {
                return null;
            }
            user.put("name", (Scriptable)user, (Object)subscriber.getName());
            user.put("id", (Scriptable)user, (Object)subscriber.getId());
            user.put("email", (Scriptable)user, (Object)subscriber.getEmail());
            user.put("subscribedDate", (Scriptable)user, (Object)subscriber.getSubscribedDate());
            return user;
        }
        return null;
    }

    public static boolean jsFunction_addSubscriber(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        if (APIStoreHostObject.isStringArray(args)) {
            Subscriber subscriber = new Subscriber((String)args[0]);
            subscriber.setSubscribedDate(new Date());
            subscriber.setEmail("");
            subscriber.setTenantId(-1234);
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                apiConsumer.addSubscriber(subscriber);
            }
            catch (APIManagementException e) {
                log.error((Object)("Error from Registry API while adding Subscriber" + (Object)((Object)e)));
                return false;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Error from Registry API while adding Subscriber " + e));
                return false;
            }
            catch (NullPointerException e) {
                log.error((Object)("Error from Registry API while adding Subscriber" + e));
                return false;
            }
            catch (Exception e) {
                log.error((Object)("Error while adding Subscriber " + e));
                return false;
            }
            return true;
        }
        return false;
    }

    public static NativeArray jsFunction_getApplications(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            String username = args[0].toString();
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            Application[] applications = apiConsumer.getApplications(new Subscriber(username));
            if (applications != null) {
                int i = 0;
                for (Application application : applications) {
                    NativeObject row = new NativeObject();
                    row.put("name", (Scriptable)row, (Object)application.getName());
                    row.put("id", (Scriptable)row, (Object)application.getId());
                    myn.put(i++, (Scriptable)myn, (Object)row);
                }
            }
        }
        return myn;
    }

    public static boolean jsFunction_addApplication(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        if (APIStoreHostObject.isStringArray(args)) {
            Application[] apps;
            String name = (String)args[0];
            String username = (String)args[1];
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            Subscriber subscriber = new Subscriber(username);
            for (Application app : apps = apiConsumer.getApplications(subscriber)) {
                if (!app.getName().equals(name)) continue;
                throw new APIManagementException("A duplicate application already exists by the name - " + name);
            }
            Application application = new Application(name, subscriber);
            apiConsumer.addApplication(application, username);
            return true;
        }
        return false;
    }

    public static boolean jsFunction_removeApplication(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        if (APIStoreHostObject.isStringArray(args)) {
            String name = (String)args[0];
            String username = (String)args[1];
            Subscriber subscriber = new Subscriber(username);
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            Application[] apps = apiConsumer.getApplications(subscriber);
            if (apps == null || apps.length == 0) {
                return false;
            }
            for (Application app : apps) {
                if (!app.getName().equals(name)) continue;
                apiConsumer.removeApplication(app);
                return true;
            }
        }
        return false;
    }

    public static NativeArray jsFunction_getSubscriptionsByApplication(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            String name = (String)args[0];
            String username = (String)args[1];
            Subscriber subscriber = new Subscriber(username);
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            Set subscribedAPIs = apiConsumer.getSubscribedAPIs(subscriber);
            int i = 0;
            for (SubscribedAPI api : subscribedAPIs) {
                if (!api.getApplication().getName().equals(name)) continue;
                NativeObject row = new NativeObject();
                row.put("apiName", (Scriptable)row, (Object)api.getApiId().getApiName());
                row.put("apiVersion", (Scriptable)row, (Object)api.getApiId().getVersion());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        return myn;
    }

    public static boolean jsFunction_updateApplication(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        if (APIStoreHostObject.isStringArray(args)) {
            String name = (String)args[0];
            String oldName = (String)args[1];
            String username = (String)args[2];
            Subscriber subscriber = new Subscriber(username);
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            Application[] apps = apiConsumer.getApplications(subscriber);
            if (apps == null || apps.length == 0) {
                return false;
            }
            for (Application app : apps) {
                if (!app.getName().equals(oldName)) continue;
                Application application = new Application(name, subscriber);
                application.setId(app.getId());
                apiConsumer.updateApplication(application);
                return true;
            }
        }
        return false;
    }

    public static NativeArray jsFunction_getInlineContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            String content;
            String providerName = args[0].toString();
            String apiName = args[1].toString();
            String version = args[2].toString();
            String docName = args[3].toString();
            APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
            try {
                APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
                content = apiConsumer.getDocumentationContent(apiId, docName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)content);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while getting Inline Document Content ", (Throwable)e);
                return null;
            }
            NativeObject row = new NativeObject();
            row.put("providerName", (Scriptable)row, (Object)providerName);
            row.put("apiName", (Scriptable)row, (Object)apiName);
            row.put("apiVersion", (Scriptable)row, (Object)version);
            row.put("docName", (Scriptable)row, (Object)docName);
            row.put("content", (Scriptable)row, (Object)content);
            myn.put(0, (Scriptable)myn, (Object)row);
        }
        return myn;
    }

    public static boolean isStringArray(Object[] args) {
        int argsCount = args.length;
        for (int i = 0; i < argsCount; ++i) {
            if (args[i] instanceof String) continue;
            return false;
        }
        return true;
    }

    public static boolean jsFunction_hasSubscribePermission(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        APIConsumer consumer = APIStoreHostObject.getAPIConsumer(thisObj);
        if (consumer instanceof UserAwareAPIConsumer) {
            try {
                ((UserAwareAPIConsumer)consumer).checkSubscribePermission();
                return true;
            }
            catch (APIManagementException e) {
                return false;
            }
        }
        return false;
    }

    public static void jsFunction_addUser(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        String username = args[0].toString();
        String password = args[1].toString();
        APIManagerConfiguration config = HostObjectComponent.getAPIManagerConfiguration();
        boolean enabled = Boolean.parseBoolean(config.getFirstProperty("SelfSignUp.Enabled"));
        if (!enabled) {
            throw new APIManagementException("Self sign up has been disabled on this server");
        }
        String serverURL = config.getFirstProperty("AuthManager.ServerURL");
        String adminUsername = config.getFirstProperty("AuthManager.Username");
        String adminPassword = config.getFirstProperty("AuthManager.Password");
        if (serverURL == null || adminUsername == null || adminPassword == null) {
            throw new APIManagementException("Required parameter missing to connect to the authentication manager");
        }
        String role = config.getFirstProperty("SelfSignUp.SubscriberRoleName");
        if (role == null) {
            throw new APIManagementException("Subscriber role undefined for self registration");
        }
        String url = serverURL + "UserAdmin";
        try {
            UserAdminStub stub = new UserAdminStub(url);
            CarbonUtils.setBasicAccessSecurityHeaders((String)adminUsername, (String)adminPassword, (boolean)true, (ServiceClient)stub._getServiceClient());
            stub.addUser(username, password, new String[]{role}, null, null);
        }
        catch (RemoteException e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        catch (AddUserUserAdminExceptionException e) {
            throw new APIManagementException("Error while adding the user: " + username, (Throwable)e);
        }
    }

    public static boolean jsFunction_removeSubscription(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        String username = args[0].toString();
        int applicationId = ((Number)args[1]).intValue();
        NativeObject apiData = (NativeObject)args[2];
        String provider = (String)apiData.get("provider", (Scriptable)apiData);
        String name = (String)apiData.get("apiName", (Scriptable)apiData);
        String version = (String)apiData.get("version", (Scriptable)apiData);
        APIIdentifier apiId = new APIIdentifier(provider, name, version);
        APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
        try {
            apiConsumer.removeSubscription(apiId, username, applicationId);
            return true;
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error while removing the subscription of" + name + "-" + version, (Throwable)e);
        }
    }

    public static NativeArray jsFunction_getPublishedAPIsByProvider(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray apiArray = new NativeArray(0L);
        if (APIStoreHostObject.isStringArray(args)) {
            Set apiSet;
            String providerName = args[0].toString();
            APIConsumer apiConsumer = APIStoreHostObject.getAPIConsumer(thisObj);
            try {
                apiSet = apiConsumer.getPublishedAPIsByProvider(providerName);
            }
            catch (APIManagementException e) {
                throw new APIManagementException("Error while getting Published APIs Information of the provider - " + providerName, (Throwable)e);
            }
            catch (Exception e) {
                throw new APIManagementException(e.getMessage(), (Throwable)e);
            }
            Iterator it = apiSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject currentApi = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                currentApi.put("name", (Scriptable)currentApi, (Object)apiIdentifier.getApiName());
                currentApi.put("provider", (Scriptable)currentApi, (Object)apiIdentifier.getProviderName());
                currentApi.put("version", (Scriptable)currentApi, (Object)apiIdentifier.getVersion());
                currentApi.put("description", (Scriptable)currentApi, (Object)api.getDescription());
                currentApi.put("rates", (Scriptable)currentApi, (Object)Float.valueOf(api.getRating()));
                if (api.getThumbnailUrl() == null) {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)"images/api-default.png");
                } else {
                    currentApi.put("thumbnailurl", (Scriptable)currentApi, (Object)api.getThumbnailUrl());
                }
                apiArray.put(i, (Scriptable)apiArray, (Object)currentApi);
                ++i;
            }
            return apiArray;
        }
        throw new APIManagementException("Invalid types of input parameters.");
    }
}

