/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.throttling;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.PolicyEngine;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.rest.AbstractHandler;
import org.wso2.carbon.apimgt.handlers.Utils;
import org.wso2.carbon.apimgt.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.handlers.security.AuthenticationContext;
import org.wso2.throttle.AccessInformation;
import org.wso2.throttle.AccessRateController;
import org.wso2.throttle.ConcurrentAccessController;
import org.wso2.throttle.RoleBasedAccessRateController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleContext;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.ThrottleFactory;

public class APIThrottleHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(APIThrottleHandler.class);
    private volatile Throttle throttle;
    private ConcurrentAccessController concurrentAccessController = null;
    private AccessRateController accessController = new AccessRateController();
    private RoleBasedAccessRateController roleBasedAccessController = new RoleBasedAccessRateController();
    private String key;
    private String policyKey = null;
    private String id;
    private long version;
    private boolean isClusteringEnable = false;

    public boolean handleRequest(org.apache.synapse.MessageContext messageContext) {
        return this.doThrottle(messageContext);
    }

    public boolean handleResponse(org.apache.synapse.MessageContext messageContext) {
        return this.doThrottle(messageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doThrottle(org.apache.synapse.MessageContext messageContext) {
        boolean canAccess;
        boolean isResponse = messageContext.isResponse();
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        ConfigurationContext cc = axis2MC.getConfigurationContext();
        if (this.throttle == null) {
            APIThrottleHandler aPIThrottleHandler = this;
            synchronized (aPIThrottleHandler) {
                if (this.throttle == null) {
                    ClusteringAgent clusteringAgent = cc.getAxisConfiguration().getClusteringAgent();
                    boolean bl = this.isClusteringEnable = clusteringAgent != null && clusteringAgent.getStateManager() != null;
                    if (!isResponse) {
                        if (this.isClusteringEnable) {
                            this.concurrentAccessController = (ConcurrentAccessController)cc.getProperty(this.key);
                        }
                        this.initThrottle(messageContext, cc);
                    } else {
                        this.concurrentAccessController = (ConcurrentAccessController)cc.getProperty(this.key);
                    }
                }
            }
        }
        if ((canAccess = this.doThrottleByConcurrency(isResponse)) && !isResponse && this.throttle != null) {
            boolean bl = canAccess = this.throttleByAccessRate(axis2MC, cc) && this.doRoleBasedAccessThrottling(messageContext, cc);
        }
        if (this.isClusteringEnable && this.concurrentAccessController != null && cc != null) {
            try {
                Replicator.replicate((AbstractContext)cc);
            }
            catch (ClusteringFault clusteringFault) {
                this.handleException("Error during the replicating  states ", (Exception)((Object)clusteringFault));
            }
        }
        if (!canAccess) {
            this.handleThrottleOut(messageContext);
            return false;
        }
        return true;
    }

    private void handleThrottleOut(org.apache.synapse.MessageContext messageContext) {
        messageContext.setProperty("ERROR_CODE", (Object)900800);
        messageContext.setProperty("ERROR_MESSAGE", (Object)"Message throttled out");
        Mediator sequence = messageContext.getSequence("_throttle_out_handler_");
        if (sequence != null && !sequence.mediate(messageContext)) {
            return;
        }
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        axis2MC.setProperty("HTTP_SC", (Object)503);
        messageContext.setResponse(true);
        messageContext.setProperty("RESPONSE", (Object)"true");
        messageContext.setTo(null);
        if (messageContext.isDoingPOX() || messageContext.isDoingGET()) {
            Utils.setFaultPayload(messageContext, this.getFaultPayload());
        } else {
            Utils.setSOAPFault(messageContext, "Server", "Message Throttled Out", "You have exceeded your quota");
        }
        axis2MC.removeProperty("NO_ENTITY_BODY");
        Axis2Sender.sendBack((org.apache.synapse.MessageContext)messageContext);
    }

    private OMElement getFaultPayload() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("http://wso2.org/apimanager/throttling", "amt");
        OMElement payload = fac.createOMElement("fault", ns);
        OMElement errorCode = fac.createOMElement("code", ns);
        errorCode.setText(String.valueOf(900800));
        OMElement errorMessage = fac.createOMElement("message", ns);
        errorMessage.setText("Message Throttled Out");
        OMElement errorDetail = fac.createOMElement("description", ns);
        errorDetail.setText("You have exceeded your quota");
        payload.addChild((OMNode)errorCode);
        payload.addChild((OMNode)errorMessage);
        payload.addChild((OMNode)errorDetail);
        return payload;
    }

    private boolean doThrottleByConcurrency(boolean isResponse) {
        boolean canAccess = true;
        if (this.concurrentAccessController != null) {
            int concurrentLimit = this.concurrentAccessController.getLimit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Concurrent access controller for ID: " + this.id + " allows: " + concurrentLimit + " concurrent accesses"));
            }
            if (!isResponse) {
                int available = this.concurrentAccessController.getAndDecrement();
                boolean bl = canAccess = available > 0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Concurrency Throttle: Access " + (canAccess ? "allowed" : "denied") + " :: " + available + " of available of " + concurrentLimit + " connections"));
                }
            } else {
                int available = this.concurrentAccessController.incrementAndGet();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Concurrency Throttle : Connection returned :: " + available + " of available of " + concurrentLimit + " connections"));
                }
            }
        }
        return canAccess;
    }

    private boolean throttleByAccessRate(MessageContext axisMC, ConfigurationContext cc) {
        AccessInformation accessInformation;
        ThrottleConfiguration config;
        ThrottleContext context;
        String callerId = null;
        boolean canAccess = true;
        String remoteIP = (String)axisMC.getPropertyNonReplicable("REMOTE_ADDR");
        String domainName = (String)axisMC.getPropertyNonReplicable("REMOTE_HOST");
        if (domainName != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Domain Name of the caller is :" + domainName));
            }
            if ((context = this.throttle.getThrottleContext("key_of_domain_based_throttle")) != null && (config = context.getThrottleConfiguration()) != null && (callerId = config.getConfigurationKeyOfCaller(domainName)) != null) {
                if (this.isClusteringEnable) {
                    context.setConfigurationContext(cc);
                    context.setThrottleId(this.id);
                }
                try {
                    accessInformation = this.accessController.canAccess(context, callerId, 1);
                    canAccess = accessInformation.isAccessAllowed();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Access " + (canAccess ? "allowed" : "denied") + " for Domain Name : " + domainName));
                    }
                    if (!canAccess && this.concurrentAccessController != null) {
                        this.concurrentAccessController.incrementAndGet();
                        if (this.isClusteringEnable) {
                            cc.setProperty(this.key, (Object)this.concurrentAccessController);
                        }
                    }
                }
                catch (ThrottleException e) {
                    this.handleException("Error occurred during throttling", e);
                }
            }
        } else {
            log.debug((Object)"The Domain name of the caller cannot be found");
        }
        if (callerId == null) {
            if (remoteIP == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The IP address of the caller cannot be found");
                }
                canAccess = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The IP Address of the caller is :" + remoteIP));
                }
                try {
                    context = this.throttle.getThrottleContext("key_of_ip_based_throttle");
                    if (context != null && (config = context.getThrottleConfiguration()) != null && (callerId = config.getConfigurationKeyOfCaller(remoteIP)) != null) {
                        if (this.isClusteringEnable) {
                            context.setConfigurationContext(cc);
                            context.setThrottleId(this.id);
                        }
                        accessInformation = this.accessController.canAccess(context, callerId, 0);
                        canAccess = accessInformation.isAccessAllowed();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Access " + (canAccess ? "allowed" : "denied") + " for IP : " + remoteIP));
                        }
                        if (!canAccess && this.concurrentAccessController != null) {
                            this.concurrentAccessController.incrementAndGet();
                            if (this.isClusteringEnable) {
                                cc.setProperty(this.key, (Object)this.concurrentAccessController);
                            }
                        }
                    }
                }
                catch (ThrottleException e) {
                    this.handleException("Error occurred during throttling", e);
                }
            }
        }
        return canAccess;
    }

    private boolean doRoleBasedAccessThrottling(org.apache.synapse.MessageContext synCtx, ConfigurationContext cc) {
        boolean canAccess = true;
        if (this.throttle.getThrottleContext("key_of_role_based_throttle") == null) {
            return canAccess;
        }
        ConcurrentAccessController cac = null;
        if (this.isClusteringEnable) {
            cac = (ConcurrentAccessController)cc.getProperty(this.key);
        }
        if (!synCtx.isResponse()) {
            String roleID;
            String consumerKey;
            AuthenticationContext authContext = APISecurityUtils.getAuthenticationContext(synCtx);
            if (authContext != null) {
                consumerKey = authContext.getApiKey();
                roleID = authContext.getTier();
                if (consumerKey == null || roleID == null) {
                    log.warn((Object)"No consumer key or role information found on the request - Throttling not applied");
                    return true;
                }
                if ("Unlimited".equals(roleID)) {
                    return true;
                }
            } else {
                log.warn((Object)"No authentication context information found on the request - Throttling not applied");
                return true;
            }
            ThrottleContext context = this.throttle.getThrottleContext("key_of_role_based_throttle");
            if (context == null) {
                log.warn((Object)"Unable to load throttle context");
                return true;
            }
            ThrottleConfiguration config = context.getThrottleConfiguration();
            if (config != null) {
                String consumerRoleID = config.getConfigurationKeyOfCaller(roleID);
                if (consumerRoleID != null) {
                    if (this.isClusteringEnable) {
                        context.setConfigurationContext(cc);
                        context.setThrottleId(this.id);
                    }
                    AccessInformation info = null;
                    try {
                        info = this.roleBasedAccessController.canAccess(context, consumerKey, consumerRoleID);
                    }
                    catch (ThrottleException e) {
                        log.warn((Object)"Exception occurred while performing role based throttling", (Throwable)e);
                        canAccess = false;
                    }
                    if (info != null && !info.isAccessAllowed()) {
                        if (cac != null) {
                            cac.incrementAndGet();
                            if (this.isClusteringEnable) {
                                cc.setProperty(this.key, (Object)cac);
                                try {
                                    Replicator.replicate((AbstractContext)cc, (String[])new String[]{this.key});
                                }
                                catch (ClusteringFault clusteringFault) {
                                    log.error((Object)"Error during replicating states", (Throwable)clusteringFault);
                                }
                            }
                        }
                        canAccess = false;
                    }
                } else {
                    log.warn((Object)("Unable to find the throttle policy for role: " + roleID));
                }
            }
        }
        return canAccess;
    }

    private void initThrottle(org.apache.synapse.MessageContext synCtx, ConfigurationContext cc) {
        if (this.policyKey == null) {
            throw new SynapseException("Throttle policy unspecified for the API");
        }
        Entry entry = synCtx.getConfiguration().getEntryDefinition(this.policyKey);
        if (entry == null) {
            this.handleException("Cannot find throttling policy using key: " + this.policyKey);
            return;
        }
        boolean reCreate = false;
        if (entry.isDynamic() && (!entry.isCached() || entry.isExpired()) && this.version != entry.getVersion()) {
            reCreate = true;
        }
        if (reCreate || this.throttle == null) {
            Object entryValue = synCtx.getEntry(this.policyKey);
            if (entryValue == null || !(entryValue instanceof OMElement)) {
                this.handleException("Unable to load throttling policy using key: " + this.policyKey);
                return;
            }
            this.version = entry.getVersion();
            if (this.isClusteringEnable && this.concurrentAccessController != null && this.throttle != null) {
                this.concurrentAccessController = null;
            }
            try {
                this.throttle = ThrottleFactory.createMediatorThrottle(PolicyEngine.getPolicy((OMElement)((OMElement)entryValue)));
                if (!(this.throttle == null || this.concurrentAccessController != null && this.isClusteringEnable)) {
                    this.concurrentAccessController = this.throttle.getConcurrentAccessController();
                    if (this.concurrentAccessController != null) {
                        cc.setProperty(this.key, (Object)this.concurrentAccessController);
                    } else {
                        cc.removeProperty(this.key);
                    }
                }
            }
            catch (ThrottleException e) {
                this.handleException("Error processing the throttling policy", e);
            }
        }
    }

    public void setId(String id) {
        this.id = id;
        this.key = "throttle_" + id + "_cac_key";
    }

    public String getId() {
        return this.id;
    }

    public void setPolicyKey(String policyKey) {
        this.policyKey = policyKey;
    }

    public String gePolicyKey() {
        return this.policyKey;
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

