/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.security;

import net.sf.jsr107cache.Cache;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.handlers.security.keys.APIKeyDataStore;
import org.wso2.carbon.apimgt.handlers.security.keys.WSAPIKeyDataStore;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;

public class APIKeyValidator {
    private static final Log log = LogFactory.getLog(APIKeyValidator.class);
    private Cache infoCache;
    private volatile APIKeyDataStore dataStore;
    private AxisConfiguration axisConfig;

    public APIKeyValidator(AxisConfiguration axisConfig) {
        this.axisConfig = axisConfig;
        this.infoCache = this.initCache();
    }

    protected Cache initCache() {
        return SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)this.axisConfig).getCache();
    }

    public APIKeyValidationInfoDTO getKeyValidationInfo(String context, String apiKey, String apiVersion) throws APISecurityException {
        String cacheKey = apiKey + ":" + context + ":" + apiVersion;
        APIKeyValidationInfoDTO info = (APIKeyValidationInfoDTO)this.infoCache.get((Object)cacheKey);
        if (info != null) {
            return info;
        }
        String string = apiKey.intern();
        synchronized (string) {
            info = (APIKeyValidationInfoDTO)this.infoCache.get((Object)cacheKey);
            if (info != null) {
                return info;
            }
            info = this.doGetKeyValidationInfo(context, apiVersion, apiKey);
            if (info != null) {
                this.infoCache.put((Object)cacheKey, (Object)info);
                return info;
            }
            throw new APISecurityException(900900, "API key validator returned null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected APIKeyValidationInfoDTO doGetKeyValidationInfo(String context, String apiVersion, String apiKey) throws APISecurityException {
        if (this.dataStore == null) {
            APIKeyValidator aPIKeyValidator = this;
            synchronized (aPIKeyValidator) {
                if (this.dataStore == null) {
                    this.initDataStore();
                }
            }
        }
        return this.dataStore.getAPIKeyData(context, apiVersion, apiKey);
    }

    private void initDataStore() throws APISecurityException {
        log.debug((Object)"Initializing WS API key data store");
        this.dataStore = new WSAPIKeyDataStore();
    }

    public void cleanup() {
        if (this.dataStore != null) {
            this.dataStore.cleanup();
        }
    }
}

