/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.security;

import java.util.HashMap;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.rest.AbstractHandler;
import org.wso2.carbon.apimgt.handlers.Utils;
import org.wso2.carbon.apimgt.handlers.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.handlers.security.oauth.OAuthAuthenticator;

public class APIAuthenticationHandler
extends AbstractHandler
implements ManagedLifecycle {
    private static final Log log = LogFactory.getLog(APIAuthenticationHandler.class);
    private volatile Authenticator authenticator;

    public void init(SynapseEnvironment synapseEnvironment) {
        log.debug((Object)"Initializing API authentication handler instance");
        String authenticatorType = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getFirstProperty("APIConsumerAuthentication.Authenticator");
        if (authenticatorType == null) {
            authenticatorType = OAuthAuthenticator.class.getName();
        }
        try {
            this.authenticator = (Authenticator)Class.forName(authenticatorType).newInstance();
        }
        catch (Exception e) {
            throw new SynapseException("Error while initializing authenticator of type: " + authenticatorType);
        }
        this.authenticator.init(synapseEnvironment);
    }

    public void destroy() {
        log.debug((Object)"Destroying API authentication handler instance");
        this.authenticator.destroy();
    }

    public boolean handleRequest(org.apache.synapse.MessageContext messageContext) {
        try {
            if (this.authenticator.authenticate(messageContext)) {
                return true;
            }
        }
        catch (APISecurityException e) {
            log.error((Object)"API authentication failure", (Throwable)e);
            this.handleAuthFailure(messageContext, e);
        }
        return false;
    }

    public boolean handleResponse(org.apache.synapse.MessageContext messageContext) {
        return true;
    }

    private void handleAuthFailure(org.apache.synapse.MessageContext messageContext, APISecurityException e) {
        messageContext.setProperty("ERROR_CODE", (Object)e.getErrorCode());
        messageContext.setProperty("ERROR_MESSAGE", (Object)"Authentication failure");
        messageContext.setProperty("ERROR_EXCEPTION", (Object)e);
        Mediator sequence = messageContext.getSequence("_auth_failure_handler_");
        if (sequence != null && !sequence.mediate(messageContext)) {
            return;
        }
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        if (e.getErrorCode() == 900900) {
            axis2MC.setProperty("HTTP_SC", (Object)500);
        } else {
            axis2MC.setProperty("HTTP_SC", (Object)401);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("WWW-Authenticate", this.authenticator.getChallengeString());
            axis2MC.setProperty("TRANSPORT_HEADERS", headers);
        }
        messageContext.setResponse(true);
        messageContext.setProperty("RESPONSE", (Object)"true");
        messageContext.setTo(null);
        if (messageContext.isDoingPOX() || messageContext.isDoingGET()) {
            Utils.setFaultPayload(messageContext, this.getFaultPayload(e));
        } else {
            Utils.setSOAPFault(messageContext, "Client", "Authentication Failure", e.getMessage());
        }
        axis2MC.removeProperty("NO_ENTITY_BODY");
        Axis2Sender.sendBack((org.apache.synapse.MessageContext)messageContext);
    }

    private OMElement getFaultPayload(APISecurityException e) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("http://wso2.org/apimanager/security", "ams");
        OMElement payload = fac.createOMElement("fault", ns);
        OMElement errorCode = fac.createOMElement("code", ns);
        errorCode.setText(String.valueOf(e.getErrorCode()));
        OMElement errorMessage = fac.createOMElement("message", ns);
        errorMessage.setText("Authentication Failure");
        OMElement errorDetail = fac.createOMElement("description", ns);
        errorDetail.setText(e.getMessage());
        payload.addChild((OMNode)errorCode);
        payload.addChild((OMNode)errorMessage);
        payload.addChild((OMNode)errorDetail);
        return payload;
    }
}

