/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.ext;

import java.util.Map;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.rest.AbstractHandler;

public class APIManagerExtensionHandler
extends AbstractHandler {
    private static final String EXT_SEQUENCE_PREFIX = "WSO2AM--Ext--";
    private static final String DIRECTION_IN = "In";
    private static final String DIRECTION_OUT = "Out";

    public boolean mediate(MessageContext messageContext, String direction) {
        Map localRegistry = messageContext.getConfiguration().getLocalRegistry();
        Object sequence = localRegistry.get(EXT_SEQUENCE_PREFIX + direction);
        if (sequence != null && sequence instanceof Mediator && !((Mediator)sequence).mediate(messageContext)) {
            return false;
        }
        String apiName = (String)messageContext.getProperty("SYNAPSE_REST_API");
        String version = (String)messageContext.getProperty("SYNAPSE_REST_API_VERSION");
        sequence = localRegistry.get(apiName + "--" + version + "--" + direction);
        if (sequence != null && sequence instanceof Mediator) {
            return ((Mediator)sequence).mediate(messageContext);
        }
        return true;
    }

    public boolean handleRequest(MessageContext messageContext) {
        return this.mediate(messageContext, DIRECTION_IN);
    }

    public boolean handleResponse(MessageContext messageContext) {
        return this.mediate(messageContext, DIRECTION_OUT);
    }
}

