/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.state.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.CallerContext;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleException;

public abstract class ThrottleContext {
    private static Log log = LogFactory.getLog((String)ThrottleContext.class.getName());
    private Map callersMap;
    private Map keyToTimeStampMap;
    private long nextCleanTime;
    private ThrottleConfiguration throttleConfiguration;
    private String throttleId;
    private ConfigurationContext configctx;
    private String keyPrefix;
    private boolean debugOn;

    public ThrottleContext(ThrottleConfiguration throttleConfiguration) {
        if (throttleConfiguration == null) {
            throw new InstantiationError("Couldn't create the throttle context from null a throttle configuration");
        }
        this.keyToTimeStampMap = new HashMap();
        this.callersMap = new TreeMap();
        this.nextCleanTime = 0L;
        this.throttleConfiguration = throttleConfiguration;
        this.debugOn = log.isDebugEnabled();
    }

    public ThrottleConfiguration getThrottleConfiguration() {
        return this.throttleConfiguration;
    }

    public CallerContext getCallerContext(String id) {
        if (id != null) {
            Object co;
            if (this.debugOn) {
                log.debug((Object)("Found a configuration with id :" + id));
            }
            if (this.configctx != null && this.keyPrefix != null) {
                return (CallerContext)this.configctx.getPropertyNonReplicable(this.keyPrefix + id);
            }
            Long timeKey = (Long)this.keyToTimeStampMap.get(id);
            if (timeKey != null && (co = this.callersMap.get(timeKey)) != null) {
                if (co instanceof CallerContext) {
                    return (CallerContext)co;
                }
                if (co instanceof LinkedList) {
                    LinkedList callers = (LinkedList)co;
                    for (CallerContext cc : callers) {
                        if (cc == null || !id.equals(cc.getID())) continue;
                        return cc;
                    }
                }
            }
        } else if (this.debugOn) {
            log.debug((Object)("Couldn't find a configuration for the remote caller : " + id));
        }
        return null;
    }

    public void addCallerContext(CallerContext callerContext, String id) {
        if (callerContext != null && id != null) {
            this.addCaller(callerContext, id);
        }
    }

    private void addCaller(CallerContext callerContext, String id) {
        Long time;
        if (this.debugOn) {
            log.debug((Object)("Setting the caller with an id " + id));
        }
        if (this.configctx != null && this.keyPrefix != null) {
            this.configctx.setProperty(this.keyPrefix + id, (Object)callerContext);
        }
        if (!this.callersMap.containsKey(time = new Long(callerContext.getNextTimeWindow()))) {
            this.callersMap.put(time, callerContext);
        } else {
            Object callerObject = this.callersMap.get(time);
            if (callerObject != null) {
                if (callerObject instanceof CallerContext) {
                    LinkedList<Object> callersWithSameTimeStamp = new LinkedList<Object>();
                    callersWithSameTimeStamp.add(callerObject);
                    callersWithSameTimeStamp.add(callerContext);
                    this.callersMap.remove(time);
                    this.callersMap.put(time, callersWithSameTimeStamp);
                } else if (callerObject instanceof LinkedList) {
                    LinkedList callersWithSameTimeStamp = (LinkedList)callerObject;
                    callersWithSameTimeStamp.add(callerContext);
                }
            }
        }
        this.keyToTimeStampMap.put(id, time);
    }

    public void removeCallerContext(String id) {
        if (id != null) {
            this.removeCaller(id);
        }
    }

    private void removeCaller(String id) {
        Long time = (Long)this.keyToTimeStampMap.get(id);
        if (time != null) {
            if (this.configctx != null && this.keyPrefix != null) {
                if (this.debugOn) {
                    log.debug((Object)("Removing the caller with the configuration id " + id));
                }
                this.configctx.removeProperty(this.keyPrefix + id);
            }
            this.callersMap.remove(time);
            this.keyToTimeStampMap.remove(id);
        }
    }

    public void processCleanList(long time) throws ThrottleException {
        if (this.debugOn) {
            log.debug((Object)"Cleaning up process is executing");
        }
        if (time > this.nextCleanTime) {
            SortedMap map = ((TreeMap)this.callersMap).headMap(new Long(time));
            if (map != null && map.size() > 0) {
                for (Object o : map.values()) {
                    CallerContext c;
                    String key;
                    if (o == null) continue;
                    if (o instanceof CallerContext && (key = (c = (CallerContext)o).getID()) != null) {
                        if (this.configctx != null && this.keyPrefix != null) {
                            c = (CallerContext)this.configctx.getPropertyNonReplicable(this.keyPrefix + key);
                        }
                        if (c != null) {
                            c.cleanUpCallers(this.throttleConfiguration.getCallerConfiguration(key), this, time);
                        }
                    }
                    if (!(o instanceof LinkedList)) continue;
                    LinkedList callers = (LinkedList)o;
                    for (CallerContext c2 : callers) {
                        String key2 = c2.getID();
                        if (key2 == null) continue;
                        if (this.configctx != null && this.keyPrefix != null) {
                            c2 = (CallerContext)this.configctx.getPropertyNonReplicable(this.keyPrefix + key2);
                        }
                        if (c2 == null) continue;
                        c2.cleanUpCallers(this.throttleConfiguration.getCallerConfiguration(key2), this, time);
                    }
                }
            }
            this.nextCleanTime = time + 300000L;
        }
    }

    public void setThrottleId(String throttleId) {
        if (throttleId == null) {
            throw new IllegalArgumentException("The throttle id cannot be null");
        }
        this.throttleId = throttleId;
        this.keyPrefix = "throttle_" + throttleId;
    }

    public String getThrottleId() {
        return this.throttleId;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configctx;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configctx = configurationContext;
    }

    public abstract int getType();

    public void addAndFlushCallerContext(CallerContext callerContext, String id) {
        if (callerContext != null && id != null) {
            this.addCaller(callerContext, id);
            this.replicateCaller(id);
        }
    }

    public void flushCallerContext(CallerContext callerContext, String id) {
        if (this.configctx != null && callerContext != null && id != null) {
            String key = this.keyPrefix + id;
            this.configctx.setProperty(key, (Object)callerContext);
            this.replicateCaller(id);
        }
    }

    public void removeAndFlushCaller(String id) {
        if (id != null) {
            this.removeCaller(id);
            this.replicateCaller(id);
        }
    }

    private void replicateCaller(String id) {
        if (this.configctx != null && this.keyPrefix != null) {
            try {
                if (this.debugOn) {
                    log.debug((Object)("Going to replicate the states of the caller : " + id));
                }
                Replicator.replicate((AbstractContext)this.configctx, (String[])new String[]{this.keyPrefix + id});
            }
            catch (ClusteringFault clusteringFault) {
                log.error((Object)"Error during the replicating states ", (Throwable)clusteringFault);
            }
        }
    }
}

