/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.security.oauth;

import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.wso2.carbon.apimgt.handlers.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.handlers.security.APIKeyValidator;
import org.wso2.carbon.apimgt.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.handlers.security.Authenticator;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;

public class OAuthAuthenticator
implements Authenticator {
    protected APIKeyValidator keyValidator;
    private String securityHeader = "Authorization";
    private String consumerKeyHeaderSegment = "Bearer";
    private String oauthHeaderSplitter = ",";
    private String consumerKeySegmentDelimiter = " ";

    public void init(SynapseEnvironment env) {
        this.keyValidator = new APIKeyValidator(env.getSynapseConfiguration().getAxisConfiguration());
        this.initOAuthParams();
    }

    public void destroy() {
        this.keyValidator.cleanup();
    }

    public boolean authenticate(MessageContext synCtx) throws APISecurityException {
        Map headers = (Map)((Axis2MessageContext)synCtx).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
        String apiKey = null;
        if (headers != null) {
            apiKey = this.extractCustomerKeyFromAuthHeader(headers);
        }
        String apiContext = (String)synCtx.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)synCtx.getProperty("SYNAPSE_REST_API_VERSION");
        if (apiKey == null || apiContext == null || apiVersion == null) {
            throw new APISecurityException(900902, "Required OAuth credentials not provided");
        }
        APIKeyValidationInfoDTO info = this.keyValidator.getKeyValidationInfo(apiContext, apiKey, apiVersion);
        if (info.isAuthorized()) {
            AuthenticationContext authContext = new AuthenticationContext();
            authContext.setAuthenticated(true);
            authContext.setTier(info.getTier());
            authContext.setApiKey(apiKey);
            authContext.setKeyType(info.getType());
            authContext.setUsername(info.getUsername());
            APISecurityUtils.setAuthenticationContext(synCtx, authContext);
            return true;
        }
        throw new APISecurityException(900901, "Authentication failure for API: " + apiContext + ", version: " + apiVersion + " with key: " + apiKey);
    }

    public String extractCustomerKeyFromAuthHeader(Map headersMap) {
        String[] headers;
        String authHeader = (String)headersMap.remove(this.securityHeader);
        if (authHeader == null) {
            return null;
        }
        if (authHeader.startsWith("OAuth ") || authHeader.startsWith("oauth ")) {
            authHeader = authHeader.substring(authHeader.indexOf("o"));
        }
        if ((headers = authHeader.split(this.oauthHeaderSplitter)) != null) {
            for (int i = 0; i < headers.length; ++i) {
                String[] elements = headers[i].split(this.consumerKeySegmentDelimiter);
                if (elements == null || elements.length <= 1) continue;
                int j = 0;
                for (String element : elements) {
                    if (!"".equals(element.trim()) && this.consumerKeyHeaderSegment.equals(elements[j].trim())) {
                        return this.removeLeadingAndTrailing(elements[j + 1].trim());
                    }
                    ++j;
                }
            }
        }
        return null;
    }

    private String removeLeadingAndTrailing(String base) {
        String result = base;
        if (base.startsWith("\"") || base.endsWith("\"")) {
            result = base.replace("\"", "");
        }
        return result.trim();
    }

    protected void initOAuthParams() {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
        String value = config.getFirstProperty("APIConsumerAuthentication.OAuthHeader");
        if (value != null) {
            this.securityHeader = value;
        }
        if ((value = config.getFirstProperty("APIConsumerAuthentication.KeyHeaderSegment")) != null) {
            this.consumerKeyHeaderSegment = value;
        }
        if ((value = config.getFirstProperty("APIConsumerAuthentication.OAuthHeaderSplitter")) != null) {
            this.oauthHeaderSplitter = value;
        }
        if ((value = config.getFirstProperty("APIConsumerAuthentication.KeySegmentDelimiter")) != null) {
            this.consumerKeySegmentDelimiter = value;
        }
    }

    public String getChallengeString() {
        return "OAuth2 realm=\"WSO2 API Manager\"";
    }
}

