/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.security.keys;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.wso2.carbon.apimgt.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.handlers.security.keys.APIKeyDataStore;
import org.wso2.carbon.apimgt.handlers.security.keys.APIKeyValidatorClient;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;

public class WSAPIKeyDataStore
implements APIKeyDataStore {
    private ObjectPool clientPool = new StackObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

        public Object makeObject() throws Exception {
            return new APIKeyValidatorClient();
        }
    });

    public APIKeyValidationInfoDTO getAPIKeyData(String context, String apiVersion, String apiKey) throws APISecurityException {
        APIKeyValidatorClient client = null;
        try {
            client = (APIKeyValidatorClient)this.clientPool.borrowObject();
            APIKeyValidationInfoDTO aPIKeyValidationInfoDTO = client.getAPIKeyData(context, apiVersion, apiKey);
            return aPIKeyValidationInfoDTO;
        }
        catch (Exception e) {
            throw new APISecurityException(900900, "Error while accessing backend services for API key validation", e);
        }
        finally {
            try {
                if (client != null) {
                    this.clientPool.returnObject((Object)client);
                }
            }
            catch (Exception ignored) {}
        }
    }

    public void cleanup() {
        try {
            this.clientPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

