/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.security.keys;

import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.handlers.security.keys.APIKeyDataStore;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;

public class JDBCAPIKeyDataStore
implements APIKeyDataStore {
    private ApiMgtDAO dao;

    public JDBCAPIKeyDataStore() throws APISecurityException {
        try {
            this.dao = new ApiMgtDAO();
        }
        catch (APIManagementException e) {
            throw new APISecurityException(900900, "Error while connecting to the API manager database", e);
        }
    }

    public APIKeyValidationInfoDTO getAPIKeyData(String context, String apiVersion, String apiKey) throws APISecurityException {
        try {
            return this.dao.validateKey(context, apiVersion, apiKey);
        }
        catch (APIManagementException e) {
            throw new APISecurityException(900900, "Error while looking up API key data in the database", e);
        }
    }

    public void cleanup() {
    }
}

