/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.security.keys;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.apimgt.handlers.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.dto.xsd.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.keymgt.stub.validator.APIKeyValidationServiceStub;
import org.wso2.carbon.utils.CarbonUtils;

public class APIKeyValidatorClient {
    private static final int TIMEOUT_IN_MILLIS = 900000;
    private APIKeyValidationServiceStub clientStub;
    private String username;
    private String password;
    private String cookie;

    public APIKeyValidatorClient() throws APISecurityException {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
        String serviceURL = config.getFirstProperty("APIKeyManager.ServerURL");
        this.username = config.getFirstProperty("APIKeyManager.Username");
        this.password = config.getFirstProperty("APIKeyManager.Password");
        if (serviceURL == null || this.username == null || this.password == null) {
            throw new APISecurityException(900900, "Required connection details for the key management server not provided");
        }
        try {
            this.clientStub = new APIKeyValidationServiceStub(null, serviceURL + "APIKeyValidationService");
            ServiceClient client = this.clientStub._getServiceClient();
            Options options = client.getOptions();
            options.setTimeOutInMilliSeconds(900000L);
            options.setProperty("SO_TIMEOUT", (Object)900000);
            options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
            options.setCallTransportCleanup(true);
            options.setManageSession(true);
        }
        catch (AxisFault axisFault) {
            throw new APISecurityException(900900, "Error while initializing the API key validation stub", axisFault);
        }
    }

    public org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO getAPIKeyData(String context, String apiVersion, String apiKey) throws APISecurityException {
        CarbonUtils.setBasicAccessSecurityHeaders((String)this.username, (String)this.password, (boolean)true, (ServiceClient)this.clientStub._getServiceClient());
        if (this.cookie != null) {
            this.clientStub._getServiceClient().getOptions().setProperty("Cookie", (Object)this.cookie);
        }
        try {
            APIKeyValidationInfoDTO dto = this.clientStub.validateKey(context, apiVersion, apiKey);
            ServiceContext serviceContext = this.clientStub._getServiceClient().getLastOperationContext().getServiceContext();
            this.cookie = (String)serviceContext.getProperty("Cookie");
            return this.toDTO(dto);
        }
        catch (Exception e) {
            throw new APISecurityException(900900, "Error while accessing backend services for API key validation", e);
        }
    }

    private org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO toDTO(APIKeyValidationInfoDTO generatedDto) {
        org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO dto = new org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO();
        dto.setUsername(generatedDto.getUsername());
        dto.setAuthorized(generatedDto.getAuthorized());
        dto.setTier(generatedDto.getTier());
        dto.setType(generatedDto.getType());
        return dto;
    }
}

