/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.apimgt.handlers.security.APIKeyCache;

public class APIKeyCacheFactory {
    private static final APIKeyCacheFactory instance = new APIKeyCacheFactory();
    private Map<String, APIKeyCache> cacheMap = new ConcurrentHashMap<String, APIKeyCache>();

    private APIKeyCacheFactory() {
    }

    public static APIKeyCacheFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIKeyCache getAPIKeyCache(String context, String version) {
        String identifier = context + ":" + version;
        APIKeyCache cache = this.cacheMap.get(identifier);
        if (cache == null) {
            APIKeyCacheFactory aPIKeyCacheFactory = this;
            synchronized (aPIKeyCacheFactory) {
                cache = this.cacheMap.get(identifier);
                if (cache == null) {
                    cache = new APIKeyCache(250, 100);
                    this.cacheMap.put(identifier, cache);
                }
            }
        }
        return cache;
    }

    public APIKeyCache getExistingAPIKeyCache(String context, String version) {
        String identifier = context + ":" + version;
        return this.cacheMap.get(identifier);
    }

    void reset() {
        this.cacheMap.clear();
    }
}

