/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.handlers.security;

import java.util.Map;
import org.wso2.carbon.apimgt.impl.dto.APIKeyValidationInfoDTO;
import org.wso2.carbon.apimgt.impl.utils.LRUCache;

public class APIKeyCache {
    private Map<String, APIKeyValidationInfoDTO> validKeys;
    private Map<String, APIKeyValidationInfoDTO> invalidKeys;

    APIKeyCache(int maxValidKeys, int maxInvalidKeys) {
        this.validKeys = new LRUCache(maxValidKeys);
        this.invalidKeys = new LRUCache(maxInvalidKeys);
    }

    public void addValidKey(String key, APIKeyValidationInfoDTO info) {
        this.validKeys.put(key, info);
    }

    public void addInvalidKey(String key, APIKeyValidationInfoDTO info) {
        this.invalidKeys.put(key, info);
    }

    public APIKeyValidationInfoDTO getInfo(String key) {
        APIKeyValidationInfoDTO info = this.validKeys.get(key);
        if (info == null) {
            info = this.invalidKeys.get(key);
        }
        return info;
    }

    public void invalidateEntry(String key) {
        this.validKeys.remove(key);
        this.invalidKeys.remove(key);
    }

    public void invalidateCache() {
        this.validKeys.clear();
        this.invalidKeys.clear();
    }
}

