/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.keymgt.util;

import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.keymgt.APIKeyMgtException;
import org.wso2.carbon.apimgt.keymgt.util.APIKeyMgtDataHolder;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class APIKeyMgtUtil {
    private static final Log log = LogFactory.getLog(APIKeyMgtUtil.class);

    public static String getTenantDomainFromTenantId(int tenantId) throws APIKeyMgtException {
        try {
            TenantManager tenantManager = APIKeyMgtDataHolder.getRealmService().getTenantManager();
            return tenantManager.getDomain(tenantId);
        }
        catch (UserStoreException e) {
            String errorMsg = "Error when getting the Tenant domain name for the given Tenant Id";
            log.error((Object)errorMsg, (Throwable)e);
            throw new APIKeyMgtException(errorMsg, e);
        }
    }

    public static Connection getDBConnection() throws APIKeyMgtException {
        try {
            return IdentityDatabaseUtil.getDBConnection();
        }
        catch (IdentityException e) {
            String errMsg = "Error when getting a database connection from the Identity Persistence Manager";
            log.error((Object)errMsg, (Throwable)e);
            throw new APIKeyMgtException(errMsg, e);
        }
    }
}

