/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.keymgt.service;

import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.dao.ApiMgtDAO;
import org.wso2.carbon.apimgt.impl.dto.APIInfoDTO;
import org.wso2.carbon.apimgt.keymgt.APIKeyMgtException;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class APIKeyMgtSubscriberService
extends AbstractAdmin {
    public String getAccessToken(String userId, APIInfoDTO apiInfoDTO, String applicationName, String tokenType) throws APIKeyMgtException, APIManagementException, IdentityException {
        ApiMgtDAO apiMgtDAO = new ApiMgtDAO();
        String accessToken = apiMgtDAO.getAccessKeyForAPI(userId, applicationName, apiInfoDTO, tokenType);
        if (accessToken == null) {
            String tenantAwareUserId = MultitenantUtils.getTenantAwareUsername((String)userId);
            int tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
            String[] credentials = apiMgtDAO.addOAuthConsumer(tenantAwareUserId, tenantId);
            accessToken = apiMgtDAO.registerAccessToken(credentials[0], applicationName, tenantAwareUserId, tenantId, apiInfoDTO, tokenType);
        }
        return accessToken;
    }

    public String getApplicationAccessToken(String userId, String applicationName, String tokenType) throws APIKeyMgtException, APIManagementException, IdentityException {
        ApiMgtDAO apiMgtDAO = new ApiMgtDAO();
        String accessToken = apiMgtDAO.getAccessKeyForApplication(userId, applicationName, tokenType);
        if (accessToken == null) {
            String tenantAwareUserId = MultitenantUtils.getTenantAwareUsername((String)userId);
            int tenantId = IdentityUtil.getTenantIdOFUser((String)userId);
            String[] credentials = apiMgtDAO.addOAuthConsumer(tenantAwareUserId, tenantId);
            accessToken = apiMgtDAO.registerApplicationAccessToken(credentials[0], applicationName, tenantAwareUserId, tenantId, tokenType);
        }
        return accessToken;
    }

    public APIInfoDTO[] getSubscribedAPIsOfUser(String userId) throws APIKeyMgtException, APIManagementException, IdentityException {
        ApiMgtDAO ApiMgtDAO2 = new ApiMgtDAO();
        return ApiMgtDAO2.getSubscribedAPIsOfUser(userId);
    }

    public String renewAccessToken(String userId, APIInfoDTO apiInfoDTO) {
        return null;
    }

    public void unsubscribeFromAPI(String userId, APIInfoDTO apiInfoDTO) {
    }
}

