/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.usage.client;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.usage.client.dto.APIResponseTimeDTO;
import org.wso2.carbon.apimgt.usage.client.dto.APIUsageDTO;
import org.wso2.carbon.apimgt.usage.client.dto.APIVersionLastAccessTimeDTO;
import org.wso2.carbon.apimgt.usage.client.dto.APIVersionUsageDTO;
import org.wso2.carbon.apimgt.usage.client.dto.PerUserAPIUsageDTO;
import org.wso2.carbon.apimgt.usage.client.exception.APIMgtUsageQueryServiceClientException;
import org.wso2.carbon.apimgt.usage.client.internal.APIUsageClientServiceComponent;
import org.wso2.carbon.bam.presentation.stub.QueryServiceStub;

public class APIUsageStatisticsClient {
    private QueryServiceStub qss;
    Connection connection;
    private APIProvider apiProviderImpl;
    private String jdbcDriver;
    private String jdbcURL;
    private String jdbcUserName;
    private String jdbcPassword;

    public APIUsageStatisticsClient(String username) throws APIMgtUsageQueryServiceClientException {
        APIManagerConfiguration config = APIUsageClientServiceComponent.getAPIManagerConfiguration();
        String targetEndpoint = config.getFirstProperty("APIUsageTracking.BAMServerURL");
        this.jdbcDriver = config.getFirstProperty("APIUsageTracking.JDBCDriver");
        this.jdbcURL = config.getFirstProperty("APIUsageTracking.JDBCUrl");
        this.jdbcUserName = config.getFirstProperty("APIUsageTracking.JDBCUserName");
        this.jdbcPassword = config.getFirstProperty("APIUsageTracking.JDBCPassword");
        if (targetEndpoint == null || targetEndpoint.equals("")) {
            throw new APIMgtUsageQueryServiceClientException("Required BAM server URL parameter unspecified");
        }
        try {
            this.qss = new QueryServiceStub(targetEndpoint + "services/QueryService");
            this.apiProviderImpl = APIManagerFactory.getInstance().getAPIProvider(username);
        }
        catch (AxisFault e) {
            throw new APIMgtUsageQueryServiceClientException("Error while instantiating QueryServiceStub", e);
        }
        catch (APIManagementException e) {
            throw new APIMgtUsageQueryServiceClientException("Exception while instantiating API manager core objects", e);
        }
        try {
            Class.forName(this.jdbcDriver);
            this.connection = DriverManager.getConnection(this.jdbcURL, this.jdbcUserName, this.jdbcPassword);
        }
        catch (SQLException e) {
            throw new APIMgtUsageQueryServiceClientException("Error while creating JDBC connection", e);
        }
        catch (ClassNotFoundException e) {
            throw new APIMgtUsageQueryServiceClientException("JDBC Driver class not found", e);
        }
    }

    public List<APIUsageDTO> getUsageByAPIs(String providerName) throws APIMgtUsageQueryServiceClientException {
        OMElement omElement = this.queryColumnFamily("APIVersionUsageSummaryTable", "APIVersionUsageSummaryTableIndex", null);
        Collection<APIUsage> usageData = this.getUsageData(omElement);
        List<API> providerAPIs = this.getAPIsByProvider(providerName);
        TreeMap<String, APIUsageDTO> usageByAPIs = new TreeMap<String, APIUsageDTO>();
        for (APIUsage usage : usageData) {
            for (API providerAPI : providerAPIs) {
                if (!providerAPI.getId().getApiName().equals(usage.apiName) || !providerAPI.getId().getVersion().equals(usage.apiVersion) || !providerAPI.getContext().equals(usage.context)) continue;
                String apiName = usage.apiName + " (" + providerAPI.getId().getProviderName() + ")";
                APIUsageDTO usageDTO = (APIUsageDTO)usageByAPIs.get(apiName);
                if (usageDTO != null) {
                    usageDTO.setCount(usageDTO.getCount() + usage.requestCount);
                    continue;
                }
                usageDTO = new APIUsageDTO();
                usageDTO.setApiName(apiName);
                usageDTO.setCount(usage.requestCount);
                usageByAPIs.put(apiName, usageDTO);
            }
        }
        return new ArrayList<APIUsageDTO>(usageByAPIs.values());
    }

    public List<APIVersionUsageDTO> getUsageByAPIVersions(String providerName, String apiName) throws APIMgtUsageQueryServiceClientException {
        QueryServiceStub.CompositeIndex[] compositeIndex = new QueryServiceStub.CompositeIndex[]{new QueryServiceStub.CompositeIndex()};
        compositeIndex[0].setIndexName("api");
        compositeIndex[0].setRangeFirst(apiName);
        compositeIndex[0].setRangeLast(this.getNextStringInLexicalOrder(apiName));
        OMElement omElement = this.queryColumnFamily("APIVersionUsageSummaryTable", "APIVersionUsageSummaryTableIndex", compositeIndex);
        Collection<APIUsage> usageData = this.getUsageData(omElement);
        List<API> providerAPIs = this.getAPIsByProvider(providerName);
        TreeMap<String, APIVersionUsageDTO> usageByVersions = new TreeMap<String, APIVersionUsageDTO>();
        for (APIUsage usage : usageData) {
            for (API providerAPI : providerAPIs) {
                if (!providerAPI.getId().getApiName().equals(usage.apiName) || !providerAPI.getId().getVersion().equals(usage.apiVersion) || !providerAPI.getContext().equals(usage.context)) continue;
                APIVersionUsageDTO usageDTO = new APIVersionUsageDTO();
                usageDTO.setVersion(usage.apiVersion);
                usageDTO.setCount(usage.requestCount);
                usageByVersions.put(usage.apiVersion, usageDTO);
            }
        }
        return new ArrayList<APIVersionUsageDTO>(usageByVersions.values());
    }

    public List<APIResponseTimeDTO> getResponseTimesByAPIs(String providerName) throws APIMgtUsageQueryServiceClientException {
        OMElement omElement = this.queryColumnFamily("APIVersionServiceTimeSummaryTable", "APIVersionServiceTimeSummaryTableIndex", null);
        Collection<APIResponseTime> responseTimes = this.getResponseTimeData(omElement);
        List<API> providerAPIs = this.getAPIsByProvider(providerName);
        HashMap<String, Double> apiCumulativeServiceTimeMap = new HashMap<String, Double>();
        TreeMap<String, Long> apiUsageMap = new TreeMap<String, Long>();
        for (APIResponseTime responseTime : responseTimes) {
            for (API providerAPI : providerAPIs) {
                if (!providerAPI.getId().getApiName().equals(responseTime.apiName) || !providerAPI.getId().getVersion().equals(responseTime.apiVersion) || !providerAPI.getContext().equals(responseTime.context)) continue;
                Double cumulativeResponseTime = (Double)apiCumulativeServiceTimeMap.get(responseTime.apiName);
                String apiName = responseTime.apiName + " (" + providerAPI.getId().getProviderName() + ")";
                if (cumulativeResponseTime != null) {
                    apiCumulativeServiceTimeMap.put(apiName, cumulativeResponseTime + responseTime.responseTime * (double)responseTime.responseCount);
                    apiUsageMap.put(apiName, (Long)apiUsageMap.get(apiName) + responseTime.responseCount);
                    continue;
                }
                apiCumulativeServiceTimeMap.put(apiName, responseTime.responseTime * (double)responseTime.responseCount);
                apiUsageMap.put(apiName, responseTime.responseCount);
            }
        }
        ArrayList<APIResponseTimeDTO> result = new ArrayList<APIResponseTimeDTO>();
        DecimalFormat format = new DecimalFormat("#.##");
        for (String key : apiUsageMap.keySet()) {
            APIResponseTimeDTO responseTimeDTO = new APIResponseTimeDTO();
            responseTimeDTO.setApiName(key);
            double responseTime = (Double)apiCumulativeServiceTimeMap.get(key) / (double)((Long)apiUsageMap.get(key)).longValue();
            responseTimeDTO.setServiceTime(Double.parseDouble(format.format(responseTime)));
            result.add(responseTimeDTO);
        }
        return result;
    }

    public List<APIVersionLastAccessTimeDTO> getLastAccessTimesByAPI(String providerName) throws APIMgtUsageQueryServiceClientException {
        APIAccessTime lastAccessTime;
        OMElement omElement = this.queryColumnFamily("APIVersionKeyLastAccessSummaryTable", "APIVersionKeyLastAccessSummaryTableIndex", null);
        Collection<APIAccessTime> accessTimes = this.getAccessTimeData(omElement);
        List<API> providerAPIs = this.getAPIsByProvider(providerName);
        TreeMap<String, APIAccessTime> lastAccessTimes = new TreeMap<String, APIAccessTime>();
        block0: for (APIAccessTime accessTime : accessTimes) {
            for (API aPI : providerAPIs) {
                String apiName;
                if (!aPI.getId().getApiName().equals(accessTime.apiName) || !aPI.getId().getVersion().equals(accessTime.apiVersion) || !aPI.getContext().equals(accessTime.context) || (lastAccessTime = (APIAccessTime)lastAccessTimes.get(apiName = accessTime.apiName + " (" + aPI.getId().getProviderName() + ")")) != null && !(lastAccessTime.accessTime < accessTime.accessTime)) continue;
                lastAccessTimes.put(apiName, accessTime);
                continue block0;
            }
        }
        ArrayList<APIVersionLastAccessTimeDTO> accessTimeDTOs = new ArrayList<APIVersionLastAccessTimeDTO>();
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        for (Map.Entry entry : lastAccessTimes.entrySet()) {
            APIVersionLastAccessTimeDTO accessTimeDTO = new APIVersionLastAccessTimeDTO();
            accessTimeDTO.setApiName((String)entry.getKey());
            lastAccessTime = (APIAccessTime)entry.getValue();
            accessTimeDTO.setApiVersion(lastAccessTime.apiVersion);
            accessTimeDTO.setLastAccessTime(dateFormat.format(lastAccessTime.accessTime));
            accessTimeDTO.setUser(lastAccessTime.username);
            accessTimeDTOs.add(accessTimeDTO);
        }
        return accessTimeDTOs;
    }

    public List<PerUserAPIUsageDTO> getUsageBySubscribers(String providerName, String apiName, int limit) throws APIMgtUsageQueryServiceClientException {
        OMElement omElement = this.queryColumnFamily("KeyUsageSummaryTable", "KeyUsageSummaryTableIndex", null);
        Collection<APIUsageByUser> usageData = this.getUsageBySubscriber(omElement);
        TreeMap<String, PerUserAPIUsageDTO> usageByUsername = new TreeMap<String, PerUserAPIUsageDTO>();
        List<API> apiList = this.getAPIsByProvider(providerName);
        block0: for (APIUsageByUser usageEntry : usageData) {
            for (API api : apiList) {
                if (!api.getContext().equals(usageEntry.context) || !api.getId().getApiName().equals(apiName)) continue;
                PerUserAPIUsageDTO usageDTO = (PerUserAPIUsageDTO)usageByUsername.get(usageEntry.username);
                if (usageDTO != null) {
                    usageDTO.setCount(usageDTO.getCount() + usageEntry.requestCount);
                    continue block0;
                }
                usageDTO = new PerUserAPIUsageDTO();
                usageDTO.setUsername(usageEntry.username);
                usageDTO.setCount(usageEntry.requestCount);
                usageByUsername.put(usageEntry.username, usageDTO);
                continue block0;
            }
        }
        return this.getTopEntries(new ArrayList<PerUserAPIUsageDTO>(usageByUsername.values()), limit);
    }

    public List<PerUserAPIUsageDTO> getUsageBySubscribers(String providerName, String apiName, String apiVersion, int limit) throws APIMgtUsageQueryServiceClientException {
        OMElement omElement = this.queryColumnFamily("KeyUsageSummaryTable", "KeyUsageSummaryTableIndex", null);
        Collection<APIUsageByUser> usageData = this.getUsageBySubscriber(omElement);
        TreeMap<String, PerUserAPIUsageDTO> usageByUsername = new TreeMap<String, PerUserAPIUsageDTO>();
        List<API> apiList = this.getAPIsByProvider(providerName);
        block0: for (APIUsageByUser usageEntry : usageData) {
            for (API api : apiList) {
                if (!api.getContext().equals(usageEntry.context) || !api.getId().getApiName().equals(apiName) || !api.getId().getVersion().equals(apiVersion) || !apiVersion.equals(usageEntry.apiVersion)) continue;
                PerUserAPIUsageDTO usageDTO = (PerUserAPIUsageDTO)usageByUsername.get(usageEntry.username);
                if (usageDTO != null) {
                    usageDTO.setCount(usageDTO.getCount() + usageEntry.requestCount);
                    continue block0;
                }
                usageDTO = new PerUserAPIUsageDTO();
                usageDTO.setUsername(usageEntry.username);
                usageDTO.setCount(usageEntry.requestCount);
                usageByUsername.put(usageEntry.username, usageDTO);
                continue block0;
            }
        }
        return this.getTopEntries(new ArrayList<PerUserAPIUsageDTO>(usageByUsername.values()), limit);
    }

    private List<PerUserAPIUsageDTO> getTopEntries(List<PerUserAPIUsageDTO> usageData, int limit) {
        Collections.sort(usageData, new Comparator<PerUserAPIUsageDTO>(){

            @Override
            public int compare(PerUserAPIUsageDTO o1, PerUserAPIUsageDTO o2) {
                return (int)(o2.getCount() - o1.getCount());
            }
        });
        if (usageData.size() > limit) {
            int i;
            PerUserAPIUsageDTO other = new PerUserAPIUsageDTO();
            other.setUsername("[Other]");
            for (i = limit; i < usageData.size(); ++i) {
                other.setCount(other.getCount() + usageData.get(i).getCount());
            }
            for (i = limit; i < usageData.size(); ++i) {
                usageData.remove(i);
            }
            usageData.add(other);
        }
        return usageData;
    }

    private String getNextStringInLexicalOrder(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        byte[] bytes = str.getBytes();
        byte last = bytes[bytes.length - 1];
        bytes[bytes.length - 1] = last = (byte)(last + 1);
        return new String(bytes);
    }

    private OMElement queryColumnFamily(String columnFamily, String index, QueryServiceStub.CompositeIndex[] compositeIndex) throws APIMgtUsageQueryServiceClientException {
        OMElement returnElement = null;
        String selectRowsByColumnName = null;
        String selectRowsByColumnValue = null;
        if (compositeIndex != null) {
            selectRowsByColumnName = compositeIndex[0].getIndexName();
            selectRowsByColumnValue = compositeIndex[0].getRangeFirst();
        }
        try {
            Statement statement = this.connection.createStatement();
            String query = selectRowsByColumnName != null ? "SELECT * FROM  " + columnFamily + " WHERE " + selectRowsByColumnName + "='" + selectRowsByColumnValue + "'" : "SELECT * FROM  " + columnFamily;
            ResultSet rs = statement.executeQuery(query);
            StringBuilder returnStringBuilder = new StringBuilder("<omElement><rows>");
            int columnCount = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                returnStringBuilder.append("<row>");
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = rs.getMetaData().getColumnName(i);
                    String columnValue = rs.getString(columnName);
                    returnStringBuilder.append("<" + columnName + ">" + columnValue + "</" + columnName + ">");
                }
                returnStringBuilder.append("</row>");
            }
            returnStringBuilder.append("</rows></omElement>");
            String returnString = returnStringBuilder.toString();
            returnElement = AXIOMUtil.stringToOM((String)returnString);
        }
        catch (Exception e) {
            throw new APIMgtUsageQueryServiceClientException("Error occurred while querying from JDBC database", e);
        }
        return returnElement;
    }

    private List<API> getAPIsByProvider(String providerId) throws APIMgtUsageQueryServiceClientException {
        try {
            if ("__all_providers__".equals(providerId)) {
                return this.apiProviderImpl.getAllAPIs();
            }
            return this.apiProviderImpl.getAPIsByProvider(providerId);
        }
        catch (APIManagementException e) {
            throw new APIMgtUsageQueryServiceClientException("Error while retrieving APIs by " + providerId, e);
        }
    }

    private Collection<APIUsage> getUsageData(OMElement data) {
        ArrayList<APIUsage> usageData = new ArrayList<APIUsage>();
        OMElement rowsElement = data.getFirstChildWithName(new QName("rows"));
        Iterator rowIterator = rowsElement.getChildrenWithName(new QName("row"));
        if (rowIterator != null) {
            while (rowIterator.hasNext()) {
                OMElement rowElement = (OMElement)rowIterator.next();
                usageData.add(new APIUsage(rowElement));
            }
        }
        return usageData;
    }

    private Collection<APIResponseTime> getResponseTimeData(OMElement data) {
        ArrayList<APIResponseTime> responseTimeData = new ArrayList<APIResponseTime>();
        OMElement rowsElement = data.getFirstChildWithName(new QName("rows"));
        Iterator rowIterator = rowsElement.getChildrenWithName(new QName("row"));
        if (rowIterator != null) {
            while (rowIterator.hasNext()) {
                OMElement rowElement = (OMElement)rowIterator.next();
                if (rowElement.getFirstChildWithName(new QName("SERVICETIME")) == null) continue;
                responseTimeData.add(new APIResponseTime(rowElement));
            }
        }
        return responseTimeData;
    }

    private Collection<APIAccessTime> getAccessTimeData(OMElement data) {
        ArrayList<APIAccessTime> accessTimeData = new ArrayList<APIAccessTime>();
        OMElement rowsElement = data.getFirstChildWithName(new QName("rows"));
        Iterator rowIterator = rowsElement.getChildrenWithName(new QName("row"));
        if (rowIterator != null) {
            while (rowIterator.hasNext()) {
                OMElement rowElement = (OMElement)rowIterator.next();
                accessTimeData.add(new APIAccessTime(rowElement));
            }
        }
        return accessTimeData;
    }

    private Collection<APIUsageByUser> getUsageBySubscriber(OMElement data) {
        ArrayList<APIUsageByUser> usageData = new ArrayList<APIUsageByUser>();
        OMElement rowsElement = data.getFirstChildWithName(new QName("rows"));
        Iterator rowIterator = rowsElement.getChildrenWithName(new QName("row"));
        if (rowIterator != null) {
            while (rowIterator.hasNext()) {
                OMElement rowElement = (OMElement)rowIterator.next();
                usageData.add(new APIUsageByUser(rowElement));
            }
        }
        return usageData;
    }

    private static class APIAccessTime {
        private String apiName;
        private String apiVersion;
        private String context;
        private double accessTime;
        private String username;

        public APIAccessTime(OMElement row) {
            String nameVersion = row.getFirstChildWithName(new QName("API_VERSION")).getText();
            int index = nameVersion.lastIndexOf(":v");
            this.apiName = nameVersion.substring(0, index);
            this.apiVersion = nameVersion.substring(index + 2);
            this.context = row.getFirstChildWithName(new QName("CONTEXT")).getText();
            this.accessTime = Double.parseDouble(row.getFirstChildWithName(new QName("REQUESTTIME")).getText());
            this.username = row.getFirstChildWithName(new QName("USERID")).getText();
        }
    }

    private static class APIResponseTime {
        private String apiName;
        private String apiVersion;
        private String context;
        private double responseTime;
        private long responseCount;

        public APIResponseTime(OMElement row) {
            String nameVersion = row.getFirstChildWithName(new QName("API_VERSION")).getText();
            int index = nameVersion.lastIndexOf(":v");
            this.apiName = nameVersion.substring(0, index);
            this.apiVersion = nameVersion.substring(index + 2);
            this.context = row.getFirstChildWithName(new QName("CONTEXT")).getText();
            this.responseTime = Double.parseDouble(row.getFirstChildWithName(new QName("SERVICETIME")).getText());
            this.responseCount = (long)Double.parseDouble(row.getFirstChildWithName(new QName("RESPONSE")).getText());
        }
    }

    private static class APIUsageByUser {
        private String context;
        private String username;
        private long requestCount;
        private String apiVersion;

        public APIUsageByUser(OMElement row) {
            this.context = row.getFirstChildWithName(new QName("CONTEXT")).getText();
            this.username = row.getFirstChildWithName(new QName("USERID")).getText();
            this.requestCount = (long)Double.parseDouble(row.getFirstChildWithName(new QName("REQUEST")).getText());
            this.apiVersion = row.getFirstChildWithName(new QName("VERSION")).getText();
        }
    }

    private static class APIUsage {
        private String apiName;
        private String apiVersion;
        private String context;
        private long requestCount;

        public APIUsage(OMElement row) {
            this.apiName = row.getFirstChildWithName(new QName("API")).getText();
            this.apiVersion = row.getFirstChildWithName(new QName("VERSION")).getText();
            this.context = row.getFirstChildWithName(new QName("CONTEXT")).getText();
            this.requestCount = (long)Double.parseDouble(row.getFirstChildWithName(new QName("REQUEST")).getText());
        }
    }
}

