/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.usage.publisher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.AbstractHandler;
import org.wso2.carbon.apimgt.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.usage.publisher.APIMgtUsageDataPublisher;
import org.wso2.carbon.apimgt.usage.publisher.dto.RequestPublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.dto.ResponsePublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.internal.UsageComponent;

public class APIMgtUsageHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(APIMgtUsageHandler.class);
    private volatile APIMgtUsageDataPublisher publisher;
    private boolean enabled = UsageComponent.getApiMgtConfigReaderService().isEnabled();
    private String publisherClass = UsageComponent.getApiMgtConfigReaderService().getPublisherClass();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest(MessageContext mc) {
        String api;
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (!this.enabled) {
            return true;
        }
        if (this.publisher == null) {
            APIMgtUsageHandler aPIMgtUsageHandler = this;
            synchronized (aPIMgtUsageHandler) {
                if (this.publisher == null) {
                    try {
                        log.debug((Object)"Instantiating Data Publisher");
                        this.publisher = (APIMgtUsageDataPublisher)Class.forName(this.publisherClass).newInstance();
                        this.publisher.init();
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)("Class not found " + this.publisherClass));
                    }
                    catch (InstantiationException e) {
                        log.error((Object)("Error instantiating " + this.publisherClass));
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)("Illegal access to " + this.publisherClass));
                    }
                }
            }
        }
        AuthenticationContext authContext = APISecurityUtils.getAuthenticationContext((MessageContext)mc);
        String consumerKey = "";
        String username = "";
        if (authContext != null) {
            consumerKey = authContext.getApiKey();
            username = authContext.getUsername();
        }
        String context = (String)mc.getProperty("REST_API_CONTEXT");
        String api_version = (String)mc.getProperty("SYNAPSE_REST_API");
        int index = api_version.indexOf("--");
        if (index != -1) {
            api_version = api_version.substring(index + 2);
        }
        if ((index = (api = api_version.split(":")[0]).indexOf("--")) != -1) {
            api = api.substring(index + 2);
        }
        String version = (String)mc.getProperty("SYNAPSE_REST_API_VERSION");
        String resource = this.extractResource(mc);
        String method = (String)((Axis2MessageContext)mc).getAxis2MessageContext().getProperty("HTTP_METHOD");
        RequestPublisherDTO requestPublisherDTO = new RequestPublisherDTO();
        requestPublisherDTO.setConsumerKey(consumerKey);
        requestPublisherDTO.setContext(context);
        requestPublisherDTO.setApi_version(api_version);
        requestPublisherDTO.setApi(api);
        requestPublisherDTO.setVersion(version);
        requestPublisherDTO.setResource(resource);
        requestPublisherDTO.setMethod(method);
        requestPublisherDTO.setRequestTime(currentTime);
        requestPublisherDTO.setUsername(username);
        try {
            this.publisher.publishEvent(requestPublisherDTO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mc.setProperty("api.ut.consumerKey", (Object)consumerKey);
        mc.setProperty("api.ut.userId", (Object)username);
        mc.setProperty("api.ut.context", (Object)context);
        mc.setProperty("api.ut.api_version", (Object)api_version);
        mc.setProperty("api.ut.api", (Object)api);
        mc.setProperty("api.ut.version", (Object)version);
        mc.setProperty("api.ut.resource", (Object)resource);
        mc.setProperty("api.ut.HTTP_METHOD", (Object)method);
        mc.setProperty("api.ut.requestTime", (Object)currentTime);
        return true;
    }

    public boolean handleResponse(MessageContext mc) {
        Long currentTime = System.currentTimeMillis();
        if (!this.enabled) {
            return true;
        }
        Long serviceTime = currentTime - Long.parseLong((String)mc.getProperty("api.ut.requestTime"));
        ResponsePublisherDTO responsePublisherDTO = new ResponsePublisherDTO();
        responsePublisherDTO.setConsumerKey((String)mc.getProperty("api.ut.consumerKey"));
        responsePublisherDTO.setUsername((String)mc.getProperty("api.ut.userId"));
        responsePublisherDTO.setContext((String)mc.getProperty("api.ut.context"));
        responsePublisherDTO.setApi_version((String)mc.getProperty("api.ut.api_version"));
        responsePublisherDTO.setApi((String)mc.getProperty("api.ut.api"));
        responsePublisherDTO.setVersion((String)mc.getProperty("api.ut.version"));
        responsePublisherDTO.setResource((String)mc.getProperty("api.ut.resource"));
        responsePublisherDTO.setMethod((String)mc.getProperty("api.ut.HTTP_METHOD"));
        responsePublisherDTO.setResponseTime(String.valueOf(currentTime));
        responsePublisherDTO.setServiceTime(String.valueOf(serviceTime));
        try {
            this.publisher.publishEvent(responsePublisherDTO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private String extractResource(MessageContext mc) {
        String resource = "/";
        Pattern pattern = Pattern.compile("^/.+?/.+?([/?].+)$");
        Matcher matcher = pattern.matcher((String)mc.getProperty("REST_FULL_REQUEST_PATH"));
        if (matcher.find()) {
            resource = matcher.group(1);
        }
        return resource;
    }
}

