/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.usage.publisher;

import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.usage.publisher.APIMgtUsageDataPublisher;
import org.wso2.carbon.apimgt.usage.publisher.dto.DataBridgeRequestPublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.dto.DataBridgeResponsePublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.dto.RequestPublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.dto.ResponsePublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.internal.UsageComponent;
import org.wso2.carbon.apimgt.usage.publisher.service.APIMGTConfigReaderService;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.DataPublisher;
import org.wso2.carbon.databridge.agent.thrift.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.TransportException;

public class APIMgtUsageDataBridgeDataPublisher
implements APIMgtUsageDataPublisher {
    private static final Log log = LogFactory.getLog(APIMgtUsageDataBridgeDataPublisher.class);
    private DataPublisher dataPublisher;
    private String requestStreamId;
    private String responseStreamId;

    @Override
    public void init() {
        try {
            log.debug((Object)"Initializing APIMgtUsageDataBridgeDataPublisher");
            this.dataPublisher = this.getDataPublisher();
            this.requestStreamId = DataBridgeRequestPublisherDTO.addStreamId(this.dataPublisher);
            this.responseStreamId = DataBridgeResponsePublisherDTO.addStreamId(this.dataPublisher);
        }
        catch (Exception e) {
            log.error((Object)"Error initializing APIMgtUsageDataBridgeDataPublisher", (Throwable)e);
        }
    }

    @Override
    public void publishEvent(RequestPublisherDTO requestPublisherDTO) {
        DataBridgeRequestPublisherDTO dataBridgeRequestPublisherDTO = new DataBridgeRequestPublisherDTO(requestPublisherDTO);
        Event event = new Event(this.requestStreamId, System.currentTimeMillis(), new Object[]{"external"}, null, (Object[])dataBridgeRequestPublisherDTO.createPayload());
        try {
            this.dataPublisher.publish(event);
        }
        catch (AgentException e) {
            log.error((Object)"Error while publishing request event", (Throwable)e);
        }
    }

    @Override
    public void publishEvent(ResponsePublisherDTO responsePublisherDTO) {
        DataBridgeResponsePublisherDTO dataBridgeResponsePublisherDTO = new DataBridgeResponsePublisherDTO(responsePublisherDTO);
        Event event = new Event(this.responseStreamId, System.currentTimeMillis(), new Object[]{"external"}, null, (Object[])dataBridgeResponsePublisherDTO.createPayload());
        try {
            this.dataPublisher.publish(event);
        }
        catch (AgentException e) {
            log.error((Object)"Error while publishing response event", (Throwable)e);
        }
    }

    private DataPublisher getDataPublisher() throws AgentException, MalformedURLException, AuthenticationException, TransportException {
        APIMGTConfigReaderService apimgtConfigReaderService = UsageComponent.getApiMgtConfigReaderService();
        AgentConfiguration agentConfiguration = new AgentConfiguration();
        Agent agent = new Agent(agentConfiguration);
        return new DataPublisher(apimgtConfigReaderService.getBamServerURL(), apimgtConfigReaderService.getBamServerUser(), apimgtConfigReaderService.getBamServerPassword(), agent);
    }
}

