/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.usage.publisher;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.usage.publisher.APIMgtUsageDataPublisher;
import org.wso2.carbon.apimgt.usage.publisher.dto.BAMRequestPublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.dto.BAMResponsePublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.dto.RequestPublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.dto.ResponsePublisherDTO;
import org.wso2.carbon.apimgt.usage.publisher.internal.UsageComponent;
import org.wso2.carbon.apimgt.usage.publisher.service.APIMGTConfigReaderService;
import org.wso2.carbon.bam.agent.conf.AgentConfiguration;
import org.wso2.carbon.bam.agent.core.Agent;
import org.wso2.carbon.bam.agent.publish.EventReceiver;
import org.wso2.carbon.bam.service.Event;

public class APIMgtUsageBAMDataPublisher
implements APIMgtUsageDataPublisher {
    private static final Log log = LogFactory.getLog(APIMgtUsageBAMDataPublisher.class);
    private EventReceiver eventReceiver;
    private Agent agent;

    @Override
    public void init() {
        log.debug((Object)"Initializing APIMgtUsageDataBridgeDataPublisher");
        this.eventReceiver = this.getEventReceiver();
        AgentConfiguration configuration = new AgentConfiguration();
        this.agent = new Agent(configuration);
    }

    @Override
    public void publishEvent(RequestPublisherDTO requestPublisherDTO) {
        BAMRequestPublisherDTO bamRequestPublisherDTO = new BAMRequestPublisherDTO(requestPublisherDTO);
        Event event = new Event();
        event.setCorrelation(this.createCorrelationMap());
        event.setEvent(bamRequestPublisherDTO.createEventDataMap());
        event.setMeta(this.createMetaDataMap());
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(event);
        log.debug((Object)"Publishing request event to BAM");
        this.agent.publish(events, this.eventReceiver);
    }

    @Override
    public void publishEvent(ResponsePublisherDTO responsePublisherDTO) {
        BAMResponsePublisherDTO bamResponsePublisherDTO = new BAMResponsePublisherDTO(responsePublisherDTO);
        Event event = new Event();
        event.setCorrelation(this.createCorrelationMap());
        event.setEvent(bamResponsePublisherDTO.createEventDataMap());
        event.setMeta(this.createMetaDataMap());
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(event);
        log.debug((Object)"Publishing response event to BAM");
        this.agent.publish(events, this.eventReceiver);
    }

    private Map<String, ByteBuffer> createMetaDataMap() {
        HashMap<String, ByteBuffer> metaDataMap = new HashMap<String, ByteBuffer>();
        metaDataMap.put("metaKey", ByteBuffer.wrap("metaValue".getBytes()));
        return metaDataMap;
    }

    private Map<String, ByteBuffer> createCorrelationMap() {
        HashMap<String, ByteBuffer> correlationMap = new HashMap<String, ByteBuffer>();
        correlationMap.put("correlationKey", ByteBuffer.wrap("correlationValue".getBytes()));
        return correlationMap;
    }

    private EventReceiver getEventReceiver() {
        APIMGTConfigReaderService apimgtConfigReaderService = UsageComponent.getApiMgtConfigReaderService();
        EventReceiver eventReceiver = new EventReceiver();
        eventReceiver.setUrl(apimgtConfigReaderService.getBamServerURL());
        eventReceiver.setUserName(apimgtConfigReaderService.getBamServerUser());
        eventReceiver.setPassword(apimgtConfigReaderService.getBamServerPassword());
        eventReceiver.setPort(Integer.parseInt(apimgtConfigReaderService.getBamServerThriftPort()));
        eventReceiver.setSocketTransportEnabled(true);
        return eventReceiver;
    }
}

