/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.hostobjects;

import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.FileHostObject;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.dto.UserApplicationAPIUsage;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationType;
import org.wso2.carbon.apimgt.api.model.DuplicateAPIException;
import org.wso2.carbon.apimgt.api.model.LifeCycleEvent;
import org.wso2.carbon.apimgt.api.model.Subscriber;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.hostobjects.internal.HostObjectComponent;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.impl.UserAwareAPIProvider;
import org.wso2.carbon.apimgt.impl.utils.APINameComparator;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.APIVersionComparator;
import org.wso2.carbon.apimgt.usage.client.APIUsageStatisticsClient;
import org.wso2.carbon.apimgt.usage.client.dto.APIResponseTimeDTO;
import org.wso2.carbon.apimgt.usage.client.dto.APIUsageDTO;
import org.wso2.carbon.apimgt.usage.client.dto.APIVersionLastAccessTimeDTO;
import org.wso2.carbon.apimgt.usage.client.dto.APIVersionUsageDTO;
import org.wso2.carbon.apimgt.usage.client.dto.PerUserAPIUsageDTO;
import org.wso2.carbon.apimgt.usage.client.exception.APIMgtUsageQueryServiceClientException;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;

public class APIProviderHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(APIProviderHostObject.class);
    private String username;
    private APIProvider apiProvider;

    public String getClassName() {
        return "APIProvider";
    }

    public APIProviderHostObject() throws APIManagementException {
    }

    public APIProviderHostObject(String loggedUser) throws APIManagementException {
        this.username = loggedUser;
        this.apiProvider = APIManagerFactory.getInstance().getAPIProvider(loggedUser);
    }

    public String getUsername() {
        return this.username;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function Obj, boolean inNewExpr) throws APIManagementException {
        int length = args.length;
        if (length == 1) {
            String username = (String)args[0];
            return new APIProviderHostObject(username);
        }
        return new APIProviderHostObject();
    }

    public APIProvider getApiProvider() {
        return this.apiProvider;
    }

    private static APIProvider getAPIProvider(Scriptable thisObj) {
        return ((APIProviderHostObject)thisObj).getApiProvider();
    }

    public static NativeObject jsFunction_login(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        if (args.length != 2 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid input parameters to the login method");
        }
        String username = (String)args[0];
        String password = (String)args[1];
        APIManagerConfiguration config = HostObjectComponent.getAPIManagerConfiguration();
        String url = config.getFirstProperty("AuthManager.ServerURL");
        if (url == null) {
            throw new APIManagementException("API key manager URL unspecified");
        }
        NativeObject row = new NativeObject();
        try {
            boolean authorized;
            AuthenticationAdminStub authAdminStub = new AuthenticationAdminStub(null, url + "AuthenticationAdmin");
            ServiceClient client = authAdminStub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            String host = new URL(url).getHost();
            if (!authAdminStub.login(username, password, host)) {
                throw new APIManagementException("Authentication failed. Invalid username or password.");
            }
            ServiceContext serviceContext = authAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            String sessionCookie = (String)serviceContext.getProperty("Cookie");
            boolean bl = authorized = APIUtil.checkPermissionQuietly((String)username, (String)"/permission/admin/manage/api/create") || APIUtil.checkPermissionQuietly((String)username, (String)"/permission/admin/manage/api/publish");
            if (!authorized) {
                throw new APIManagementException("Insufficient privileges");
            }
            row.put("user", (Scriptable)row, (Object)username);
            row.put("sessionId", (Scriptable)row, (Object)sessionCookie);
            row.put("error", (Scriptable)row, (Object)false);
        }
        catch (Exception e) {
            row.put("error", (Scriptable)row, (Object)true);
            row.put("detail", (Scriptable)row, (Object)e.getMessage());
        }
        return row;
    }

    public static String jsFunction_getAuthServerURL(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        APIManagerConfiguration config = HostObjectComponent.getAPIManagerConfiguration();
        String url = config.getFirstProperty("AuthManager.ServerURL");
        if (url == null) {
            throw new APIManagementException("API key manager URL unspecified");
        }
        return url;
    }

    public static String jsFunction_getHTTPsURL(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        return "https://" + System.getProperty("carbon.local.ip") + ":" + System.getProperty("mgt.transport.https.port");
    }

    public static boolean jsFunction_addAPI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException, ScriptException {
        boolean success;
        String[] tierNames;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        NativeObject apiData = (NativeObject)args[0];
        String provider = (String)apiData.get("provider", (Scriptable)apiData);
        String name = (String)apiData.get("apiName", (Scriptable)apiData);
        String version = (String)apiData.get("version", (Scriptable)apiData);
        String description = (String)apiData.get("description", (Scriptable)apiData);
        String endpoint = (String)apiData.get("endpoint", (Scriptable)apiData);
        String sandboxUrl = (String)apiData.get("sandbox", (Scriptable)apiData);
        if ("".equals(sandboxUrl)) {
            sandboxUrl = null;
        }
        String wsdl = (String)apiData.get("wsdl", (Scriptable)apiData);
        String wadl = (String)apiData.get("wadl", (Scriptable)apiData);
        String tags = (String)apiData.get("tags", (Scriptable)apiData);
        HashSet<String> tag = new HashSet<String>();
        if (tags.indexOf(",") >= 0) {
            String[] userTag = tags.split(",");
            tag.addAll(Arrays.asList(userTag).subList(0, tags.split(",").length));
        } else {
            tag.add(tags);
        }
        String tier = (String)apiData.get("tier", (Scriptable)apiData);
        FileHostObject fileHostObject = (FileHostObject)apiData.get("imageUrl", (Scriptable)apiData);
        String contextVal = (String)apiData.get("context", (Scriptable)apiData);
        String context = contextVal.startsWith("/") ? contextVal : "/" + contextVal;
        NativeArray uriTemplateArr = (NativeArray)apiData.get("uriTemplateArr", (Scriptable)apiData);
        String techOwner = (String)apiData.get("techOwner", (Scriptable)apiData);
        String techOwnerEmail = (String)apiData.get("techOwnerEmail", (Scriptable)apiData);
        String bizOwner = (String)apiData.get("bizOwner", (Scriptable)apiData);
        String bizOwnerEmail = (String)apiData.get("bizOwnerEmail", (Scriptable)apiData);
        provider = provider.trim();
        name = name.trim();
        version = version.trim();
        APIIdentifier apiId = new APIIdentifier(provider, name, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        if (apiProvider.isAPIAvailable(apiId)) {
            throw new APIManagementException("Error occurred while adding the API. A duplicate API already exists for " + name + "-" + version);
        }
        API api = new API(apiId);
        NativeArray uriMethodArr = (NativeArray)apiData.get("uriMethodArr", (Scriptable)apiData);
        if (uriTemplateArr.getLength() == uriMethodArr.getLength()) {
            LinkedHashSet<URITemplate> uriTemplates = new LinkedHashSet<URITemplate>();
            int i = 0;
            while ((long)i < uriTemplateArr.getLength()) {
                String[] uriMethodArray;
                URITemplate templates = new URITemplate();
                String uriTemp = (String)uriTemplateArr.get(i, (Scriptable)uriTemplateArr);
                templates.setUriTemplate(uriTemp);
                String uriMethods = (String)uriMethodArr.get(i, (Scriptable)uriMethodArr);
                for (String anUriMethod : uriMethodArray = uriMethods.split(",")) {
                    templates.addMethod(anUriMethod);
                }
                templates.setResourceURI(endpoint);
                templates.setResourceSandboxURI(sandboxUrl);
                for (URITemplate uri : uriTemplates) {
                    String[] uriMethodsArr = uri.getMethods().toArray(new String[uri.getMethods().size()]);
                    if (!uri.getUriTemplate().equals(uriTemp) || !((APIProviderHostObject)thisObj).resourceMethodMatches(uriMethodsArr, uriMethodArray)) continue;
                    throw new APIManagementException("Duplicate API resources with same URI pattern and same HTTP method.");
                }
                uriTemplates.add(templates);
                ++i;
            }
            api.setUriTemplates(uriTemplates);
        }
        api.setDescription(description);
        api.setWsdlUrl(wsdl);
        api.setWadlUrl(wadl);
        api.setLastUpdated(new Date());
        api.setUrl(endpoint);
        api.setSandboxUrl(sandboxUrl);
        api.addTags(tag);
        HashSet<Tier> availableTier = new HashSet<Tier>();
        for (String tierName : tierNames = tier.split(",")) {
            availableTier.add(new Tier(tierName));
        }
        api.addAvailableTiers(availableTier);
        api.setStatus(APIStatus.CREATED);
        api.setContext(context);
        api.setBusinessOwner(bizOwner);
        api.setBusinessOwnerEmail(bizOwnerEmail);
        api.setTechnicalOwner(techOwner);
        api.setTechnicalOwnerEmail(techOwnerEmail);
        APIProviderHostObject.checkFileSize(fileHostObject);
        try {
            apiProvider.addAPI(api);
            if (fileHostObject != null && fileHostObject.getJavaScriptFile().getLength() != 0L) {
                api.setThumbnailUrl(apiProvider.addIcon(apiId, fileHostObject.getInputStream(), fileHostObject.getJavaScriptFile().getContentType()));
                apiProvider.updateAPI(api);
            }
            success = true;
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error while adding the API- " + name + "-" + version, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public static boolean jsFunction_updateAPI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        boolean success;
        String[] tierNames;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        NativeObject apiData = (NativeObject)args[0];
        String provider = (String)apiData.get("provider", (Scriptable)apiData);
        String name = (String)apiData.get("apiName", (Scriptable)apiData);
        String version = (String)apiData.get("version", (Scriptable)apiData);
        String description = (String)apiData.get("description", (Scriptable)apiData);
        FileHostObject fileHostObject = (FileHostObject)apiData.get("imageUrl", (Scriptable)apiData);
        String endpoint = (String)apiData.get("endpoint", (Scriptable)apiData);
        String sandboxUrl = (String)apiData.get("sandbox", (Scriptable)apiData);
        String techOwner = (String)apiData.get("techOwner", (Scriptable)apiData);
        String techOwnerEmail = (String)apiData.get("techOwnerEmail", (Scriptable)apiData);
        String bizOwner = (String)apiData.get("bizOwner", (Scriptable)apiData);
        String bizOwnerEmail = (String)apiData.get("bizOwnerEmail", (Scriptable)apiData);
        if ("".equals(sandboxUrl)) {
            sandboxUrl = null;
        }
        String wsdl = (String)apiData.get("wsdl", (Scriptable)apiData);
        String wadl = (String)apiData.get("wadl", (Scriptable)apiData);
        String tags = (String)apiData.get("tags", (Scriptable)apiData);
        HashSet<String> tag = new HashSet<String>();
        if (tags.indexOf(",") >= 0) {
            String[] userTag = tags.split(",");
            tag.addAll(Arrays.asList(userTag).subList(0, tags.split(",").length));
        } else {
            tag.add(tags);
        }
        provider = provider.trim();
        name = name.trim();
        version = version.trim();
        APIIdentifier oldApiId = new APIIdentifier(provider, name, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        API oldApi = apiProvider.getAPI(oldApiId);
        String tier = (String)apiData.get("tier", (Scriptable)apiData);
        String contextVal = (String)apiData.get("context", (Scriptable)apiData);
        String context = contextVal.startsWith("/") ? contextVal : "/" + contextVal;
        APIIdentifier apiId = new APIIdentifier(provider, name, version);
        API api = new API(apiId);
        NativeArray uriTemplateArr = (NativeArray)apiData.get("uriTemplateArr", (Scriptable)apiData);
        NativeArray uriMethodArr = (NativeArray)apiData.get("uriMethodArr", (Scriptable)apiData);
        if (uriTemplateArr.getLength() == uriMethodArr.getLength()) {
            LinkedHashSet<URITemplate> uriTemplates = new LinkedHashSet<URITemplate>();
            int i = 0;
            while ((long)i < uriTemplateArr.getLength()) {
                String[] uriMethodArray;
                URITemplate templates = new URITemplate();
                String templateVal = (String)uriTemplateArr.get(i, (Scriptable)uriTemplateArr);
                String template = templateVal.startsWith("/") ? templateVal : "/" + templateVal;
                templates.setUriTemplate(template);
                String uriMethods = (String)uriMethodArr.get(i, (Scriptable)uriMethodArr);
                for (String anUriMethod : uriMethodArray = uriMethods.split(",")) {
                    templates.addMethod(anUriMethod);
                }
                templates.setResourceURI(endpoint);
                templates.setResourceSandboxURI(sandboxUrl);
                for (URITemplate uri : uriTemplates) {
                    String[] uriMethodsArr = uri.getMethods().toArray(new String[uri.getMethods().size()]);
                    if (!uri.getUriTemplate().equals(template) || !((APIProviderHostObject)thisObj).resourceMethodMatches(uriMethodsArr, uriMethodArray)) continue;
                    throw new APIManagementException("Duplicate API resources with same URL pattern.");
                }
                uriTemplates.add(templates);
                ++i;
            }
            api.setUriTemplates(uriTemplates);
        }
        api.setDescription(description);
        api.setLastUpdated(new Date());
        api.setUrl(endpoint);
        api.setSandboxUrl(sandboxUrl);
        api.addTags(tag);
        api.setContext(context);
        HashSet<Tier> availableTier = new HashSet<Tier>();
        for (String tierName : tierNames = tier.split(",")) {
            availableTier.add(new Tier(tierName));
        }
        api.addAvailableTiers(availableTier);
        api.setStatus(oldApi.getStatus());
        api.setWsdlUrl(wsdl);
        api.setWadlUrl(wadl);
        api.setLastUpdated(new Date());
        api.setBusinessOwner(bizOwner);
        api.setBusinessOwnerEmail(bizOwnerEmail);
        api.setTechnicalOwner(techOwner);
        api.setTechnicalOwnerEmail(techOwnerEmail);
        try {
            APIProviderHostObject.checkFileSize(fileHostObject);
            if (fileHostObject != null && fileHostObject.getJavaScriptFile().getLength() != 0L) {
                api.setThumbnailUrl(apiProvider.addIcon(apiId, fileHostObject.getInputStream(), fileHostObject.getJavaScriptFile().getContentType()));
            } else if (oldApi.getThumbnailUrl() != null) {
                api.setThumbnailUrl(oldApi.getThumbnailUrl());
            }
            apiProvider.updateAPI(api);
            success = true;
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error while updating the API- " + name + "-" + version, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public static boolean jsFunction_updateAPIStatus(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        boolean success;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        NativeObject apiData = (NativeObject)args[0];
        String provider = (String)apiData.get("provider", (Scriptable)apiData);
        String name = (String)apiData.get("apiName", (Scriptable)apiData);
        String version = (String)apiData.get("version", (Scriptable)apiData);
        String status = (String)apiData.get("status", (Scriptable)apiData);
        boolean publishToGateway = Boolean.parseBoolean((String)apiData.get("publishToGateway", (Scriptable)apiData));
        boolean deprecateOldVersions = Boolean.parseBoolean((String)apiData.get("deprecateOldVersions", (Scriptable)apiData));
        boolean makeKeysForwardCompatible = Boolean.parseBoolean((String)apiData.get("makeKeysForwardCompatible", (Scriptable)apiData));
        try {
            APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
            APIIdentifier apiId = new APIIdentifier(provider, name, version);
            API api = apiProvider.getAPI(apiId);
            APIStatus oldStatus = api.getStatus();
            APIStatus newStatus = APIProviderHostObject.getApiStatus(status);
            String currentUser = ((APIProviderHostObject)thisObj).getUsername();
            apiProvider.changeAPIStatus(api, newStatus, currentUser, publishToGateway);
            if (oldStatus.equals((Object)APIStatus.CREATED) && newStatus.equals((Object)APIStatus.PUBLISHED)) {
                if (makeKeysForwardCompatible) {
                    apiProvider.makeAPIKeysForwardCompatible(api);
                }
                if (deprecateOldVersions) {
                    List apiList = apiProvider.getAPIsByProvider(provider);
                    APIVersionComparator versionComparator = new APIVersionComparator();
                    for (API oldAPI : apiList) {
                        if (!oldAPI.getId().getApiName().equals(name) || versionComparator.compare(oldAPI, api) >= 0 || !oldAPI.getStatus().equals((Object)APIStatus.PUBLISHED)) continue;
                        apiProvider.changeAPIStatus(oldAPI, APIStatus.DEPRECATED, currentUser, publishToGateway);
                    }
                }
            }
            success = true;
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error while updating API status", (Throwable)e);
        }
        return success;
    }

    private static void checkFileSize(FileHostObject fileHostObject) throws ScriptException, APIManagementException {
        long length;
        if (fileHostObject != null && (double)(length = fileHostObject.getJavaScriptFile().getLength()) / 1024.0 > 1024.0) {
            throw new APIManagementException("Image file exceeds the maximum limit of 1MB");
        }
    }

    public static NativeArray jsFunction_getAPI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (args.length != 3 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            API api = apiProvider.getAPI(apiId);
            Set uriTemplates = api.getUriTemplates();
            myn.put(0, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getId().getApiName()));
            myn.put(1, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getDescription()));
            myn.put(2, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getUrl()));
            myn.put(3, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getWsdlUrl()));
            myn.put(4, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getId().getVersion()));
            StringBuffer tagsSet = new StringBuffer("");
            for (int k = 0; k < api.getTags().toArray().length; ++k) {
                tagsSet.append(api.getTags().toArray()[k].toString());
                if (k == api.getTags().toArray().length - 1) continue;
                tagsSet.append(",");
            }
            myn.put(5, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(tagsSet.toString()));
            StringBuffer tiersSet = new StringBuffer("");
            StringBuffer tiersDescSet = new StringBuffer("");
            Set tierSet = api.getAvailableTiers();
            Iterator it = tierSet.iterator();
            int j = 0;
            while (it.hasNext()) {
                Object tierObject = it.next();
                Tier tier = (Tier)tierObject;
                tiersSet.append(tier.getName());
                tiersDescSet.append(tier.getDescription());
                if (j != tierSet.size() - 1) {
                    tiersSet.append(",");
                    tiersDescSet.append(",");
                }
                ++j;
            }
            myn.put(6, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(tiersSet.toString()));
            myn.put(7, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getStatus().toString()));
            myn.put(8, (Scriptable)myn, (Object)api.getThumbnailUrl());
            myn.put(9, (Scriptable)myn, (Object)api.getContext());
            myn.put(10, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getLastUpdated().toString()));
            myn.put(11, (Scriptable)myn, (Object)APIProviderHostObject.getSubscriberCount(apiId, thisObj));
            if (uriTemplates.size() != 0) {
                NativeArray uriTempArr = new NativeArray((long)uriTemplates.size());
                Iterator i = uriTemplates.iterator();
                ArrayList<NativeArray> uriTemplatesArr = new ArrayList<NativeArray>();
                while (i.hasNext()) {
                    ArrayList<String> utArr = new ArrayList<String>();
                    URITemplate ut = (URITemplate)i.next();
                    utArr.add(ut.getUriTemplate());
                    utArr.add(ut.getMethodsAsString().replaceAll("\\s", ","));
                    NativeArray utNArr = new NativeArray((long)utArr.size());
                    for (int p = 0; p < utArr.size(); ++p) {
                        utNArr.put(p, (Scriptable)utNArr, utArr.get(p));
                    }
                    uriTemplatesArr.add(utNArr);
                }
                for (int c = 0; c < uriTemplatesArr.size(); ++c) {
                    uriTempArr.put(c, (Scriptable)uriTempArr, uriTemplatesArr.get(c));
                }
                myn.put(12, (Scriptable)myn, (Object)uriTempArr);
                myn.put(13, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getSandboxUrl()));
                myn.put(14, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(tiersDescSet.toString()));
                myn.put(15, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getBusinessOwner()));
                myn.put(16, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getBusinessOwnerEmail()));
                myn.put(17, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getTechnicalOwner()));
                myn.put(18, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getTechnicalOwnerEmail()));
                myn.put(19, (Scriptable)myn, (Object)APIProviderHostObject.checkValue(api.getWadlUrl()));
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while getting API information of the api- " + apiName + "-" + version, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    public static NativeArray jsFunction_getSubscriberCountByAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        String providerName = null;
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        try {
            providerName = (String)args[0];
            if (providerName != null) {
                List apiSet = providerName.equals("__all_providers__") ? apiProvider.getAllAPIs() : apiProvider.getAPIsByProvider(providerName);
                TreeMap<String, Long> subscriptions = new TreeMap<String, Long>();
                for (API api : apiSet) {
                    long count;
                    if (api.getStatus() == APIStatus.CREATED || (count = apiProvider.getAPISubscriptionCountByAPI(api.getId())) == 0L) continue;
                    String key = api.getId().getApiName() + " (" + api.getId().getProviderName() + ")";
                    Long currentCount = (Long)subscriptions.get(key);
                    if (currentCount != null) {
                        subscriptions.put(key, currentCount + count);
                        continue;
                    }
                    subscriptions.put(key, count);
                }
                ArrayList<APISubscription> subscriptionData = new ArrayList<APISubscription>();
                for (Map.Entry entry : subscriptions.entrySet()) {
                    APISubscription sub = new APISubscription();
                    sub.name = (String)entry.getKey();
                    sub.count = (Long)entry.getValue();
                    subscriptionData.add(sub);
                }
                Collections.sort(subscriptionData, new Comparator<APISubscription>(){

                    @Override
                    public int compare(APISubscription o1, APISubscription o2) {
                        return (int)(o2.count - o1.count);
                    }
                });
                if (subscriptionData.size() > 10) {
                    int i;
                    APISubscription other = new APISubscription();
                    other.name = "[Other]";
                    for (i = 10; i < subscriptionData.size(); ++i) {
                        other.count = other.count + ((APISubscription)subscriptionData.get(i)).count;
                    }
                    for (i = 10; i < subscriptionData.size(); ++i) {
                        subscriptionData.remove(i);
                    }
                    subscriptionData.add(other);
                }
                int i = 0;
                for (APISubscription sub : subscriptionData) {
                    NativeObject row = new NativeObject();
                    row.put("apiName", (Scriptable)row, (Object)sub.name);
                    row.put("count", (Scriptable)row, (Object)sub.count);
                    myn.put(i, (Scriptable)myn, (Object)row);
                    ++i;
                }
            }
        }
        catch (APIManagementException e) {
            log.error((Object)("Error from registry while getting subscribers of the provider: " + providerName), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    public static NativeArray jsFunction_getTiers(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        NativeArray myn = new NativeArray(0L);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            Set tiers = apiProvider.getTiers();
            int i = 0;
            for (Tier tier : tiers) {
                NativeObject row = new NativeObject();
                row.put("tierName", (Scriptable)row, (Object)tier.getName());
                row.put("tierDescription", (Scriptable)row, (Object)(tier.getDescription() != null ? tier.getDescription() : ""));
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        catch (APIManagementException e) {
            log.error((Object)"Error from registry while getting available tiers", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    public static NativeArray jsFunction_getSubscriberCountByAPIVersions(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        String providerName = null;
        String apiName = null;
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        if (args.length == 0 || args.length == 1) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        try {
            providerName = (String)args[0];
            apiName = (String)args[1];
            if (providerName != null && apiName != null) {
                List apiSet = apiProvider.getAPIsByProvider(providerName);
                TreeMap<String, Long> subscriptions = new TreeMap<String, Long>();
                for (API api : apiSet) {
                    long count;
                    if (!api.getId().getApiName().equals(apiName) || api.getStatus() == APIStatus.CREATED || (count = apiProvider.getAPISubscriptionCountByAPI(api.getId())) == 0L) continue;
                    subscriptions.put(api.getId().getVersion(), count);
                }
                int i = 0;
                for (Map.Entry entry : subscriptions.entrySet()) {
                    NativeObject row = new NativeObject();
                    row.put("apiVersion", (Scriptable)row, entry.getKey());
                    row.put("count", (Scriptable)row, (Object)((Long)entry.getValue()));
                    myn.put(i, (Scriptable)myn, (Object)row);
                    ++i;
                }
            }
        }
        catch (APIManagementException e) {
            log.error((Object)("Error from registry while getting subscribers of the provider: " + providerName + " and API: " + apiName), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    private static int getSubscriberCount(APIIdentifier apiId, Scriptable thisObj) throws APIManagementException {
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        Set subs = apiProvider.getSubscribersOfAPI(apiId);
        HashSet<String> subscriberNames = new HashSet<String>();
        for (Subscriber sub : subs) {
            subscriberNames.add(sub.getName());
        }
        return subscriberNames.size();
    }

    public static NativeArray jsFunction_getAllAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            List apiList = apiProvider.getAllAPIs();
            Iterator it = apiList.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                row.put("apiName", (Scriptable)row, (Object)apiIdentifier.getApiName());
                row.put("version", (Scriptable)row, (Object)apiIdentifier.getVersion());
                row.put("provider", (Scriptable)row, (Object)apiIdentifier.getProviderName());
                row.put("status", (Scriptable)row, (Object)APIProviderHostObject.checkValue(api.getStatus().toString()));
                row.put("thumb", (Scriptable)row, (Object)api.getThumbnailUrl());
                row.put("subs", (Scriptable)row, (Object)APIProviderHostObject.getSubscriberCount(apiIdentifier, thisObj));
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while getting the APIs", (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    public static NativeArray jsFunction_getAPIsByProvider(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String providerName = (String)args[0];
        if (providerName != null) {
            APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
            try {
                List apiList = apiProvider.getAPIsByProvider(providerName);
                Iterator it = apiList.iterator();
                int i = 0;
                while (it.hasNext()) {
                    NativeObject row = new NativeObject();
                    Object apiObject = it.next();
                    API api = (API)apiObject;
                    APIIdentifier apiIdentifier = api.getId();
                    row.put("apiName", (Scriptable)row, (Object)apiIdentifier.getApiName());
                    row.put("version", (Scriptable)row, (Object)apiIdentifier.getVersion());
                    row.put("provider", (Scriptable)row, (Object)apiIdentifier.getProviderName());
                    row.put("updatedDate", (Scriptable)row, (Object)api.getLastUpdated().toString());
                    myn.put(i, (Scriptable)myn, (Object)row);
                    ++i;
                }
            }
            catch (APIManagementException e) {
                throw new APIManagementException("Error occurred while getting APIs for the provider: " + providerName, (Throwable)e);
            }
            catch (Exception e) {
                throw new APIManagementException(e.getMessage(), (Throwable)e);
            }
        }
        return myn;
    }

    public static NativeArray jsFunction_getSubscribedAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        String userName = null;
        NativeArray myn = new NativeArray(0L);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        if (args.length != 1 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        try {
            userName = (String)args[0];
            Subscriber subscriber = new Subscriber(userName);
            Set apiSet = apiProvider.getSubscriberAPIs(subscriber);
            Iterator it = apiSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                row.put("apiName", (Scriptable)row, (Object)apiIdentifier.getApiName());
                row.put("version", (Scriptable)row, (Object)apiIdentifier.getVersion());
                row.put("provider", (Scriptable)row, (Object)apiIdentifier.getProviderName());
                row.put("updatedDate", (Scriptable)row, (Object)api.getLastUpdated().toString());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while getting the subscribed APIs information for the subscriber-" + userName, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    public static NativeArray jsFunction_getAllAPIUsageByProvider(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        String providerName = null;
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        try {
            providerName = (String)args[0];
            if (providerName != null) {
                UserApplicationAPIUsage[] apiUsages = apiProvider.getAllAPIUsageByProvider(providerName);
                for (int i = 0; i < apiUsages.length; ++i) {
                    NativeObject row = new NativeObject();
                    row.put("userName", (Scriptable)row, (Object)apiUsages[i].getUserId());
                    row.put("application", (Scriptable)row, (Object)apiUsages[i].getApplicationName());
                    StringBuffer apiSet = new StringBuffer("");
                    for (int k = 0; k < apiUsages[i].getApiIdentifiers().length; ++k) {
                        apiSet.append(apiUsages[i].getApiIdentifiers()[k].getApiName());
                        apiSet.append("-");
                        apiSet.append(apiUsages[i].getApiIdentifiers()[k].getVersion());
                        if (k == apiUsages[i].getApiIdentifiers().length - 1) continue;
                        apiSet.append(",");
                    }
                    row.put("apis", (Scriptable)row, (Object)apiSet.toString());
                    myn.put(i, (Scriptable)myn, (Object)row);
                }
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while getting subscribers of the provider: " + providerName, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    public static NativeArray jsFunction_getAllDocumentation(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        String apiName = null;
        String version = null;
        NativeArray myn = new NativeArray(0L);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        if (args.length != 3 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        try {
            String providerName = args[0].toString();
            apiName = args[1].toString();
            version = args[2].toString();
            APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
            List docsList = apiProvider.getAllDocumentation(apiId);
            Iterator it = docsList.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object docsObject = it.next();
                Documentation doc = (Documentation)docsObject;
                Documentation.DocumentSourceType objectSourceType = doc.getSourceType();
                String strSourceType = objectSourceType.toString();
                row.put("docName", (Scriptable)row, (Object)doc.getName());
                row.put("docType", (Scriptable)row, (Object)doc.getType().getType());
                row.put("sourceType", (Scriptable)row, (Object)strSourceType);
                row.put("docLastUpdated", (Scriptable)row, (Object)doc.getLastUpdated().toString());
                if (Documentation.DocumentSourceType.URL.equals((Object)doc.getSourceType())) {
                    row.put("sourceUrl", (Scriptable)row, (Object)doc.getSourceUrl());
                }
                row.put("summary", (Scriptable)row, (Object)doc.getSummary());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while getting documentation of the api - " + apiName + "-" + version, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    public static NativeArray jsFunction_getInlineContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        String content;
        NativeArray myn = new NativeArray(0L);
        if (args.length != 4 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        String docName = args[3].toString();
        APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            content = apiProvider.getDocumentationContent(apiId, docName);
        }
        catch (Exception e) {
            throw new APIManagementException("Error while getting Inline Document Content ", (Throwable)e);
        }
        NativeObject row = new NativeObject();
        row.put("providerName", (Scriptable)row, (Object)providerName);
        row.put("apiName", (Scriptable)row, (Object)apiName);
        row.put("apiVersion", (Scriptable)row, (Object)version);
        row.put("docName", (Scriptable)row, (Object)docName);
        row.put("content", (Scriptable)row, (Object)content);
        myn.put(0, (Scriptable)myn, (Object)row);
        return myn;
    }

    public static void jsFunction_addInlineContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        if (args.length != 5 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        String docName = args[3].toString();
        String docContent = args[4].toString();
        if (docContent != null) {
            docContent = docContent.replaceAll("\n", "");
        }
        APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            apiProvider.addDocumentationContent(apiId, docName, docContent);
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while adding the content of the documentation- " + docName, (Throwable)e);
        }
    }

    public static boolean jsFunction_addDocumentation(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        boolean success;
        if (args.length < 5 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        String docName = args[3].toString();
        String docType = args[4].toString();
        String summary = args[5].toString();
        String sourceType = args[6].toString();
        String sourceURL = null;
        APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
        Documentation doc = new Documentation(APIProviderHostObject.getDocType(docType), docName);
        if (sourceType.equalsIgnoreCase(Documentation.DocumentSourceType.URL.toString())) {
            doc.setSourceType(Documentation.DocumentSourceType.URL);
            sourceURL = args[7].toString();
        } else {
            doc.setSourceType(Documentation.DocumentSourceType.INLINE);
        }
        doc.setSummary(summary);
        doc.setSourceUrl(sourceURL);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            apiProvider.addDocumentation(apiId, doc);
            success = true;
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while adding the document- " + docName, (Throwable)e);
        }
        return success;
    }

    public static boolean jsFunction_removeDocumentation(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        boolean success;
        if (args.length != 5 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        String docName = args[3].toString();
        String docType = args[4].toString();
        APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            apiProvider.removeDocumentation(apiId, docName, docType);
            success = true;
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while removing the document- " + docName + ".", (Throwable)e);
        }
        return success;
    }

    public static boolean jsFunction_createNewAPIVersion(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        boolean success;
        if (args.length != 4 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        String newVersion = args[3].toString();
        APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
        API api = new API(apiId);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            apiProvider.createNewAPIVersion(api, newVersion);
            success = true;
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while creating a new API version- " + newVersion, (Throwable)e);
        }
        catch (DuplicateAPIException e) {
            throw new APIManagementException("Error occurred while creating a new API version.A duplicate API already exists.", (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public static NativeArray jsFunction_getSubscribersOfAPI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (args.length != 3 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            Set subscribers = apiProvider.getSubscribersOfAPI(apiId);
            Iterator it = subscribers.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object subscriberObject = it.next();
                Subscriber user = (Subscriber)subscriberObject;
                row.put("userName", (Scriptable)row, (Object)user.getName());
                row.put("subscribedDate", (Scriptable)row, (Object)APIProviderHostObject.checkValue(user.getSubscribedDate().toString()));
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while getting subscribers of the API- " + apiName + "-" + version, (Throwable)e);
        }
        return myn;
    }

    public static String jsFunction_isContextExist(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        Boolean contextExist = false;
        String context = (String)args[0];
        String oldContext = (String)args[1];
        if (context != null) {
            if (context.equals(oldContext)) {
                return contextExist.toString();
            }
            APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
            try {
                contextExist = apiProvider.isContextExist(context);
            }
            catch (APIManagementException e) {
                log.error((Object)"Error from registry while checking the input context is already exist", (Throwable)e);
            }
        } else {
            throw new APIManagementException("Input context value is null");
        }
        return contextExist.toString();
    }

    private static DocumentationType getDocType(String docType) {
        DocumentationType docsType = null;
        for (DocumentationType type : DocumentationType.values()) {
            if (!type.getType().equalsIgnoreCase(docType)) continue;
            docsType = type;
        }
        return docsType;
    }

    private static boolean isStringValues(Object[] args) {
        int i = 0;
        for (Object arg : args) {
            if (!(arg instanceof String)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String checkValue(String input) {
        return input != null ? input : "";
    }

    private static APIStatus getApiStatus(String status) {
        APIStatus apiStatus = null;
        for (APIStatus aStatus : APIStatus.values()) {
            if (!aStatus.getStatus().equalsIgnoreCase(status)) continue;
            apiStatus = aStatus;
        }
        return apiStatus;
    }

    public static NativeArray jsFunction_getProviderAPIVersionUsage(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        List list = null;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String providerName = (String)args[0];
        String apiName = (String)args[1];
        try {
            APIUsageStatisticsClient client = new APIUsageStatisticsClient(((APIProviderHostObject)thisObj).getUsername());
            list = client.getUsageByAPIVersions(providerName, apiName);
        }
        catch (APIMgtUsageQueryServiceClientException e) {
            log.error((Object)"Error while invoking APIUsageStatisticsClient for ProviderAPIVersionUsage", (Throwable)e);
        }
        NativeArray myn = new NativeArray(0L);
        Iterator it = null;
        if (list != null) {
            it = list.iterator();
        }
        int i = 0;
        if (it != null) {
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object usageObject = it.next();
                APIVersionUsageDTO usage = (APIVersionUsageDTO)usageObject;
                row.put("version", (Scriptable)row, (Object)usage.getVersion());
                row.put("count", (Scriptable)row, (Object)usage.getCount());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        return myn;
    }

    public static NativeArray jsFunction_getProviderAPIUsage(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        List list = null;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String providerName = (String)args[0];
        try {
            APIUsageStatisticsClient client = new APIUsageStatisticsClient(((APIProviderHostObject)thisObj).getUsername());
            list = client.getUsageByAPIs(providerName);
        }
        catch (APIMgtUsageQueryServiceClientException e) {
            log.error((Object)"Error while invoking APIUsageStatisticsClient for ProviderAPIUsage", (Throwable)e);
        }
        NativeArray myn = new NativeArray(0L);
        Iterator it = null;
        if (list != null) {
            it = list.iterator();
        }
        int i = 0;
        if (it != null) {
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object usageObject = it.next();
                APIUsageDTO usage = (APIUsageDTO)usageObject;
                row.put("apiName", (Scriptable)row, (Object)usage.getApiName());
                row.put("count", (Scriptable)row, (Object)usage.getCount());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        return myn;
    }

    public static NativeArray jsFunction_getProviderAPIUserUsage(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        List list = null;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String providerName = (String)args[0];
        String apiName = (String)args[1];
        try {
            APIUsageStatisticsClient client = new APIUsageStatisticsClient(((APIProviderHostObject)thisObj).getUsername());
            list = client.getUsageBySubscribers(providerName, apiName, 10);
        }
        catch (APIMgtUsageQueryServiceClientException e) {
            log.error((Object)"Error while invoking APIUsageStatisticsClient for ProviderAPIUserUsage", (Throwable)e);
        }
        NativeArray myn = new NativeArray(0L);
        Iterator it = null;
        if (list != null) {
            it = list.iterator();
        }
        int i = 0;
        if (it != null) {
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object usageObject = it.next();
                PerUserAPIUsageDTO usage = (PerUserAPIUsageDTO)usageObject;
                row.put("user", (Scriptable)row, (Object)usage.getUsername());
                row.put("count", (Scriptable)row, (Object)usage.getCount());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        return myn;
    }

    public static NativeArray jsFunction_getProviderAPIVersionUserUsage(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        List list = null;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String providerName = (String)args[0];
        String apiName = (String)args[1];
        String version = (String)args[2];
        try {
            APIUsageStatisticsClient client = new APIUsageStatisticsClient(((APIProviderHostObject)thisObj).getUsername());
            list = client.getUsageBySubscribers(providerName, apiName, version, 10);
        }
        catch (APIMgtUsageQueryServiceClientException e) {
            log.error((Object)"Error while invoking APIUsageStatisticsClient for ProviderAPIUserUsage", (Throwable)e);
        }
        NativeArray myn = new NativeArray(0L);
        Iterator it = null;
        if (list != null) {
            it = list.iterator();
        }
        int i = 0;
        if (it != null) {
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object usageObject = it.next();
                PerUserAPIUsageDTO usage = (PerUserAPIUsageDTO)usageObject;
                row.put("user", (Scriptable)row, (Object)usage.getUsername());
                row.put("count", (Scriptable)row, (Object)usage.getCount());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        return myn;
    }

    public static NativeArray jsFunction_getProviderAPIVersionUserLastAccess(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        List list = null;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String providerName = (String)args[0];
        try {
            APIUsageStatisticsClient client = new APIUsageStatisticsClient(((APIProviderHostObject)thisObj).getUsername());
            list = client.getLastAccessTimesByAPI(providerName);
        }
        catch (APIMgtUsageQueryServiceClientException e) {
            log.error((Object)"Error while invoking APIUsageStatisticsClient for ProviderAPIVersionLastAccess", (Throwable)e);
        }
        NativeArray myn = new NativeArray(0L);
        Iterator it = null;
        if (list != null) {
            it = list.iterator();
        }
        int i = 0;
        if (it != null) {
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object usageObject = it.next();
                APIVersionLastAccessTimeDTO usage = (APIVersionLastAccessTimeDTO)usageObject;
                row.put("api_name", (Scriptable)row, (Object)usage.getApiName());
                row.put("api_version", (Scriptable)row, (Object)usage.getApiVersion());
                row.put("user", (Scriptable)row, (Object)usage.getUser());
                row.put("lastAccess", (Scriptable)row, (Object)usage.getLastAccessTime());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        return myn;
    }

    public static NativeArray jsFunction_getProviderAPIServiceTime(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        List list = null;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String providerName = (String)args[0];
        try {
            APIUsageStatisticsClient client = new APIUsageStatisticsClient(((APIProviderHostObject)thisObj).getUsername());
            list = client.getResponseTimesByAPIs(providerName);
        }
        catch (APIMgtUsageQueryServiceClientException e) {
            log.error((Object)"Error while invoking APIUsageStatisticsClient for ProviderAPIServiceTime", (Throwable)e);
        }
        NativeArray myn = new NativeArray(0L);
        Iterator it = null;
        if (list != null) {
            it = list.iterator();
        }
        int i = 0;
        if (it != null) {
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object usageObject = it.next();
                APIResponseTimeDTO usage = (APIResponseTimeDTO)usageObject;
                row.put("apiName", (Scriptable)row, (Object)usage.getApiName());
                row.put("serviceTime", (Scriptable)row, (Object)usage.getServiceTime());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        return myn;
    }

    public static NativeArray jsFunction_searchAllAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String apiName = (String)args[0];
        if ("*".equals(apiName) || apiName.startsWith("*")) {
            apiName = apiName.replaceFirst("\\*", ".*");
        }
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            List apiList = apiProvider.getAllAPIs();
            ArrayList<API> searchedList = new ArrayList<API>();
            String regex = "(?i)[a-zA-Z0-9_.-|]*" + apiName + "(?i)[a-zA-Z0-9_.-|]*";
            for (API api : apiList) {
                APIIdentifier apiIdentifier = api.getId();
                String name = apiIdentifier.getApiName();
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(name);
                if (!matcher.matches()) continue;
                searchedList.add(apiProvider.getAPI(apiIdentifier));
            }
            Collections.sort(searchedList, new APINameComparator());
            Iterator it = searchedList.iterator();
            int i = 0;
            while (it.hasNext()) {
                NativeObject row = new NativeObject();
                Object apiObject = it.next();
                API api = (API)apiObject;
                APIIdentifier apiIdentifier = api.getId();
                row.put("apiName", (Scriptable)row, (Object)apiIdentifier.getApiName());
                row.put("provider", (Scriptable)row, (Object)apiIdentifier.getProviderName());
                row.put("version", (Scriptable)row, (Object)apiIdentifier.getVersion());
                row.put("status", (Scriptable)row, (Object)APIProviderHostObject.checkValue(api.getStatus().toString()));
                row.put("thumb", (Scriptable)row, (Object)api.getThumbnailUrl());
                row.put("subs", (Scriptable)row, (Object)apiProvider.getSubscribersOfAPI(api.getId()).size());
                myn.put(i, (Scriptable)myn, (Object)row);
                ++i;
            }
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while getting the searched API- " + apiName, (Throwable)e);
        }
        catch (Exception e) {
            throw new APIManagementException(e.getMessage(), (Throwable)e);
        }
        return myn;
    }

    public static NativeArray jsFunction_searchAPIs(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray myn = new NativeArray(0L);
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of parameters.");
        }
        String providerName = (String)args[0];
        String apiName = (String)args[1];
        if ("*".equals(apiName) || apiName.startsWith("*")) {
            apiName = apiName.replaceFirst("\\*", ".*");
        }
        if (providerName != null) {
            APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
            try {
                List apiList = apiProvider.getAPIsByProvider(providerName);
                ArrayList<API> searchedList = new ArrayList<API>();
                String regex = "(?i)[a-zA-Z0-9_.-|]*" + apiName + "(?i)[a-zA-Z0-9_.-|]*";
                for (API api : apiList) {
                    APIIdentifier apiIdentifier = api.getId();
                    String name = apiIdentifier.getApiName();
                    Pattern pattern = Pattern.compile(regex);
                    Matcher matcher = pattern.matcher(name);
                    if (!matcher.matches()) continue;
                    searchedList.add(apiProvider.getAPI(apiIdentifier));
                }
                Collections.sort(searchedList, new APINameComparator());
                Iterator it = searchedList.iterator();
                int i = 0;
                while (it.hasNext()) {
                    NativeObject row = new NativeObject();
                    Object apiObject = it.next();
                    API api = (API)apiObject;
                    APIIdentifier apiIdentifier = api.getId();
                    row.put("apiName", (Scriptable)row, (Object)apiIdentifier.getApiName());
                    row.put("version", (Scriptable)row, (Object)apiIdentifier.getVersion());
                    row.put("status", (Scriptable)row, (Object)APIProviderHostObject.checkValue(api.getStatus().toString()));
                    row.put("thumb", (Scriptable)row, (Object)api.getThumbnailUrl());
                    row.put("subs", (Scriptable)row, (Object)apiProvider.getSubscribersOfAPI(api.getId()).size());
                    myn.put(i, (Scriptable)myn, (Object)row);
                    ++i;
                }
            }
            catch (APIManagementException e) {
                throw new APIManagementException("Error occurred while getting the searched API- " + apiName, (Throwable)e);
            }
            catch (Exception e) {
                throw new APIManagementException(e.getMessage(), (Throwable)e);
            }
        }
        return myn;
    }

    public static boolean jsFunction_hasCreatePermission(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        APIProvider provider = APIProviderHostObject.getAPIProvider(thisObj);
        if (provider instanceof UserAwareAPIProvider) {
            try {
                ((UserAwareAPIProvider)provider).checkCreatePermission();
                return true;
            }
            catch (APIManagementException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean jsFunction_hasPublishPermission(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        APIProvider provider = APIProviderHostObject.getAPIProvider(thisObj);
        if (provider instanceof UserAwareAPIProvider) {
            try {
                ((UserAwareAPIProvider)provider).checkPublishPermission();
                return true;
            }
            catch (APIManagementException e) {
                return false;
            }
        }
        return false;
    }

    public static NativeArray jsFunction_getLifeCycleEvents(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        NativeArray lifeCycles = new NativeArray(0L);
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        NativeObject apiData = (NativeObject)args[0];
        String provider = (String)apiData.get("provider", (Scriptable)apiData);
        String name = (String)apiData.get("name", (Scriptable)apiData);
        String version = (String)apiData.get("version", (Scriptable)apiData);
        APIIdentifier apiId = new APIIdentifier(provider, name, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            List lifeCycleEvents = apiProvider.getLifeCycleEvents(apiId);
            int i = 0;
            for (LifeCycleEvent lcEvent : lifeCycleEvents) {
                NativeObject event = new NativeObject();
                event.put("username", (Scriptable)event, (Object)APIProviderHostObject.checkValue(lcEvent.getUserId()));
                event.put("newStatus", (Scriptable)event, (Object)(lcEvent.getNewStatus() != null ? lcEvent.getNewStatus().toString() : ""));
                event.put("oldStatus", (Scriptable)event, (Object)(lcEvent.getOldStatus() != null ? lcEvent.getOldStatus().toString() : ""));
                event.put("date", (Scriptable)event, (Object)APIProviderHostObject.checkValue(lcEvent.getDate().toString()));
                lifeCycles.put(i, (Scriptable)lifeCycles, (Object)event);
                ++i;
            }
        }
        catch (APIManagementException e) {
            log.error((Object)"Error from registry while checking the input context is already exist", (Throwable)e);
        }
        return lifeCycles;
    }

    public static void jsFunction_removeAPI(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        NativeObject apiData = (NativeObject)args[0];
        String provider = (String)apiData.get("provider", (Scriptable)apiData);
        String name = (String)apiData.get("name", (Scriptable)apiData);
        String version = (String)apiData.get("version", (Scriptable)apiData);
        APIIdentifier apiId = new APIIdentifier(provider, name, version);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        apiProvider.deleteAPI(apiId);
    }

    public static boolean jsFunction_updateDocumentation(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        boolean success;
        if (args.length < 5 || !APIProviderHostObject.isStringValues(args)) {
            throw new APIManagementException("Invalid number of parameters or their types.");
        }
        String providerName = args[0].toString();
        String apiName = args[1].toString();
        String version = args[2].toString();
        String docName = args[3].toString();
        String docType = args[4].toString();
        String summary = args[5].toString();
        String sourceType = args[6].toString();
        String sourceURL = null;
        APIIdentifier apiId = new APIIdentifier(providerName, apiName, version);
        Documentation doc = new Documentation(APIProviderHostObject.getDocType(docType), docName);
        if (sourceType.equalsIgnoreCase(Documentation.DocumentSourceType.URL.toString())) {
            doc.setSourceType(Documentation.DocumentSourceType.URL);
            sourceURL = args[7].toString();
        } else {
            doc.setSourceType(Documentation.DocumentSourceType.INLINE);
        }
        doc.setSummary(summary);
        doc.setSourceUrl(sourceURL);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        try {
            apiProvider.updateDocumentation(apiId, doc);
            success = true;
        }
        catch (APIManagementException e) {
            throw new APIManagementException("Error occurred while adding the document- " + docName, (Throwable)e);
        }
        return success;
    }

    public static boolean jsFunction_isAPIOlderVersionExist(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws APIManagementException {
        boolean apiOlderVersionExist = false;
        if (args.length == 0) {
            throw new APIManagementException("Invalid number of input parameters.");
        }
        NativeObject apiData = (NativeObject)args[0];
        String provider = (String)apiData.get("provider", (Scriptable)apiData);
        String name = (String)apiData.get("name", (Scriptable)apiData);
        String version = (String)apiData.get("version", (Scriptable)apiData);
        APIProvider apiProvider = APIProviderHostObject.getAPIProvider(thisObj);
        APIIdentifier apiId = new APIIdentifier(provider, name, version);
        API api = apiProvider.getAPI(apiId);
        List apiList = apiProvider.getAPIsByProvider(provider);
        APIVersionComparator versionComparator = new APIVersionComparator();
        for (API oldAPI : apiList) {
            if (!oldAPI.getId().getApiName().equals(name) || versionComparator.compare(oldAPI, api) >= 0) continue;
            apiOlderVersionExist = true;
        }
        return apiOlderVersionExist;
    }

    public static String jsFunction_isURLValid(String uri) throws APIManagementException {
        String response = "";
        if (uri != null && !uri.equals("")) {
            try {
                URI validUri = new URI(uri);
                validUri.toURL().getContent();
                response = "success";
            }
            catch (URISyntaxException e) {
                response = "malformed";
            }
            catch (MalformedURLException e) {
                response = "malformed";
            }
            catch (UnknownHostException e) {
                response = "unknown";
            }
            catch (ConnectException e) {
                response = "Cannot establish connection to the provided address";
            }
            catch (SSLHandshakeException e) {
                response = "ssl_error";
            }
            catch (Exception e) {
                response = e.getMessage();
            }
        }
        return response;
    }

    private boolean resourceMethodMatches(String[] resourceMethod1, String[] resourceMethod2) {
        for (String m1 : resourceMethod1) {
            for (String m2 : resourceMethod2) {
                if (!m1.equals(m2)) continue;
                return true;
            }
        }
        return false;
    }

    private static class APISubscription {
        private String name;
        private long count;

        private APISubscription() {
        }
    }
}

