/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.um.ws.api.stub.RemoteAuthorizationManagerServiceStub;
import org.wso2.carbon.utils.CarbonUtils;

class RemoteAuthorizationManagerClient {
    private static final int TIMEOUT_IN_MILLIS = 900000;
    private RemoteAuthorizationManagerServiceStub clientStub;
    private String username;
    private String password;
    private String cookie;

    public RemoteAuthorizationManagerClient() throws APIManagementException {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String serviceURL = config.getFirstProperty("APIKeyManager.ServerURL");
        this.username = config.getFirstProperty("APIKeyManager.Username");
        this.password = config.getFirstProperty("APIKeyManager.Password");
        if (serviceURL == null || this.username == null || this.password == null) {
            throw new APIManagementException("Required connection details for the key management server not provided");
        }
        try {
            this.clientStub = new RemoteAuthorizationManagerServiceStub(null, serviceURL + "RemoteAuthorizationManagerService");
            ServiceClient client = this.clientStub._getServiceClient();
            Options options = client.getOptions();
            options.setTimeOutInMilliSeconds(900000L);
            options.setProperty("SO_TIMEOUT", (Object)900000);
            options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
            options.setCallTransportCleanup(true);
            options.setManageSession(true);
        }
        catch (AxisFault axisFault) {
            throw new APIManagementException("Error while initializing the API key validation stub", (Throwable)axisFault);
        }
    }

    public boolean isUserAuthorized(String user, String permission) throws APIManagementException {
        CarbonUtils.setBasicAccessSecurityHeaders((String)this.username, (String)this.password, (boolean)true, (ServiceClient)this.clientStub._getServiceClient());
        if (this.cookie != null) {
            this.clientStub._getServiceClient().getOptions().setProperty("Cookie", (Object)this.cookie);
        }
        try {
            boolean authorized = this.clientStub.isUserAuthorized(user, permission, "ui.execute");
            ServiceContext serviceContext = this.clientStub._getServiceClient().getLastOperationContext().getServiceContext();
            this.cookie = (String)serviceContext.getProperty("Cookie");
            return authorized;
        }
        catch (Exception e) {
            throw new APIManagementException("Error while accessing backend services for user permission validation", (Throwable)e);
        }
    }
}

