/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.utils.LRUCache;
import org.wso2.carbon.apimgt.impl.utils.RemoteAuthorizationManagerClient;

public class RemoteAuthorizationManager {
    private static final RemoteAuthorizationManager instance = new RemoteAuthorizationManager();
    private ObjectPool clientPool;
    private Map<String, Boolean> authorizationDataCache = new LRUCache<String, Boolean>(1000);
    private ScheduledExecutorService exec;
    private ScheduledFuture future;

    private RemoteAuthorizationManager() {
    }

    public static RemoteAuthorizationManager getInstance() {
        return instance;
    }

    public void init() {
        this.clientPool = new StackObjectPool((PoolableObjectFactory)new BasePoolableObjectFactory(){

            public Object makeObject() throws Exception {
                return new RemoteAuthorizationManagerClient();
            }
        });
        this.exec = Executors.newSingleThreadScheduledExecutor();
        this.future = this.exec.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                RemoteAuthorizationManager.this.authorizationDataCache.clear();
            }
        }, 20L, 20L, TimeUnit.MINUTES);
    }

    public void destroy() {
        try {
            this.clientPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.future.cancel(true);
        this.exec.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserAuthorized(String user, String permission) throws APIManagementException {
        String key = user + ":" + permission;
        Boolean authorized = this.authorizationDataCache.get(key);
        if (authorized == null) {
            RemoteAuthorizationManager remoteAuthorizationManager = this;
            synchronized (remoteAuthorizationManager) {
                authorized = this.authorizationDataCache.get(key);
                if (authorized == null) {
                    authorized = this.queryRemoteAuthorizationManager(user, permission);
                    this.authorizationDataCache.put(key, authorized);
                }
            }
        }
        return authorized;
    }

    private boolean queryRemoteAuthorizationManager(String user, String permission) throws APIManagementException {
        RemoteAuthorizationManagerClient client = null;
        try {
            client = (RemoteAuthorizationManagerClient)this.clientPool.borrowObject();
            boolean bl = client.isUserAuthorized(user, permission);
            return bl;
        }
        catch (Exception e) {
            throw new APIManagementException("Error while accessing backend services for API key validation", (Throwable)e);
        }
        finally {
            try {
                if (client != null) {
                    this.clientPool.returnObject((Object)client);
                }
            }
            catch (Exception ignored) {}
        }
    }
}

