/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.impl.template.APITemplateBuilder;
import org.wso2.carbon.apimgt.impl.utils.AbstractAPIGatewayAdminClient;
import org.wso2.carbon.rest.api.stub.RestApiAdminStub;
import org.wso2.carbon.rest.api.stub.types.carbon.APIData;

public class RESTAPIAdminClient
extends AbstractAPIGatewayAdminClient {
    private RestApiAdminStub restApiAdminStub;
    private String qualifiedName;

    public RESTAPIAdminClient(APIIdentifier apiId) throws AxisFault {
        this.qualifiedName = apiId.getProviderName() + "--" + apiId.getApiName() + ":v" + apiId.getVersion();
        this.restApiAdminStub = new RestApiAdminStub(null, this.getServiceEndpoint("RestApiAdmin"));
        this.setup((Stub)this.restApiAdminStub);
    }

    public void addApi(APITemplateBuilder builder) throws AxisFault {
        try {
            String apiConfig = builder.getConfigStringForTemplate();
            this.restApiAdminStub.addApiFromString(apiConfig);
        }
        catch (Exception e) {
            throw new AxisFault("Error while adding new API", (Throwable)e);
        }
    }

    public APIData getApi() throws AxisFault {
        try {
            return this.restApiAdminStub.getApiByName(this.qualifiedName);
        }
        catch (Exception e) {
            throw new AxisFault("Error while obtaining API information from gateway", (Throwable)e);
        }
    }

    public void updateApi(APITemplateBuilder builder) throws AxisFault {
        try {
            String apiConfig = builder.getConfigStringForTemplate();
            this.restApiAdminStub.updateApiFromString(this.qualifiedName, apiConfig);
        }
        catch (Exception e) {
            throw new AxisFault("Error while updating API", (Throwable)e);
        }
    }

    public void deleteApi() throws AxisFault {
        try {
            this.restApiAdminStub.deleteApi(this.qualifiedName);
        }
        catch (Exception e) {
            throw new AxisFault("Error while deleting API", (Throwable)e);
        }
    }
}

