/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ServiceContext;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.authenticator.stub.LoginAuthenticationExceptionException;

public abstract class AbstractAPIGatewayAdminClient {
    protected void setup(Stub stub) throws AxisFault {
        String cookie = this.login();
        ServiceClient client = stub._getServiceClient();
        Options options = client.getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    private String login() throws AxisFault {
        String host;
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String user = config.getFirstProperty("APIGateway.Username");
        String password = config.getFirstProperty("APIGateway.Password");
        String url = config.getFirstProperty("APIGateway.ServerURL");
        if (url == null || user == null || password == null) {
            throw new AxisFault("Required API gateway admin configuration unspecified");
        }
        try {
            host = new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            throw new AxisFault("API gateway URL is malformed", (Throwable)e);
        }
        AuthenticationAdminStub authAdminStub = new AuthenticationAdminStub(null, url + "AuthenticationAdmin");
        ServiceClient client = authAdminStub._getServiceClient();
        Options options = client.getOptions();
        options.setManageSession(true);
        try {
            authAdminStub.login(user, password, host);
            ServiceContext serviceContext = authAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
            String sessionCookie = (String)serviceContext.getProperty("Cookie");
            return sessionCookie;
        }
        catch (RemoteException e) {
            throw new AxisFault("Error while contacting the authentication admin services", (Throwable)e);
        }
        catch (LoginAuthenticationExceptionException e) {
            throw new AxisFault("Error while authenticating against the API gateway admin", (Throwable)e);
        }
    }

    protected String getServiceEndpoint(String serviceName) {
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        String url = config.getFirstProperty("APIGateway.ServerURL");
        return url + serviceName;
    }
}

