/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.api.model.DocumentationType;
import org.wso2.carbon.apimgt.api.model.Provider;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.RemoteAuthorizationManager;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.endpoints.EndpointManager;
import org.wso2.carbon.governance.api.endpoints.dataobjects.Endpoint;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.api.wsdls.WsdlManager;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public final class APIUtil {
    private static final Log log = LogFactory.getLog(APIUtil.class);

    public static API getAPI(GovernanceArtifact artifact, Registry registry) throws APIManagementException {
        API api;
        try {
            Tag[] tag;
            String providerName = artifact.getAttribute("overview_provider");
            String apiName = artifact.getAttribute("overview_name");
            String apiVersion = artifact.getAttribute("overview_version");
            api = new API(new APIIdentifier(providerName, apiName, apiVersion));
            String artifactPath = GovernanceUtils.getArtifactPath((Registry)registry, (String)artifact.getId());
            api.setRating(registry.getAverageRating(artifactPath));
            api.setDescription(artifact.getAttribute("overview_description"));
            api.setLastUpdated(registry.get(artifactPath).getLastModified());
            api.setUrl(artifact.getAttribute("overview_endpointURL"));
            api.setSandboxUrl(artifact.getAttribute("overview_sandboxURL"));
            api.setStatus(APIUtil.getApiStatus(artifact.getAttribute("overview_status")));
            api.setThumbnailUrl(artifact.getAttribute("overview_thumbnail"));
            api.setWsdlUrl(artifact.getAttribute("overview_WSDL"));
            api.setWadlUrl(artifact.getAttribute("overview_WADL"));
            api.setTechnicalOwner(artifact.getAttribute("overview_technicalOwner"));
            api.setTechnicalOwnerEmail(artifact.getAttribute("overview_technicalOwnerEmail"));
            api.setBusinessOwner(artifact.getAttribute("overview_businessOwner"));
            api.setBusinessOwnerEmail(artifact.getAttribute("overview_BusinessOwnerEmail"));
            HashSet<Tier> availableTier = new HashSet<Tier>();
            String tiers = artifact.getAttribute("overview_tier");
            Map<String, Tier> definedTiers = APIUtil.getTiers();
            if (tiers != null && !"".equals(tiers)) {
                String[] tierNames;
                for (String tierName : tierNames = tiers.split("\\|\\|")) {
                    Tier definedTier = definedTiers.get(tierName);
                    if (definedTier != null) {
                        availableTier.add(definedTier);
                        continue;
                    }
                    log.warn((Object)("Unknown tier: " + tierName + " found on API: " + apiName));
                }
            }
            api.addAvailableTiers(availableTier);
            api.setContext(artifact.getAttribute("overview_context"));
            api.setLatest(Boolean.valueOf(artifact.getAttribute("overview_isLatest")).booleanValue());
            LinkedHashSet<URITemplate> uriTemplates = new LinkedHashSet<URITemplate>();
            String[] templates = artifact.getAttributes("uriTemplates_entry");
            if (templates != null) {
                for (String template : templates) {
                    String[] methods;
                    URITemplate uriTemplate = new URITemplate();
                    String[] s = template.split(":");
                    if (s.length != 2) continue;
                    for (String method : methods = s[0].split(" ")) {
                        uriTemplate.addMethod(method);
                    }
                    uriTemplate.setUriTemplate(s[1]);
                    uriTemplate.setResourceURI(api.getUrl());
                    uriTemplate.setResourceSandboxURI(api.getSandboxUrl());
                    uriTemplates.add(uriTemplate);
                }
                api.setUriTemplates(uriTemplates);
            }
            HashSet<String> tags = new HashSet<String>();
            for (Tag tag1 : tag = registry.getTags(artifactPath)) {
                tags.add(tag1.getTagName());
            }
            api.addTags(tags);
            api.setLastUpdated(registry.get(artifactPath).getLastModified());
        }
        catch (GovernanceException e) {
            String msg = "Failed to get API fro artifact ";
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "Failed to get LastAccess time or Rating";
            throw new APIManagementException(msg, (Throwable)e);
        }
        return api;
    }

    public static Provider getProvider(GenericArtifact artifact) throws APIManagementException {
        Provider provider;
        try {
            provider = new Provider(artifact.getAttribute("overview_name"));
            provider.setDescription(artifact.getAttribute("overview_description"));
            provider.setEmail(artifact.getAttribute("overview_email"));
        }
        catch (GovernanceException e) {
            String msg = "Failed to get provider ";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return provider;
    }

    public static GenericArtifact createAPIArtifactContent(GenericArtifact artifact, API api) throws APIManagementException {
        try {
            String apiStatus = api.getStatus().getStatus();
            artifact.setAttribute("overview_name", api.getId().getApiName());
            artifact.setAttribute("overview_version", api.getId().getVersion());
            artifact.setAttribute("overview_context", api.getContext());
            artifact.setAttribute("overview_provider", api.getId().getProviderName());
            artifact.setAttribute("overview_description", api.getDescription());
            artifact.setAttribute("overview_endpointURL", api.getUrl());
            artifact.setAttribute("overview_sandboxURL", api.getSandboxUrl());
            artifact.setAttribute("overview_WSDL", api.getWsdlUrl());
            artifact.setAttribute("overview_WADL", api.getWadlUrl());
            artifact.setAttribute("overview_thumbnail", api.getThumbnailUrl());
            artifact.setAttribute("overview_status", apiStatus);
            artifact.setAttribute("overview_technicalOwner", api.getTechnicalOwner());
            artifact.setAttribute("overview_technicalOwnerEmail", api.getTechnicalOwnerEmail());
            artifact.setAttribute("overview_businessOwner", api.getBusinessOwner());
            artifact.setAttribute("overview_BusinessOwnerEmail", api.getBusinessOwnerEmail());
            String tiers = "";
            for (Tier tier : api.getAvailableTiers()) {
                tiers = tiers + tier.getName() + "||";
            }
            if (!"".equals(tiers)) {
                tiers = tiers.substring(0, tiers.length() - 2);
                artifact.setAttribute("overview_tier", tiers);
            }
            if ("PUBLISHED".equals(apiStatus)) {
                artifact.setAttribute("overview_isLatest", "true");
            }
            artifact.removeAttribute("uriTemplates_entry");
            Set uriTemplateSet = api.getUriTemplates();
            for (URITemplate uriTemplate : uriTemplateSet) {
                artifact.addAttribute("uriTemplates_entry", uriTemplate.getMethodsAsString() + ":" + uriTemplate.getUriTemplate());
            }
        }
        catch (GovernanceException e) {
            String msg = "Failed to create API for : " + api.getId().getApiName();
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return artifact;
    }

    public static Documentation getDocumentation(GenericArtifact artifact) throws APIManagementException {
        Documentation documentation;
        try {
            String docType = artifact.getAttribute("overview_type");
            DocumentationType type = docType.equalsIgnoreCase(DocumentationType.HOWTO.getType()) ? DocumentationType.HOWTO : (docType.equalsIgnoreCase(DocumentationType.PUBLIC_FORUM.getType()) ? DocumentationType.PUBLIC_FORUM : (docType.equalsIgnoreCase(DocumentationType.SUPPORT_FORUM.getType()) ? DocumentationType.SUPPORT_FORUM : (docType.equalsIgnoreCase(DocumentationType.API_MESSAGE_FORMAT.getType()) ? DocumentationType.API_MESSAGE_FORMAT : (docType.equalsIgnoreCase(DocumentationType.SAMPLES.getType()) ? DocumentationType.SAMPLES : DocumentationType.OTHER))));
            documentation = new Documentation(type, artifact.getAttribute("overview_name"));
            documentation.setSummary(artifact.getAttribute("overview_summary"));
            Documentation.DocumentSourceType docSourceType = artifact.getAttribute("overview_sourceType").equals("URL") ? Documentation.DocumentSourceType.URL : Documentation.DocumentSourceType.INLINE;
            documentation.setSourceType(docSourceType);
            if (artifact.getAttribute("overview_sourceType").equals("URL")) {
                documentation.setSourceUrl(artifact.getAttribute("overview_sourceURL"));
            }
        }
        catch (GovernanceException e) {
            throw new APIManagementException("Failed to get documentation from artifact", (Throwable)e);
        }
        return documentation;
    }

    public static APIStatus getApiStatus(String status) throws APIManagementException {
        APIStatus apiStatus = null;
        for (APIStatus aStatus : APIStatus.values()) {
            if (!aStatus.getStatus().equals(status)) continue;
            apiStatus = aStatus;
        }
        return apiStatus;
    }

    public static String getAPIPath(APIIdentifier identifier) {
        return "/apimgt/applicationdata/provider/" + identifier.getProviderName() + "/" + identifier.getApiName() + "/" + identifier.getVersion() + "/api";
    }

    public static String getAPIProviderPath(APIIdentifier identifier) {
        return "/apimgt/applicationdata/provider/" + identifier.getProviderName();
    }

    public static String getAPIDocPath(APIIdentifier apiId) {
        return "/apimgt/applicationdata/provider/" + apiId.getProviderName() + "/" + apiId.getApiName() + "/" + apiId.getVersion() + "/" + "documentation" + "/";
    }

    public static GenericArtifact createDocArtifactContent(GenericArtifact artifact, APIIdentifier apiId, Documentation documentation) throws APIManagementException {
        try {
            artifact.setAttribute("overview_name", documentation.getName());
            artifact.setAttribute("overview_summary", documentation.getSummary());
            artifact.setAttribute("overview_type", documentation.getType().getType());
            Documentation.DocumentSourceType sourceType = documentation.getSourceType();
            switch (sourceType) {
                case INLINE: {
                    sourceType = Documentation.DocumentSourceType.INLINE;
                    break;
                }
                case URL: {
                    sourceType = Documentation.DocumentSourceType.URL;
                }
            }
            artifact.setAttribute("overview_sourceType", sourceType.name());
            artifact.setAttribute("overview_sourceURL", documentation.getSourceUrl());
            String basePath = apiId.getProviderName() + "/" + apiId.getApiName() + "/" + apiId.getVersion();
            artifact.setAttribute("overview_apiBasePath", basePath);
        }
        catch (GovernanceException e) {
            String msg = "Filed to create doc artifact content from :" + documentation.getName();
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return artifact;
    }

    public static GenericArtifactManager getArtifactManager(Registry registry, String key) throws APIManagementException {
        GenericArtifactManager artifactManager;
        try {
            artifactManager = new GenericArtifactManager(registry, key);
        }
        catch (RegistryException e) {
            String msg = "Failed to initialized GenericArtifactManager";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return artifactManager;
    }

    public static String createWSDL(String wsdlUrl, Registry registry) {
        String path = null;
        try {
            WsdlManager wsdlManager = new WsdlManager(registry);
            Wsdl wsdl = wsdlManager.newWsdl(wsdlUrl);
            wsdlManager.addWsdl(wsdl);
            path = GovernanceUtils.getArtifactPath((Registry)registry, (String)wsdl.getId());
        }
        catch (GovernanceException e) {
            String msg = "Failed to add wsdl " + wsdlUrl + " to registry ";
            log.error((Object)msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "Failed to initialize gov registry for wsdl import";
            log.error((Object)msg, (Throwable)e);
        }
        return path;
    }

    public static String createEndpoint(String endpointUrl, Registry registry) {
        String path = null;
        try {
            EndpointManager endpointManager = new EndpointManager(registry);
            Endpoint endpoint = endpointManager.newEndpoint(endpointUrl);
            endpointManager.addEndpoint(endpoint);
            path = GovernanceUtils.getArtifactPath((Registry)registry, (String)endpoint.getId());
        }
        catch (RegistryException e) {
            String msg = "Failed to import endpoint " + endpointUrl + " to registry ";
            log.error((Object)msg, (Throwable)e);
        }
        return path;
    }

    public static Map<String, Tier> getTiers() throws APIManagementException {
        TreeMap<String, Tier> tiers = new TreeMap<String, Tier>();
        try {
            APIManagerConfiguration config;
            UserRegistry registry = ServiceReferenceHolder.getInstance().getRegistryService().getGovernanceSystemRegistry();
            if (registry.resourceExists("/apimgt/applicationdata/tiers.xml")) {
                Resource resource = registry.get("/apimgt/applicationdata/tiers.xml");
                String content = new String((byte[])resource.getContent());
                OMElement element = AXIOMUtil.stringToOM((String)content);
                OMElement assertion = element.getFirstChildWithName(APIConstants.ASSERTION_ELEMENT);
                Iterator policies = assertion.getChildrenWithName(APIConstants.POLICY_ELEMENT);
                while (policies.hasNext()) {
                    OMElement policy = (OMElement)policies.next();
                    OMElement id = policy.getFirstChildWithName(APIConstants.THROTTLE_ID_ELEMENT);
                    Tier tier = new Tier(id.getText());
                    tier.setPolicyContent(policy.toString().getBytes());
                    String desc = resource.getProperty("tier.desc." + id.getText());
                    tier.setDescription(desc);
                    tiers.put(tier.getName(), tier);
                }
            }
            if (Boolean.parseBoolean((config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration()).getFirstProperty("TierManagement.EnableUnlimitedTier"))) {
                Tier tier = new Tier("Unlimited");
                tier.setDescription("Allows unlimited requests");
                tiers.put(tier.getName(), tier);
            }
        }
        catch (RegistryException e) {
            String msg = "Error while retrieving API tiers from registry";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String msg = "Malformed XML found in the API tier policy resource";
            log.error((Object)msg, (Throwable)e);
            throw new APIManagementException(msg, (Throwable)e);
        }
        return tiers;
    }

    public static void checkPermission(String username, String permission) throws APIManagementException {
        if (username == null) {
            throw new APIManagementException("Attempt to execute privileged operation as the anonymous user");
        }
        RemoteAuthorizationManager authorizationManager = RemoteAuthorizationManager.getInstance();
        boolean authorized = authorizationManager.isUserAuthorized(username, permission);
        if (!authorized) {
            throw new APIManagementException("User '" + username + "' does not have the " + "required permission: " + permission);
        }
    }

    public static boolean checkPermissionQuietly(String username, String permission) {
        try {
            APIUtil.checkPermission(username, permission);
            return true;
        }
        catch (APIManagementException e) {
            return false;
        }
    }
}

