/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.DBConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;

public final class APIMgtDBUtil {
    private static final Log log = LogFactory.getLog(APIMgtDBUtil.class);
    private static volatile BasicDataSource dataSource = null;
    private static final String DB_CONFIG = "Database.";
    private static final String DB_DRIVER = "Database.Driver";
    private static final String DB_URL = "Database.URL";
    private static final String DB_USER = "Database.Username";
    private static final String DB_PASSWORD = "Database.Password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() throws APIManagementException {
        if (dataSource != null) {
            return;
        }
        Class<APIMgtDBUtil> clazz = APIMgtDBUtil.class;
        synchronized (APIMgtDBUtil.class) {
            if (dataSource == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Initializing data source");
                }
                DBConfiguration configuration = APIMgtDBUtil.getDBConfig();
                String dbUrl = configuration.getDbUrl();
                String driver = configuration.getDriverName();
                String username = configuration.getUserName();
                String password = configuration.getPassword();
                if (dbUrl == null || driver == null || username == null || password == null) {
                    throw new APIManagementException("Required DB configuration parameters unspecified");
                }
                dataSource = new BasicDataSource();
                dataSource.setDriverClassName(driver);
                dataSource.setUrl(dbUrl);
                dataSource.setUsername(username);
                dataSource.setPassword(password);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean checkDBConfiguration() {
        DBConfiguration configuration = APIMgtDBUtil.getDBConfig();
        String dbUrl = configuration.getDbUrl();
        String driver = configuration.getDriverName();
        String username = configuration.getUserName();
        String password = configuration.getPassword();
        return dbUrl != null && driver != null && username != null && password != null;
    }

    public static Connection getConnection() throws SQLException {
        if (dataSource != null && !dataSource.isClosed()) {
            return dataSource.getConnection();
        }
        throw new SQLException("Data source is not configured properly.");
    }

    public static void closeAllConnections(PreparedStatement preparedStatement, Connection connection, ResultSet resultSet) {
        APIMgtDBUtil.closeConnection(connection);
        APIMgtDBUtil.closeResultSet(resultSet);
        APIMgtDBUtil.closeStatement(preparedStatement);
    }

    private static void closeConnection(Connection dbConnection) {
        if (dbConnection != null) {
            try {
                dbConnection.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Database error. Could not close database connection. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Database error. Could not close ResultSet  - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Database error. Could not close PreparedStatement. Continuing with others. - " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static DBConfiguration getDBConfig() {
        DBConfiguration dbConfiguration = new DBConfiguration();
        APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
        dbConfiguration.setDbUrl(config.getFirstProperty(DB_URL));
        dbConfiguration.setDriverName(config.getFirstProperty(DB_DRIVER));
        dbConfiguration.setUserName(config.getFirstProperty(DB_USER));
        dbConfiguration.setPassword(config.getFirstProperty(DB_PASSWORD));
        return dbConfiguration;
    }
}

