/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.template;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;

public class TemplateLoader {
    private static final Log log = LogFactory.getLog(TemplateLoader.class);
    public static final String TEMPLATE_TYPE_API = "api";
    public static final String TEMPLATE_TYPE_BLOCKED_API = "blocked_api";
    public static final String TEMPLATE_TYPE_RESOURCE = "resource";
    public static final String TEMPLATE_TYPE_COMPLEX_RESOURCE = "complex_resource";
    public static final String TEMPLATE_TYPE_HANDLERS = "handlers";
    public static final String TEMPLATE_TYPE_COMPLEX_HANDLER = "complex_handler";
    public static final String TEMPLATE_TYPE_SIMPLE_HANDLER = "simple_handler";
    private static final String TEMPLATE_FILE_PREFIX = "/api_templates_";
    private static final TemplateLoader instance = new TemplateLoader();
    private Map<String, String> templates = new HashMap<String, String>();

    private TemplateLoader() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing API template loader");
        }
    }

    public static TemplateLoader getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemplate(String type) throws APITemplateException {
        String template = this.templates.get(type);
        if (template == null) {
            TemplateLoader templateLoader = this;
            synchronized (templateLoader) {
                template = this.templates.get(type);
                if (template == null) {
                    template = this.loadTemplate(type);
                    this.templates.put(type, template);
                }
            }
        }
        return template;
    }

    private String loadTemplate(String type) throws APITemplateException {
        String fileName = TEMPLATE_FILE_PREFIX + type + ".xml";
        InputStream in = this.getClass().getResourceAsStream(fileName);
        if (in != null) {
            OMXMLParserWrapper builder = null;
            try {
                builder = OMXMLBuilderFactory.createOMBuilder((InputStream)in);
                OMElement documentEl = builder.getDocumentElement();
                if (documentEl != null) {
                    this.removeIndentations(documentEl);
                    String string = documentEl.toString();
                    return string;
                }
                throw new APITemplateException("Error while parsing the template for type: " + type);
            }
            finally {
                if (builder != null) {
                    builder.close();
                }
            }
        }
        throw new APITemplateException("Unable to locate a template for type: " + type);
    }

    private void removeIndentations(OMElement element) {
        ArrayList<OMText> removables = new ArrayList<OMText>();
        this.removeIndentations(element, removables);
        for (OMText node : removables) {
            node.detach();
        }
    }

    private void removeIndentations(OMElement element, List<OMText> removables) {
        Iterator children = element.getChildren();
        while (children.hasNext()) {
            Object next = children.next();
            if (next instanceof OMText) {
                OMText text = (OMText)next;
                if (!text.getText().trim().equals("")) continue;
                removables.add(text);
                continue;
            }
            if (!(next instanceof OMElement)) continue;
            this.removeIndentations((OMElement)next, removables);
        }
    }
}

