/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.impl.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.template.APITemplateBuilder;
import org.wso2.carbon.apimgt.impl.template.APITemplateException;
import org.wso2.carbon.apimgt.impl.template.TemplateLoader;

public class BasicTemplateBuilder
implements APITemplateBuilder {
    private static final Log log = LogFactory.getLog(BasicTemplateBuilder.class);
    private TemplateLoader templateLoader = TemplateLoader.getInstance();
    private Map<String, String> apiMappings;
    private List<Map<String, String>> resourceMappings;
    private List<Map<String, String>> handlerMappings;
    private boolean blockedAPI = false;

    public BasicTemplateBuilder(Map<String, String> apiMappings, List<Map<String, String>> resourceMappings, List<Map<String, String>> handlerMappings) {
        this.apiMappings = apiMappings;
        this.resourceMappings = resourceMappings;
        this.handlerMappings = handlerMappings;
    }

    public BasicTemplateBuilder(Map<String, String> apiMappings) {
        this.apiMappings = apiMappings;
        this.blockedAPI = true;
    }

    @Override
    public String getConfigStringForTemplate() throws APITemplateException {
        String configAPI = this.constructAPIConfig();
        OMElement configAPIOM = BasicTemplateBuilder.createOMElementFrom(configAPI);
        List<String> configResources = this.constructResourceConfig();
        for (String configResource : configResources) {
            OMElement configResourceOM = BasicTemplateBuilder.createOMElementFrom(configResource);
            if (configResourceOM == null) continue;
            configAPIOM.addChild((OMNode)configResourceOM);
        }
        List<String> handlerConfigs = this.constructHandlerConfig();
        if (handlerConfigs.size() > 0) {
            OMElement handlersConfigOM = BasicTemplateBuilder.createOMElementFrom(this.templateLoader.getTemplate("handlers"));
            for (String handlerConfig : handlerConfigs) {
                OMElement configSingleHandlerOM = BasicTemplateBuilder.createOMElementFrom(handlerConfig);
                if (configSingleHandlerOM == null) continue;
                handlersConfigOM.addChild((OMNode)configSingleHandlerOM);
            }
            configAPIOM.addChild((OMNode)handlersConfigOM);
        }
        return configAPIOM.toString();
    }

    @Override
    public OMElement getConfigXMLForTemplate() throws APITemplateException {
        return BasicTemplateBuilder.createOMElementFrom(this.getConfigStringForTemplate());
    }

    private String constructAPIConfig() throws APITemplateException {
        if (this.apiMappings.containsKey("key_for_api_name") && this.apiMappings.containsKey("key_for_api_context") && this.apiMappings.containsKey("key_for_api_version")) {
            String apiTemplate = this.blockedAPI ? this.templateLoader.getTemplate("blocked_api") : this.templateLoader.getTemplate("api");
            String apiConfig = apiTemplate.toString().replaceAll("\\[1\\]", this.apiMappings.get("key_for_api_name")).replaceAll("\\[2\\]", this.apiMappings.get("key_for_api_context")).replaceAll("\\[3\\]", this.apiMappings.get("key_for_api_version"));
            return apiConfig;
        }
        this.handleException("Required API mapping not provided");
        return null;
    }

    private List<String> constructResourceConfig() throws APITemplateException {
        ArrayList<String> resourceListString = new ArrayList<String>();
        if (this.resourceMappings == null) {
            return resourceListString;
        }
        Iterator<Map<String, String>> resourceMaps = this.resourceMappings.iterator();
        int i = 0;
        while (resourceMaps.hasNext()) {
            String endpoint;
            String resourceTemplate;
            Map<String, String> singleResMap = resourceMaps.next();
            if (singleResMap != null && singleResMap.get("key_for_resource_methods") != null && singleResMap.get("key_for_resource_uri_template") != null && singleResMap.get("key_for_resource_uri") != null && singleResMap.get("key_for_resource_sandbox_uri") != null) {
                resourceTemplate = this.templateLoader.getTemplate("complex_resource");
                endpoint = StringEscapeUtils.escapeXml((String)StringEscapeUtils.unescapeXml((String)singleResMap.get("key_for_resource_uri")));
                String testEndpoint = StringEscapeUtils.escapeXml((String)StringEscapeUtils.unescapeXml((String)singleResMap.get("key_for_resource_sandbox_uri")));
                String replacedStr = resourceTemplate.replaceAll("\\[1\\]", singleResMap.get("key_for_resource_uri_template")).replaceAll("\\[2\\]", singleResMap.get("key_for_resource_methods")).replaceAll("\\[3\\]", endpoint).replaceAll("\\[4\\]", this.apiMappings.get("key_for_api_name")).replaceAll("\\[5\\]", String.valueOf(i)).replaceAll("\\[6\\]", testEndpoint);
                resourceListString.add(replacedStr);
            } else if (singleResMap != null && singleResMap.get("key_for_resource_methods") != null && singleResMap.get("key_for_resource_uri_template") != null && singleResMap.get("key_for_resource_uri") != null) {
                resourceTemplate = this.templateLoader.getTemplate("resource");
                endpoint = StringEscapeUtils.escapeXml((String)StringEscapeUtils.unescapeXml((String)singleResMap.get("key_for_resource_uri")));
                String replacedStr = resourceTemplate.replaceAll("\\[1\\]", singleResMap.get("key_for_resource_uri_template")).replaceAll("\\[2\\]", singleResMap.get("key_for_resource_methods")).replaceAll("\\[3\\]", endpoint).replaceAll("\\[4\\]", this.apiMappings.get("key_for_api_name")).replaceAll("\\[5\\]", String.valueOf(i));
                resourceListString.add(replacedStr);
            } else {
                this.handleException("Required resource mapping not provided");
            }
            ++i;
        }
        return resourceListString;
    }

    private List<String> constructHandlerConfig() throws APITemplateException {
        ArrayList<String> handlerListStr = new ArrayList<String>();
        if (this.handlerMappings == null) {
            return handlerListStr;
        }
        Iterator<Map<String, String>> handlerMaps = this.handlerMappings.iterator();
        String complexHandlerTemplate = this.templateLoader.getTemplate("complex_handler");
        String simpleHandlerTemplate = this.templateLoader.getTemplate("simple_handler");
        while (handlerMaps.hasNext()) {
            String replacedStr;
            Map<String, String> singleHandler = handlerMaps.next();
            if (singleHandler != null && singleHandler.containsKey("key_for_handler_class") && singleHandler.containsKey("key_for_handler_policy")) {
                replacedStr = complexHandlerTemplate.replaceAll("\\[1\\]", singleHandler.get("key_for_handler_class")).replaceAll("\\[2\\]", singleHandler.get("key_for_handler_policy"));
                handlerListStr.add(replacedStr);
                continue;
            }
            if (singleHandler != null && singleHandler.containsKey("key_for_handler_class")) {
                replacedStr = simpleHandlerTemplate.replaceAll("\\[1\\]", singleHandler.get("key_for_handler_class"));
                handlerListStr.add(replacedStr);
                continue;
            }
            this.handleException("Required handler mapping not provided");
        }
        return handlerListStr;
    }

    public static OMElement createOMElementFrom(String omString) throws APITemplateException {
        try {
            return AXIOMUtil.stringToOM((String)omString);
        }
        catch (XMLStreamException e) {
            String msg = "Error converting string to OMElement - String: " + omString;
            log.error((Object)msg, (Throwable)e);
            throw new APITemplateException(msg, e);
        }
    }

    private void handleException(String msg) throws APITemplateException {
        log.error((Object)msg);
        throw new APITemplateException(msg);
    }
}

